/**
 * Copyright 1998-2010 Epic Games, Inc. All Rights Reserved.
 */
class SeqEvent_MobileMotion extends SeqEvent_MobileBase
	native;

cpptext
{
	/**
	 * Called each frame.  
	 * @param Originator is a reference to the PC that caused the input
	 * @param OriginatorInput is a reference to the mobile player input assoicated with this object
	 */
	void Update(APlayerController* Originator, UMobilePlayerInput* OriginatorInput);
}

var float Roll;
var float Pitch;
var float Yaw;


var float DeltaRoll;
var float DeltaPitch;
var float DeltaYaw;


defaultproperties
{
	ObjName="Mobile Motion Access"
	ObjCategory="Input"

	OutputLinks(0)=(LinkDesc="Input Active")
	VariableLinks(0)=(ExpectedType=class'SeqVar_Float',LinkDesc="Roll",bWriteable=false,PropertyName=Roll)
	VariableLinks(1)=(ExpectedType=class'SeqVar_Float',LinkDesc="Pitch",bWriteable=false,PropertyName=Pitch)
	VariableLinks(2)=(ExpectedType=class'SeqVar_Float',LinkDesc="Yaw",bWriteable=false,PropertyName=Yaw)
	VariableLinks(3)=(ExpectedType=class'SeqVar_Float',LinkDesc="Delta Roll",bWriteable=false,PropertyName=DeltaRoll)
	VariableLinks(4)=(ExpectedType=class'SeqVar_Float',LinkDesc="Delta Pitch",bWriteable=false,PropertyName=DeltaPitch)
	VariableLinks(5)=(ExpectedType=class'SeqVar_Float',LinkDesc="Delta Yaw",bWriteable=false,PropertyName=DeltaYaw)

}