/**
 * Copyright 1998-2010 Epic Games, Inc. All Rights Reserved.
 *
 * This is the base class of all Mobile sequence events.  
 */
class SeqEvent_HudRenderImage extends SeqEvent_HudRender;

/** The color to modulate the text by */
var(HUD) LinearColor DisplayColor;

/** The Location to display the text at */
var(HUD) vector DisplayLocation;

/** The texture to display */
var(HUD) Texture2D DisplayTexture;

/** The Size of the image to display */
var(HUD) float XL, YL;

/** The UVs */
var(HUD) float U,V,UL,VL;

/** 
 * Perform the actual rendering
 */
function Render(Canvas TargetCanvas, Hud TargetHud)
{
	TargetCanvas.SetPos(DisplayLocation.X, DisplayLocation.Y);
	TargetCanvas.DrawTile(DisplayTexture,XL,YL,U,V,UL,VL,DisplayColor);
}


defaultproperties
{
	ObjName="Draw Image"
	ObjCategory="HUD"

	VariableLinks(2)=(ExpectedType=class'SeqVar_Vector',LinkDesc="Display Location",bWriteable=true,PropertyName=DisplayLocation)

}