' FaceFXPlugin
' Initial code generated by XSI SDK Wizard
' Executed Sat Jan 12 12:33:21 EST 2008 by mbarrett
' 
' 
' Tip: The wizard only exposes a small subset of the possible controls
' and layout that can be achieved on a Property Page.  To find out more
' please refer to the Object Model reference documentation for PPGLayout, PPG
' and CustomProperty
' 
' Tip: Don't be concerned about achieving the exact ordering of the parameters
' because they can easily be reordered in the second phase.
' 
' Tip: Use the "Refresh" option on the Property Page context menu to 
' reload your script changes and re-execute the DefineLayout callback.
' Tip: To add a command to this plug-in, right-click in the 
' script editor and choose Tools > Add Command.
' 
' Tip: To get help on a callback, highlight the callback name
' (for example, "Init", "Define", or "Execute") and press F1.

function XSILoadPlugin( in_reg )
	in_reg.Author = "mbarrett"
	in_reg.Name = "FxXSIUI"
	in_reg.Email = ""
	in_reg.URL = ""
	in_reg.Major = 1
	in_reg.Minor = 0        
        in_reg.Help = XSIUtils.BuildPath( in_reg.OriginPath, "FxXSI.htm")

	in_reg.RegisterProperty "FaceFX"

        in_reg.RegisterMenu  siMenuMainFileExportID, "FXA_Export",false
        in_reg.RegisterMenu  siMenuMainFileImportID, "FXA_Import",false


	'RegistrationInsertionPoint - do not remove this line

	XSILoadPlugin = true
end function

function XSIUnloadPlugin( in_reg )
	dim strPluginName
	strPluginName = in_reg.Name
	Application.LogMessage strPluginName & " has been unloaded.",siVerbose
	XSIUnloadPlugin = true
end function

function  FXA_Export_Init( in_ctxt )
   set oMenu = in_ctxt.source
   oMenu.AddCallbackItem "FXA ...", "OnFXAMenu"   
end function

function  FXA_Import_Init( in_ctxt )
   set oMenu = in_ctxt.source
   oMenu.AddCallbackItem "FXA ...", "OnFXAMenu"   
end function

   
function  OnFXAMenu( in_ctxt )
	set oFXAProp = ActiveSceneRoot.Properties("FaceFX")
	if typename(oFXAProp) <> "CustomProperty" then 
		set oFXAProp = ActiveSceneRoot.AddProperty("FaceFX")
	end if
	InspectObj oFXAProp

end function


'FaceFX property
function FaceFX_Define( in_ctxt )
	dim oCustomProperty
	set oCustomProperty = in_ctxt.Source
	oCustomProperty.AddParameter2 "ReferenceBone",siInt4,0,,,,,siClassifUnknown,siPersistable
	oCustomProperty.AddParameter2 "BonePoses",siInt4,0,,,,,siClassifUnknown,siPersistable
	oCustomProperty.AddParameter2 "AnimationGroup",siInt4,0,0,100,0,100,siClassifUnknown,siPersistable
	oCustomProperty.AddParameter2 "Animation",siInt4,0,0,100,0,100,siClassifUnknown,siPersistable
	oCustomProperty.AddParameter2 "File",siString,"None",,,,,siClassifUnknown,siPersistable
	FaceFX_Define = true
end function



function FaceFX_DefineLayout( in_ctxt )
	dim oLayout,oItem
	set oLayout = in_ctxt.Source
	oLayout.Clear 
	oLayout.AddTab "Reference Pose"
	set oItem = oLayout.AddEnumControl( "ReferenceBone",Array() , "", siControlListBox )
	oItem.SetAttribute siUICY, 80 
	oLayout.AddRow
	oLayout.AddButton "ImportReferencePose", "Import"
	oLayout.AddButton "ExportReferencePose", "Export"
	oLayout.EndRow
	oLayout.AddTab "Bone Poses"
        set oItem = oLayout.AddEnumControl( "BonePoses",Array() , "", siControlListBox )
	oItem.SetAttribute siUICY, 80 	
	oLayout.AddRow
	oLayout.AddButton "ImportBonePoses", "Import"
	oLayout.AddButton "ExportBonePoses", "Export"
        oLayout.AddButton "BatchImportBonePoses", "Batch import..."
	oLayout.AddButton "BatchExportBonePoses", "Batch export..."
	oLayout.EndRow
	oLayout.AddTab "Animations"	
        set oItem = oLayout.AddEnumControl( "AnimationGroup",Array() , "", siControlCombo)
	oItem.SetAttribute siUICY, 80 		
        set oItem = oLayout.AddEnumControl( "Animation",Array() , "", siControlListBox)
	oItem.SetAttribute siUICY, 80 	
	oLayout.AddButton "ImportAnimation", "Import"
	oLayout.AddTab "FXA"
    set oFileItem = oLayout.AddItem( "File",,siControlFilePath)
    oFileItem.SetAttribute siUIFileFilter, "FXA Files |*.fxa" 
    oFileItem.SetAttribute siUIOpenFile, true 
	oFileItem.SetAttribute siUIFileMustExist, true 			
	oFileItem.SetAttribute siUIInitialDir, Application.InstallationPath( siUserPath )
	oLayout.AddGroup
   		oLayout.AddRow
                oLayout.AddButton "OpenFXAFile", "Open"
   		oLayout.AddButton "SaveFXAFile", "Save"
		oLayout.AddButton "NewFXAFile", "New"
    	oLayout.EndRow
    oLayout.EndGroup
      
	FaceFX_DefineLayout = true
end function


function FaceFX_OpenFXAFile_OnClicked()	
        set filesys = CreateObject("Scripting.FileSystemObject") 
        if not(filesys.FileExists(PPG.File.Value)) then
          set oFileBrowser = XSIUIToolkit.FileBrowser
  
          oFileBrowser.DialogTitle = "Select a FaceFX pose batch file" ' set the title of the file browser
          oFileBrowser.InitialDirectory = Application.InstallationPath( siUserPath )
          oFileBrowser.Filter = "FXA Files (*.fxa)|*.fxa||" ' Allow selection of txt files
          oFileBrowser.ShowOpen    ' show an open file dialog
          PPG.File.Value = oFileBrowser.FilePathName          
        end if
        if filesys.FileExists(PPG.File.Value) then        
          FaceFXOpenFXA PPG.File.Value
          FaceFX_OnInit
          PPG.Refresh
        end if
end function

function FaceFX_SaveFXAFile_OnClicked()	
        bOverwrite = true
        set filesys = CreateObject("Scripting.FileSystemObject") 
        if filesys.FileExists(PPG.File.Value) then
           buttonPressed = XSIUIToolkit.Msgbox( "File already exists do you want to overwrite it ?", siMsgYesNo or siMsgQuestion, "FaceFX Save")
           if buttonPressed = siMsgNo then
             bOverwrite = false
           end if
        end if
        if bOverwrite then
          FaceFXSaveFXA PPG.File.Value	
        end if
end function

function FaceFX_OnInit()
        set oRefBonePoseItem = PPG.PPGLayout.Item("ReferenceBone")
        set oBonePosesItem = PPG.PPGLayout.Item("BonePoses")
        set oAnimationItem = PPG.PPGLayout.Item("Animation")
        set oAnimationGroupsItem = PPG.PPGLayout.Item("AnimationGroup")
        oRefBonePoseItem.UIItems =  [""]
        oBonePosesItem.UIItems = [""]
        oAnimationGroupsItem.UIItems = [""]
        oAnimationItem.UIItems = [""]
        
        sRefBonePoses = FaceFXListRefBonePoses
        if typename(sRefBonePoses) <> "Empty" then
          if ubound(sRefBonePoses) >= 0 then
            dim aRefBonePoseUI
            Redim aRefBonePoseUI(ubound(sRefBonePoses) * 2 + 1)
            for i = 0 to ubound(sRefBonePoses)
              aRefBonePoseUI(i*2) = sRefBonePoses(i)
              aRefBonePoseUI(i*2+1) = i
            next
            oRefBonePoseItem.UIItems = aRefBonePoseUI
          end if 
        end if
        sBonePoses = FaceFXGetNodes("FxBonePoseNode")   
        if typename(sBonePoses) <> "Empty" then
          if ubound(sBonePoses) >= 0 then
            dim aBonePosesUI
            Redim aBonePosesUI(ubound(sBonePoses) * 2 + 1)
            for i = 0 to ubound(sBonePoses)
              aBonePosesUI(i*2) = sBonePoses(i)
              aBonePosesUI(i*2+1) = i
            next
            oBonePosesItem.UIItems = aBonePosesUI
          end if 
        end if
        sAnimationGroups = FaceFXListAnimationGroups
        if typename(sAnimationGroups) <> "Empty" then
          if ubound(sAnimationGroups ) >= 0 then
            dim aAnimationGroupsUI
            Redim aAnimationGroupsUI(ubound(sAnimationGroups) * 2 + 1)
            for i = 0 to ubound(sAnimationGroups)
              aAnimationGroupsUI(i*2) = sAnimationGroups(i)
              aAnimationGroupsUI(i*2+1) = i
            next
            oAnimationGroupsItem.UIItems = aAnimationGroupsUI
            
            sAnimations = FaceFXListAnimationsFromGroup(sAnimationGroups(0))
            if Ubound(sAnimations) >= 0 then
              dim aAnimationUI
              Redim aAnimationUI(ubound(sAnimations) * 2 + 1)
              for i = 0 to ubound(sAnimations)
                aAnimationUI(i*2) = sAnimations(i)
                aAnimationUI(i*2+1) = i
              next
              oAnimationItem.UIItems = aAnimationUI            
            end if 
          end if 
        end if        
        PPG.Refresh
end function

function FaceFX_ImportReferencePose_OnClicked()                
	FaceFXImportRefBonePose Dictionary.GetObject("PlayControl").Current.value	
end function

function FaceFX_ExportReferencePose_OnClicked()
	FaceFXExportRefBonePose
        PPG.Refresh
end function

function FaceFX_ImportBonePoses_OnClicked()
        set oBonePoseItem = PPG.PPGLayout.Item("BonePoses")
        aUIItems = oBonePoseItem.UIitems
        poseName = aUIItems(PPG.BonePoses.value*2)
	FaceFXImportBonePose poseName, Dictionary.GetObject("PlayControl").Current.value	        
end function


function FaceFX_ExportBonePoses_OnClicked() 
        poseName = InputBox("Pose name", "FaceFX new pose name","poseActor")  
        if poseName <> "" then     
	        FaceFXExportBonePose Dictionary.GetObject("PlayControl").Current.value, poseName
	    end if
        PPG.Refresh
end function

function ShowDialogFileOpen()
  set oFileBrowser = XSIUIToolkit.FileBrowser

  oFileBrowser.DialogTitle = "Select a FaceFX pose batch file" ' set the title of the file browser
  oFileBrowser.InitialDirectory = Application.InstallationPath( siUserPath )
  oFileBrowser.Filter = "All Files (*.txt)|*.txt||" ' Allow selection of txt files
  oFileBrowser.ShowOpen    ' show an open file dialog

  ShowDialogFileOpen = oFileBrowser.FilePathName
end function

function FaceFX_BatchImportBonePoses_OnClicked()         
        fileName = ShowDialogFileOpen()
        if fileName <> "" then
          FaceFXBatchImportBonePoses fileName
        end if
end function

function FaceFX_BatchExportBonePoses_OnClicked()        
        fileName = ShowDialogFileOpen()
        if fileName <> "" then
          FaceFXBatchExportBonePoses fileName
        end if
        PPG.Refresh         
end function

function FaceFX_ImportAnimation_OnClicked()
	set oAnimationGroupItem = PPG.PPGLayout.Item("AnimationGroup")
        aUIItemsOld = oAnimationGroupItem.UIitems
        animGroupName = aUIItemsOld(PPG.AnimationGroup.Value *2)
        set oAnimations = PPG.PPGLayout.Item("Animation")
        aUIItemsAnimation = oAnimations.UIitems
        animationName = aUIItemsAnimation(PPG.Animation.Value*2)
        FaceFXImportAnimation animGroupName, animationName, Application.ActiveProject.Properties("Play Control").Rate.Value
end function



function FaceFX_NewFXAFile_OnClicked()
        actorName = InputBox("New actor name", "FaceFX new actor name","newActor")         
	FaceFXNewFXA actorName
	FaceFX_OnInit
        PPG.File.value = actorName & ".fxa"
        PPG.Refresh
end function




function FaceFX_AnimationGroup_OnChanged()
        set oAnimationGroupItem = PPG.PPGLayout.Item("AnimationGroup")
        aUIItemsOld = oAnimationGroupItem.UIitems
        animGroupName = aUIItemsOld(PPG.AnimationGroup.Value *2)
        sAnimations =  FaceFXListAnimationsFromGroup(animGroupName)                      
        dim aUIItems
        Redim aUIItems(ubound(sAnimations) *2 +1)
        for i = 0 to ubound(sAnimations)          
          aUIItems(i*2) = sAnimations(i)
          aUIItems(i*2+1) = i
        next
        set oAnimations = PPG.PPGLayout.Item("Animation")
        oAnimations.UIitems = aUIItems        
	PPG.Refresh
end function

