/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.dfa;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.dfa.IDataFlowNode;
import net.sourceforge.pmd.dfa.variableaccess.VariableAccess;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataFlowNode
implements IDataFlowNode {
    private SimpleNode node;
    private Map<Integer, String> typeMap = new HashMap<Integer, String>();
    protected List<DataFlowNode> parents = new ArrayList<DataFlowNode>();
    protected List<DataFlowNode> children = new ArrayList<DataFlowNode>();
    protected BitSet type = new BitSet();
    protected List<VariableAccess> variableAccess = new ArrayList<VariableAccess>();
    protected LinkedList<DataFlowNode> dataFlow;
    protected int line;

    protected DataFlowNode() {
    }

    public DataFlowNode(SimpleNode node, LinkedList<DataFlowNode> dataFlow) {
        this.dataFlow = dataFlow;
        this.node = node;
        node.setDataFlowNode(this);
        this.line = node.getBeginLine();
        if (!this.dataFlow.isEmpty()) {
            DataFlowNode parent = this.dataFlow.getLast();
            parent.addPathToChild(this);
        }
        this.dataFlow.addLast(this);
    }

    @Override
    public void addPathToChild(IDataFlowNode child) {
        DataFlowNode thisChild = (DataFlowNode)child;
        if (!this.children.contains(thisChild) || this.equals(thisChild)) {
            this.children.add(thisChild);
            thisChild.parents.add(this);
        }
    }

    @Override
    public boolean removePathToChild(IDataFlowNode child) {
        DataFlowNode thisChild = (DataFlowNode)child;
        thisChild.parents.remove(this);
        return this.children.remove(thisChild);
    }

    @Override
    public void reverseParentPathsTo(IDataFlowNode destination) {
        while (!this.parents.isEmpty()) {
            DataFlowNode parent = this.parents.get(0);
            parent.removePathToChild(this);
            parent.addPathToChild(destination);
        }
    }

    @Override
    public int getLine() {
        return this.line;
    }

    public void setType(int type) {
        this.type.set(type);
    }

    @Override
    public boolean isType(int intype) {
        try {
            return this.type.get(intype);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public SimpleNode getSimpleNode() {
        return this.node;
    }

    public List<DataFlowNode> getChildren() {
        return this.children;
    }

    public List<DataFlowNode> getParents() {
        return this.parents;
    }

    public List<DataFlowNode> getFlow() {
        return this.dataFlow;
    }

    @Override
    public int getIndex() {
        return this.dataFlow.indexOf(this);
    }

    @Override
    public void setVariableAccess(List<VariableAccess> variableAccess) {
        if (this.variableAccess.isEmpty()) {
            this.variableAccess = variableAccess;
        } else {
            this.variableAccess.addAll(variableAccess);
        }
    }

    @Override
    public List<VariableAccess> getVariableAccess() {
        return this.variableAccess;
    }

    public String toString() {
        String res = new StringBuffer().append("DataFlowNode: line ").append(this.getLine()).append(", ").toString();
        if (this.node instanceof ASTMethodDeclaration || this.node instanceof ASTConstructorDeclaration) {
            res = new StringBuffer().append(res).append(this.node instanceof ASTMethodDeclaration ? "(method)" : "(constructor)").toString();
        } else {
            String tmp = this.type.toString();
            String newTmp = "";
            for (char c : tmp.toCharArray()) {
                if (c == '{' || c == '}' || c == ' ') continue;
                newTmp = new StringBuffer().append(newTmp).append(c).toString();
            }
            StringTokenizer st = new StringTokenizer(newTmp, ",");
            while (st.hasMoreTokens()) {
                int newTmpInt = Integer.parseInt(st.nextToken());
                res = new StringBuffer().append(res).append("(").append(this.stringFromType(newTmpInt)).append(")").toString();
            }
            res = new StringBuffer().append(res).append(", ").append(this.node.getClass().getName().substring(this.node.getClass().getName().lastIndexOf(46) + 1)).toString();
            res = new StringBuffer().append(res).append(this.node.getImage() == null ? "" : new StringBuffer().append("(").append(this.node.getImage()).append(")").toString()).toString();
        }
        return res;
    }

    private String stringFromType(int intype) {
        if (this.typeMap.isEmpty()) {
            this.typeMap.put(Integer_.valueOf((int)1), "IF_EXPR");
            this.typeMap.put(Integer_.valueOf((int)2), "IF_LAST_STATEMENT");
            this.typeMap.put(Integer_.valueOf((int)3), "IF_LAST_STATEMENT_WITHOUT_ELSE");
            this.typeMap.put(Integer_.valueOf((int)4), "ELSE_LAST_STATEMENT");
            this.typeMap.put(Integer_.valueOf((int)11), "WHILE_LAST_STATEMENT");
            this.typeMap.put(Integer_.valueOf((int)10), "WHILE_EXPR");
            this.typeMap.put(Integer_.valueOf((int)20), "SWITCH_START");
            this.typeMap.put(Integer_.valueOf((int)21), "CASE_LAST_STATEMENT");
            this.typeMap.put(Integer_.valueOf((int)22), "SWITCH_LAST_DEFAULT_STATEMENT");
            this.typeMap.put(Integer_.valueOf((int)23), "SWITCH_END");
            this.typeMap.put(Integer_.valueOf((int)30), "FOR_INIT");
            this.typeMap.put(Integer_.valueOf((int)31), "FOR_EXPR");
            this.typeMap.put(Integer_.valueOf((int)32), "FOR_UPDATE");
            this.typeMap.put(Integer_.valueOf((int)33), "FOR_BEFORE_FIRST_STATEMENT");
            this.typeMap.put(Integer_.valueOf((int)34), "FOR_END");
            this.typeMap.put(Integer_.valueOf((int)40), "DO_BEFORE_FIRST_STATEMENT");
            this.typeMap.put(Integer_.valueOf((int)41), "DO_EXPR");
            this.typeMap.put(Integer_.valueOf((int)50), "RETURN_STATEMENT");
            this.typeMap.put(Integer_.valueOf((int)51), "BREAK_STATEMENT");
            this.typeMap.put(Integer_.valueOf((int)52), "CONTINUE_STATEMENT");
            this.typeMap.put(Integer_.valueOf((int)60), "LABEL_STATEMENT");
            this.typeMap.put(Integer_.valueOf((int)61), "LABEL_END");
            this.typeMap.put(Integer_.valueOf((int)70), "THROW_STATEMENT");
        }
        if (!this.typeMap.containsKey(Integer_.valueOf((int)intype))) {
            throw new RuntimeException(new StringBuffer().append("Couldn't find type id ").append(intype).toString());
        }
        return this.typeMap.get(Integer_.valueOf((int)intype));
    }
}

