/*
 * Decompiled with CFR 0.152.
 */
package org.yecht.ruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.yecht.Parser;
import org.yecht.ParserInput;
import org.yecht.Pointer;
import org.yecht.ruby.RubyBadAnchorHandler;
import org.yecht.ruby.RubyErrHandler;
import org.yecht.ruby.RubyIoStrRead;
import org.yecht.ruby.RubyLoadHandler;
import org.yecht.ruby.YAMLExtra;

public class YParser {
    public static final ObjectAllocator Allocator = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            Parser parser = Parser.newParser();
            parser.bonus = new Extra();
            RubyObject.Data pobj = runtime2.newData(klass, parser);
            parser.setRootOnError(runtime2.getNil());
            return pobj;
        }
    };

    public static boolean assignIO(Ruby runtime2, Parser parser, IRubyObject[] pport) {
        boolean taint2 = true;
        IRubyObject port = pport[0];
        IRubyObject tmp = port.checkStringType();
        if (!tmp.isNil()) {
            taint2 = port.isTaint();
            port = tmp;
            ByteList bl = ((RubyString)port).getByteList();
            parser.str(Pointer.create(bl.bytes, bl.begin), bl.realSize, null);
        } else if (port.respondsTo("read")) {
            if (port.respondsTo("binmode")) {
                port.callMethod(runtime2.getCurrentContext(), "binmode");
            }
            parser.str(Pointer.empty(), 0, new RubyIoStrRead(port));
        } else {
            throw runtime2.newTypeError("instance of IO needed");
        }
        pport[0] = port;
        return taint2;
    }

    public static void setModel(IRubyObject p2, IRubyObject input, IRubyObject model) {
        Ruby runtime2 = p2.getRuntime();
        Parser parser = (Parser)p2.dataGetStructChecked();
        parser.handler(new RubyLoadHandler(runtime2, (YAMLExtra)runtime2.getModule("YAML").dataGetStruct()));
        if (model == runtime2.newSymbol("Generic")) {
            p2.callMethod(runtime2.getCurrentContext(), "set_resolver", ((RubyModule)runtime2.getModule("YAML").getConstant("Yecht")).getConstant("GenericResolver"));
        }
        parser.implicitTyping(true);
        parser.taguriExpansion(true);
        if (input.isNil()) {
            input = ((RubyObject)p2).fastGetInstanceVariable("@input");
        }
        if (input == runtime2.newSymbol("bytecode")) {
            parser.setInputType(ParserInput.Bytecode_UTF8);
        } else {
            parser.setInputType(ParserInput.YAML_UTF8);
        }
        parser.errorHandler(new RubyErrHandler(runtime2));
        parser.badAnchorHandler(new RubyBadAnchorHandler(runtime2));
    }

    @JRubyMethod(optional=1)
    public static IRubyObject initialize(IRubyObject self, IRubyObject[] args2) {
        RubyHash options2 = null;
        options2 = args2.length == 0 ? RubyHash.newHash(self.getRuntime()) : args2[0].convertToHash();
        ((RubyObject)self).fastSetInstanceVariable("@options", options2);
        ((RubyObject)self).fastSetInstanceVariable("@input", self.getRuntime().getNil());
        ((RubyObject)self).fastSetInstanceVariable("@resolver", self.getRuntime().getNil());
        return self;
    }

    @JRubyMethod(name={"bufsize="})
    public static IRubyObject bufsize_set(IRubyObject self, IRubyObject size2) {
        if (size2.respondsTo("to_i")) {
            int n = RubyNumeric.fix2int(size2.callMethod(self.getRuntime().getCurrentContext(), "to_i"));
            Parser p2 = (Parser)self.dataGetStructChecked();
            p2.bufsize = n;
        }
        return self;
    }

    @JRubyMethod
    public static IRubyObject bufsize(IRubyObject self) {
        Parser p2 = (Parser)self.dataGetStructChecked();
        return self.getRuntime().newFixnum(p2.bufsize);
    }

    @JRubyMethod(required=1, optional=1)
    public static IRubyObject load(IRubyObject self, IRubyObject[] args2) {
        Ruby runtime2 = self.getRuntime();
        ThreadContext ctx = runtime2.getCurrentContext();
        IRubyObject port = args2[0];
        IRubyObject proc2 = null;
        proc2 = args2.length > 1 ? args2[1] : runtime2.getNil();
        IRubyObject input = ((RubyHash)self.callMethod(ctx, "options")).op_aref(ctx, runtime2.newSymbol("input"));
        IRubyObject model = ((RubyHash)self.callMethod(ctx, "options")).op_aref(ctx, runtime2.newSymbol("Model"));
        Parser parser = (Parser)self.dataGetStructChecked();
        YParser.setModel(self, input, model);
        Extra bonus = (Extra)parser.bonus;
        bonus.taint = YParser.assignIO(runtime2, parser, new IRubyObject[]{port});
        parser.setRootOnError(runtime2.getNil());
        bonus.data = RubyHash.newHash(runtime2);
        bonus.resolver = self.callMethod(ctx, "resolver");
        bonus.proc = proc2.isNil() ? null : proc2;
        IRubyObject result = (IRubyObject)parser.parse();
        if (result == null) {
            result = runtime2.getFalse();
        }
        return result;
    }

    @JRubyMethod(frame=true)
    public static IRubyObject load_documents(IRubyObject self, IRubyObject port, Block proc2) {
        Ruby runtime2 = self.getRuntime();
        ThreadContext ctx = runtime2.getCurrentContext();
        IRubyObject input = ((RubyHash)self.callMethod(ctx, "options")).op_aref(ctx, runtime2.newSymbol("input"));
        IRubyObject model = ((RubyHash)self.callMethod(ctx, "options")).op_aref(ctx, runtime2.newSymbol("Model"));
        Parser parser = (Parser)self.dataGetStructChecked();
        YParser.setModel(self, input, model);
        Extra bonus = (Extra)parser.bonus;
        bonus.taint = YParser.assignIO(runtime2, parser, new IRubyObject[]{port});
        parser.setRootOnError(runtime2.getNil());
        bonus.resolver = self.callMethod(ctx, "resolver");
        bonus.proc = null;
        while (true) {
            bonus.data = RubyHash.newHash(runtime2);
            IRubyObject v = (IRubyObject)parser.parse();
            if (parser.eof) {
                return runtime2.getNil();
            }
            if (v == null) {
                v = runtime2.getFalse();
            }
            proc2.yield(ctx, v);
        }
    }

    @JRubyMethod
    public static IRubyObject set_resolver(IRubyObject self, IRubyObject resolver) {
        ((RubyObject)self).fastSetInstanceVariable("@resolver", resolver);
        return self;
    }

    public static class Extra {
        public IRubyObject data;
        public IRubyObject proc;
        public IRubyObject resolver;
        public boolean taint;
    }
}

