/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.util;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyKernel;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DSymbolNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.LiteralNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.MultipleAsgn19Node;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.OptArgNode;
import org.jruby.ast.UnnamedRestArgNode;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.compiler.ASTInspector;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.Unrescuable;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.internal.runtime.methods.WrapperMethod;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaUtil;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.SimpleSourcePosition;
import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.LocalStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CompiledBlock;
import org.jruby.runtime.CompiledBlock19;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.CompiledBlockCallback19;
import org.jruby.runtime.CompiledBlockLight;
import org.jruby.runtime.CompiledBlockLight19;
import org.jruby.runtime.CompiledSharedScopeBlock;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Interpreted19Block;
import org.jruby.runtime.InterpretedBlock;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.TypeConverter;
import org.jruby.util.unsafe.UnsafeFactory;

public class RuntimeHelpers {
    public static final int MAX_SPECIFIC_ARITY_OBJECT_ARRAY = 5;
    public static final int MAX_SPECIFIC_ARITY_HASH = 3;

    public static CallSite selectAttrAsgnCallSite(IRubyObject receiver2, IRubyObject self, CallSite normalSite, CallSite variableSite) {
        if (receiver2 == self) {
            return variableSite;
        }
        return normalSite;
    }

    public static IRubyObject doAttrAsgn(IRubyObject receiver2, CallSite callSite, IRubyObject value2, ThreadContext context, IRubyObject caller2) {
        callSite.call(context, caller2, receiver2, value2);
        return value2;
    }

    public static IRubyObject doAttrAsgn(IRubyObject receiver2, CallSite callSite, IRubyObject arg0, IRubyObject value2, ThreadContext context, IRubyObject caller2) {
        callSite.call(context, caller2, receiver2, arg0, value2);
        return value2;
    }

    public static IRubyObject doAttrAsgn(IRubyObject receiver2, CallSite callSite, IRubyObject arg0, IRubyObject arg1, IRubyObject value2, ThreadContext context, IRubyObject caller2) {
        callSite.call(context, caller2, receiver2, arg0, arg1, value2);
        return value2;
    }

    public static IRubyObject doAttrAsgn(IRubyObject receiver2, CallSite callSite, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject value2, ThreadContext context, IRubyObject caller2) {
        callSite.call(context, caller2, receiver2, arg0, arg1, arg2, value2);
        return value2;
    }

    public static IRubyObject doAttrAsgn(IRubyObject receiver2, CallSite callSite, IRubyObject[] args2, ThreadContext context, IRubyObject caller2) {
        callSite.call(context, caller2, receiver2, args2);
        return args2[args2.length - 1];
    }

    public static IRubyObject doAttrAsgn(IRubyObject receiver2, CallSite callSite, IRubyObject[] args2, IRubyObject value2, ThreadContext context, IRubyObject caller2) {
        IRubyObject[] newArgs = new IRubyObject[args2.length + 1];
        System.arraycopy(args2, 0, newArgs, 0, args2.length);
        newArgs[args2.length] = value2;
        callSite.call(context, caller2, receiver2, newArgs);
        return value2;
    }

    public static boolean invokeEqqForCaseWhen(CallSite callSite, ThreadContext context, IRubyObject caller2, IRubyObject arg2, IRubyObject[] receivers) {
        for (int i2 = 0; i2 < receivers.length; ++i2) {
            IRubyObject receiver2 = receivers[i2];
            if (!RuntimeHelpers.invokeEqqForCaseWhen(callSite, context, caller2, arg2, receiver2)) continue;
            return true;
        }
        return false;
    }

    public static boolean invokeEqqForCaseWhen(CallSite callSite, ThreadContext context, IRubyObject caller2, IRubyObject arg2, IRubyObject receiver2) {
        IRubyObject result = callSite.call(context, caller2, receiver2, arg2);
        return result.isTrue();
    }

    public static boolean invokeEqqForCaseWhen(CallSite callSite, ThreadContext context, IRubyObject caller2, IRubyObject arg2, IRubyObject receiver0, IRubyObject receiver1) {
        IRubyObject result = callSite.call(context, caller2, receiver0, arg2);
        if (result.isTrue()) {
            return true;
        }
        return RuntimeHelpers.invokeEqqForCaseWhen(callSite, context, caller2, arg2, receiver1);
    }

    public static boolean invokeEqqForCaseWhen(CallSite callSite, ThreadContext context, IRubyObject caller2, IRubyObject arg2, IRubyObject receiver0, IRubyObject receiver1, IRubyObject receiver2) {
        IRubyObject result = callSite.call(context, caller2, receiver0, arg2);
        if (result.isTrue()) {
            return true;
        }
        return RuntimeHelpers.invokeEqqForCaseWhen(callSite, context, caller2, arg2, receiver1, receiver2);
    }

    public static boolean areAnyTrueForCaselessWhen(IRubyObject[] receivers) {
        for (int i2 = 0; i2 < receivers.length; ++i2) {
            if (!receivers[i2].isTrue()) continue;
            return true;
        }
        return false;
    }

    public static boolean invokeEqqForCaselessWhen(IRubyObject receiver2) {
        return receiver2.isTrue();
    }

    public static boolean invokeEqqForCaselessWhen(IRubyObject receiver0, IRubyObject receiver1) {
        return receiver0.isTrue() || receiver1.isTrue();
    }

    public static boolean invokeEqqForCaselessWhen(IRubyObject receiver0, IRubyObject receiver1, IRubyObject receiver2) {
        return receiver0.isTrue() || receiver1.isTrue() || receiver2.isTrue();
    }

    public static CompiledBlockCallback createBlockCallback(Ruby runtime2, Object scriptObject, String closureMethod, String file2, int line) {
        Class<?> scriptClass = scriptObject.getClass();
        ClassLoader scriptClassLoader = scriptClass.getClassLoader();
        MethodFactory factory = MethodFactory.createFactory(scriptClassLoader);
        return factory.getBlockCallback(closureMethod, file2, line, scriptObject);
    }

    public static CompiledBlockCallback19 createBlockCallback19(Ruby runtime2, Object scriptObject, String closureMethod, String file2, int line) {
        Class<?> scriptClass = scriptObject.getClass();
        ClassLoader scriptClassLoader = scriptClass.getClassLoader();
        MethodFactory factory = MethodFactory.createFactory(scriptClassLoader);
        return factory.getBlockCallback19(closureMethod, file2, line, scriptObject);
    }

    public static byte[] createBlockCallbackOffline(String classPath, String closureMethod, String file2, int line) {
        MethodFactory factory = MethodFactory.createFactory(RuntimeHelpers.class.getClassLoader());
        return factory.getBlockCallbackOffline(closureMethod, file2, line, classPath);
    }

    public static byte[] createBlockCallback19Offline(String classPath, String closureMethod, String file2, int line) {
        MethodFactory factory = MethodFactory.createFactory(RuntimeHelpers.class.getClassLoader());
        return factory.getBlockCallback19Offline(closureMethod, file2, line, classPath);
    }

    public static String buildBlockDescriptor19(String closureMethod, int arity2, StaticScope scope, String file2, int line, boolean hasMultipleArgsHead, NodeType argsNodeId, String parameterList, ASTInspector inspector) {
        return RuntimeHelpers.buildBlockDescriptor(closureMethod, arity2, scope, file2, line, hasMultipleArgsHead, argsNodeId, inspector) + "," + parameterList;
    }

    public static String buildBlockDescriptor(String closureMethod, int arity2, StaticScope scope, String file2, int line, boolean hasMultipleArgsHead, NodeType argsNodeId, ASTInspector inspector) {
        StringBuffer scopeNames = new StringBuffer();
        for (int i2 = 0; i2 < scope.getVariables().length; ++i2) {
            if (i2 != 0) {
                scopeNames.append(';');
            }
            scopeNames.append(scope.getVariables()[i2]);
        }
        String descriptor = closureMethod + ',' + arity2 + ',' + scopeNames + ',' + hasMultipleArgsHead + ',' + BlockBody.asArgumentType(argsNodeId) + ',' + file2 + ',' + line + ',' + (!inspector.hasClosure() && !inspector.hasScopeAwareMethods());
        return descriptor;
    }

    public static String[][] parseBlockDescriptor(String descriptor) {
        String[] secondSplit;
        String[] firstSplit = descriptor.split(",");
        if (firstSplit[2].length() == 0) {
            secondSplit = new String[]{};
        } else {
            secondSplit = firstSplit[2].split(";");
            for (int i2 = 0; i2 < secondSplit.length; ++i2) {
                secondSplit[i2] = secondSplit[i2].intern();
            }
        }
        return new String[][]{firstSplit, secondSplit};
    }

    public static BlockBody createCompiledBlockBody(ThreadContext context, Object scriptObject, String descriptor) {
        String[][] splitDesc = RuntimeHelpers.parseBlockDescriptor(descriptor);
        String[] firstSplit = splitDesc[0];
        String[] secondSplit = splitDesc[1];
        return RuntimeHelpers.createCompiledBlockBody(context, scriptObject, firstSplit[0], Integer.parseInt(firstSplit[1]), secondSplit, Boolean.valueOf(firstSplit[3]), Integer.parseInt(firstSplit[4]), firstSplit[5], Integer.parseInt(firstSplit[6]), Boolean.valueOf(firstSplit[7]));
    }

    public static BlockBody createCompiledBlockBody(ThreadContext context, Object scriptObject, String closureMethod, int arity2, String[] staticScopeNames, boolean hasMultipleArgsHead, int argsNodeType, String file2, int line, boolean light) {
        BlockStaticScope staticScope = new BlockStaticScope(context.getCurrentScope().getStaticScope(), staticScopeNames);
        staticScope.determineModule();
        if (light) {
            return CompiledBlockLight.newCompiledBlockLight(Arity.createArity(arity2), staticScope, RuntimeHelpers.createBlockCallback(context.getRuntime(), scriptObject, closureMethod, file2, line), hasMultipleArgsHead, argsNodeType);
        }
        return CompiledBlock.newCompiledBlock(Arity.createArity(arity2), staticScope, RuntimeHelpers.createBlockCallback(context.getRuntime(), scriptObject, closureMethod, file2, line), hasMultipleArgsHead, argsNodeType);
    }

    public static BlockBody createCompiledBlockBody19(ThreadContext context, Object scriptObject, String descriptor) {
        String[][] splitDesc = RuntimeHelpers.parseBlockDescriptor(descriptor);
        String[] firstSplit = splitDesc[0];
        String[] secondSplit = splitDesc[1];
        return RuntimeHelpers.createCompiledBlockBody19(context, scriptObject, firstSplit[0], Integer.parseInt(firstSplit[1]), secondSplit, Boolean.valueOf(firstSplit[3]), Integer.parseInt(firstSplit[4]), firstSplit[5], Integer.parseInt(firstSplit[6]), Boolean.valueOf(firstSplit[7]), firstSplit[8]);
    }

    public static BlockBody createCompiledBlockBody19(ThreadContext context, Object scriptObject, String closureMethod, int arity2, String[] staticScopeNames, boolean hasMultipleArgsHead, int argsNodeType, String file2, int line, boolean light, String parameterList) {
        BlockStaticScope staticScope = new BlockStaticScope(context.getCurrentScope().getStaticScope(), staticScopeNames);
        staticScope.determineModule();
        if (light) {
            return CompiledBlockLight19.newCompiledBlockLight(Arity.createArity(arity2), staticScope, RuntimeHelpers.createBlockCallback19(context.getRuntime(), scriptObject, closureMethod, file2, line), hasMultipleArgsHead, argsNodeType, parameterList.split(";"));
        }
        return CompiledBlock19.newCompiledBlock(Arity.createArity(arity2), staticScope, RuntimeHelpers.createBlockCallback19(context.getRuntime(), scriptObject, closureMethod, file2, line), hasMultipleArgsHead, argsNodeType, parameterList.split(";"));
    }

    public static Block createBlock(ThreadContext context, IRubyObject self, BlockBody body) {
        return CompiledBlock.newCompiledClosure(context, self, body);
    }

    public static Block createBlock19(ThreadContext context, IRubyObject self, BlockBody body) {
        return CompiledBlock19.newCompiledClosure(context, self, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject runBeginBlock(ThreadContext context, IRubyObject self, String scopeString, CompiledBlockCallback callback) {
        BlockStaticScope staticScope = RuntimeHelpers.decodeBlockScope(context, scopeString);
        staticScope.determineModule();
        context.preScopedBody(DynamicScope.newDynamicScope(staticScope, context.getCurrentScope()));
        Block block = CompiledBlock.newCompiledClosure(context, self, Arity.createArity(0), staticScope, callback, false, 0);
        try {
            block.yield(context, null);
        }
        finally {
            context.postScopedBody();
        }
        return context.getRuntime().getNil();
    }

    public static Block createSharedScopeBlock(ThreadContext context, IRubyObject self, int arity2, CompiledBlockCallback callback, boolean hasMultipleArgsHead, int argsNodeType) {
        return CompiledSharedScopeBlock.newCompiledSharedScopeClosure(context, self, Arity.createArity(arity2), context.getCurrentScope(), callback, hasMultipleArgsHead, argsNodeType);
    }

    public static IRubyObject def(ThreadContext context, IRubyObject self, Object scriptObject, String name2, String javaName, String scopeString, int arity2, String filename2, int line, CallConfiguration callConfig, String parameterDesc) {
        Class<?> compiledClass = scriptObject.getClass();
        Ruby runtime2 = context.getRuntime();
        RubyModule containingClass = context.getRubyClass();
        Visibility visibility = context.getCurrentVisibility();
        RuntimeHelpers.performNormalMethodChecks(containingClass, runtime2, name2);
        StaticScope scope = RuntimeHelpers.createScopeForClass(context, scopeString);
        MethodFactory factory = MethodFactory.createFactory(compiledClass.getClassLoader());
        DynamicMethod method2 = RuntimeHelpers.constructNormalMethod(factory, javaName, name2, containingClass, new SimpleSourcePosition(filename2, line), arity2, scope, visibility, scriptObject, callConfig, parameterDesc);
        RuntimeHelpers.addInstanceMethod(containingClass, name2, method2, visibility, context, runtime2);
        return runtime2.getNil();
    }

    public static IRubyObject defs(ThreadContext context, IRubyObject self, IRubyObject receiver2, Object scriptObject, String name2, String javaName, String scopeString, int arity2, String filename2, int line, CallConfiguration callConfig, String parameterDesc) {
        Class<?> compiledClass = scriptObject.getClass();
        Ruby runtime2 = context.getRuntime();
        RubyClass rubyClass = RuntimeHelpers.performSingletonMethodChecks(runtime2, receiver2, name2);
        StaticScope scope = RuntimeHelpers.createScopeForClass(context, scopeString);
        MethodFactory factory = MethodFactory.createFactory(compiledClass.getClassLoader());
        DynamicMethod method2 = RuntimeHelpers.constructSingletonMethod(factory, javaName, rubyClass, new SimpleSourcePosition(filename2, line), arity2, scope, scriptObject, callConfig, parameterDesc);
        rubyClass.addMethod(name2, method2);
        RuntimeHelpers.callSingletonMethodHook(receiver2, context, runtime2.fastNewSymbol(name2));
        return runtime2.getNil();
    }

    public static byte[] defOffline(String name2, String classPath, String invokerName, Arity arity2, StaticScope scope, CallConfiguration callConfig, String filename2, int line) {
        MethodFactory factory = MethodFactory.createFactory(RuntimeHelpers.class.getClassLoader());
        byte[] methodBytes = factory.getCompiledMethodOffline(name2, classPath, invokerName, arity2, scope, callConfig, filename2, line);
        return methodBytes;
    }

    public static RubyClass getSingletonClass(Ruby runtime2, IRubyObject receiver2) {
        if (receiver2 instanceof RubyFixnum || receiver2 instanceof RubySymbol) {
            throw runtime2.newTypeError("no virtual class for " + receiver2.getMetaClass().getBaseName());
        }
        if (runtime2.getSafeLevel() >= 4 && !receiver2.isTaint()) {
            throw runtime2.newSecurityError("Insecure: can't extend object.");
        }
        return receiver2.getSingletonClass();
    }

    public static IRubyObject invokeMethodMissing(IRubyObject receiver2, String name2, IRubyObject[] args2) {
        ThreadContext context = receiver2.getRuntime().getCurrentContext();
        context.setLastCallStatusAndVisibility(CallType.FUNCTIONAL, Visibility.PUBLIC);
        if (name2.equals("method_missing")) {
            return RubyKernel.method_missing(context, receiver2, args2, Block.NULL_BLOCK);
        }
        IRubyObject[] newArgs = RuntimeHelpers.prepareMethodMissingArgs(args2, context, name2);
        return RuntimeHelpers.invoke(context, receiver2, "method_missing", newArgs, Block.NULL_BLOCK);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver2, Visibility visibility, String name2, CallType callType, IRubyObject[] args2, Block block) {
        return RuntimeHelpers.selectMethodMissing(context, receiver2, visibility, name2, callType).call(context, receiver2, (RubyModule)receiver2.getMetaClass(), name2, args2, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver2, Visibility visibility, String name2, CallType callType, IRubyObject arg0, Block block) {
        return RuntimeHelpers.selectMethodMissing(context, receiver2, visibility, name2, callType).call(context, receiver2, (RubyModule)receiver2.getMetaClass(), name2, arg0, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver2, Visibility visibility, String name2, CallType callType, IRubyObject arg0, IRubyObject arg1, Block block) {
        return RuntimeHelpers.selectMethodMissing(context, receiver2, visibility, name2, callType).call(context, receiver2, (RubyModule)receiver2.getMetaClass(), name2, arg0, arg1, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver2, Visibility visibility, String name2, CallType callType, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return RuntimeHelpers.selectMethodMissing(context, receiver2, visibility, name2, callType).call(context, receiver2, (RubyModule)receiver2.getMetaClass(), name2, arg0, arg1, arg2, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver2, Visibility visibility, String name2, CallType callType, Block block) {
        return RuntimeHelpers.selectMethodMissing(context, receiver2, visibility, name2, callType).call(context, receiver2, (RubyModule)receiver2.getMetaClass(), name2, block);
    }

    public static DynamicMethod selectMethodMissing(ThreadContext context, IRubyObject receiver2, Visibility visibility, String name2, CallType callType) {
        Ruby runtime2 = context.getRuntime();
        if (name2.equals("method_missing")) {
            return RuntimeHelpers.selectInternalMM(runtime2, visibility, callType);
        }
        DynamicMethod methodMissing = receiver2.getMetaClass().searchMethod("method_missing");
        if (methodMissing.isUndefined() || methodMissing == runtime2.getDefaultMethodMissing()) {
            return RuntimeHelpers.selectInternalMM(runtime2, visibility, callType);
        }
        return new MethodMissingMethod(methodMissing, callType);
    }

    public static DynamicMethod selectMethodMissing(ThreadContext context, RubyClass selfClass, Visibility visibility, String name2, CallType callType) {
        Ruby runtime2 = context.getRuntime();
        if (name2.equals("method_missing")) {
            return RuntimeHelpers.selectInternalMM(runtime2, visibility, callType);
        }
        DynamicMethod methodMissing = selfClass.searchMethod("method_missing");
        if (methodMissing.isUndefined() || methodMissing == runtime2.getDefaultMethodMissing()) {
            return RuntimeHelpers.selectInternalMM(runtime2, visibility, callType);
        }
        return new MethodMissingMethod(methodMissing, callType);
    }

    public static DynamicMethod selectMethodMissing(RubyClass selfClass, Visibility visibility, String name2, CallType callType) {
        Ruby runtime2 = selfClass.getClassRuntime();
        if (name2.equals("method_missing")) {
            return RuntimeHelpers.selectInternalMM(runtime2, visibility, callType);
        }
        DynamicMethod methodMissing = selfClass.searchMethod("method_missing");
        if (methodMissing.isUndefined() || methodMissing == runtime2.getDefaultMethodMissing()) {
            return RuntimeHelpers.selectInternalMM(runtime2, visibility, callType);
        }
        return new MethodMissingMethod(methodMissing, callType);
    }

    private static DynamicMethod selectInternalMM(Ruby runtime2, Visibility visibility, CallType callType) {
        if (visibility == Visibility.PRIVATE) {
            return runtime2.getPrivateMethodMissing();
        }
        if (visibility == Visibility.PROTECTED) {
            return runtime2.getProtectedMethodMissing();
        }
        if (callType == CallType.VARIABLE) {
            return runtime2.getVariableMethodMissing();
        }
        if (callType == CallType.SUPER) {
            return runtime2.getSuperMethodMissing();
        }
        return runtime2.getNormalMethodMissing();
    }

    private static IRubyObject[] prepareMethodMissingArgs(IRubyObject[] args2, ThreadContext context, String name2) {
        IRubyObject[] newArgs = new IRubyObject[args2.length + 1];
        System.arraycopy(args2, 0, newArgs, 1, args2.length);
        newArgs[0] = context.getRuntime().newSymbol(name2);
        return newArgs;
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, Block block) {
        return self.getMetaClass().finvoke(context, self, name2, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, Block block) {
        return self.getMetaClass().finvoke(context, self, name2, arg0, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return self.getMetaClass().finvoke(context, self, name2, arg0, arg1, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return self.getMetaClass().finvoke(context, self, name2, arg0, arg1, arg2, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject[] args2, Block block) {
        return self.getMetaClass().finvoke(context, self, name2, args2, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name2) {
        return self.getMetaClass().finvoke(context, self, name2);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg0) {
        return self.getMetaClass().finvoke(context, self, name2, arg0);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1) {
        return self.getMetaClass().finvoke(context, self, name2, arg0, arg1);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return self.getMetaClass().finvoke(context, self, name2, arg0, arg1, arg2);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject ... args2) {
        return self.getMetaClass().finvoke(context, self, name2, args2);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, CallType callType) {
        return RuntimeHelpers.invoke(context, self, name2, IRubyObject.NULL_ARRAY, callType, Block.NULL_BLOCK);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject[] args2, CallType callType, Block block) {
        return self.getMetaClass().invoke(context, self, name2, args2, callType, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg2, CallType callType, Block block) {
        return self.getMetaClass().invoke(context, self, name2, arg2, callType, block);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self, String name2, IRubyObject[] args2, Block block) {
        return asClass.finvoke(context, self, name2, args2, block);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self, String name2, Block block) {
        return asClass.finvoke(context, self, name2, block);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self, String name2, IRubyObject arg0, Block block) {
        return asClass.finvoke(context, self, name2, arg0, block);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return asClass.finvoke(context, self, name2, arg0, arg1, block);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return asClass.finvoke(context, self, name2, arg0, arg1, arg2, block);
    }

    public static IRubyObject invokeChecked(ThreadContext context, IRubyObject self, String name2) {
        return self.getMetaClass().finvokeChecked(context, self, name2);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
        UndefinedMethod method2;
        RuntimeHelpers.checkSuperDisabledOrOutOfMethod(context);
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass superClass = RuntimeHelpers.findImplementerIfNecessary(self.getMetaClass(), klazz).getSuperClass();
        DynamicMethod dynamicMethod = method2 = superClass != null ? superClass.searchMethod(name2) : UndefinedMethod.INSTANCE;
        if (method2.isUndefined()) {
            return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, CallType.SUPER, args2, block);
        }
        return ((DynamicMethod)method2).call(context, self, (RubyModule)superClass, name2, args2, block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self, Block block) {
        UndefinedMethod method2;
        RuntimeHelpers.checkSuperDisabledOrOutOfMethod(context);
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass superClass = RuntimeHelpers.findImplementerIfNecessary(self.getMetaClass(), klazz).getSuperClass();
        DynamicMethod dynamicMethod = method2 = superClass != null ? superClass.searchMethod(name2) : UndefinedMethod.INSTANCE;
        if (method2.isUndefined()) {
            return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, CallType.SUPER, block);
        }
        return method2.call(context, self, (RubyModule)superClass, name2, block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self, IRubyObject arg0, Block block) {
        UndefinedMethod method2;
        RuntimeHelpers.checkSuperDisabledOrOutOfMethod(context);
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass superClass = RuntimeHelpers.findImplementerIfNecessary(self.getMetaClass(), klazz).getSuperClass();
        DynamicMethod dynamicMethod = method2 = superClass != null ? superClass.searchMethod(name2) : UndefinedMethod.INSTANCE;
        if (method2.isUndefined()) {
            return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, CallType.SUPER, arg0, block);
        }
        return method2.call(context, self, (RubyModule)superClass, name2, arg0, block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self, IRubyObject arg0, IRubyObject arg1, Block block) {
        UndefinedMethod method2;
        RuntimeHelpers.checkSuperDisabledOrOutOfMethod(context);
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass superClass = RuntimeHelpers.findImplementerIfNecessary(self.getMetaClass(), klazz).getSuperClass();
        DynamicMethod dynamicMethod = method2 = superClass != null ? superClass.searchMethod(name2) : UndefinedMethod.INSTANCE;
        if (method2.isUndefined()) {
            return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, CallType.SUPER, arg0, arg1, block);
        }
        return method2.call(context, self, (RubyModule)superClass, name2, arg0, arg1, block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        UndefinedMethod method2;
        RuntimeHelpers.checkSuperDisabledOrOutOfMethod(context);
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass superClass = RuntimeHelpers.findImplementerIfNecessary(self.getMetaClass(), klazz).getSuperClass();
        DynamicMethod dynamicMethod = method2 = superClass != null ? superClass.searchMethod(name2) : UndefinedMethod.INSTANCE;
        if (method2.isUndefined()) {
            return RuntimeHelpers.callMethodMissing(context, self, method2.getVisibility(), name2, CallType.SUPER, arg0, arg1, arg2, block);
        }
        return method2.call(context, self, (RubyModule)superClass, name2, arg0, arg1, arg2, block);
    }

    public static RubyArray ensureRubyArray(IRubyObject value2) {
        return RuntimeHelpers.ensureRubyArray(value2.getRuntime(), value2);
    }

    public static RubyArray ensureRubyArray(Ruby runtime2, IRubyObject value2) {
        return value2 instanceof RubyArray ? (RubyArray)value2 : RubyArray.newArray(runtime2, value2);
    }

    public static RubyArray ensureMultipleAssignableRubyArray(IRubyObject value2, Ruby runtime2, boolean masgnHasHead) {
        if (!(value2 instanceof RubyArray)) {
            value2 = ArgsUtil.convertToRubyArray(runtime2, value2, masgnHasHead);
        }
        return (RubyArray)value2;
    }

    public static IRubyObject fetchClassVariable(ThreadContext context, Ruby runtime2, IRubyObject self, String name2) {
        RubyModule rubyClass = ASTInterpreter.getClassVariableBase(context, runtime2);
        if (rubyClass == null) {
            rubyClass = self.getMetaClass();
        }
        return rubyClass.getClassVar(name2);
    }

    public static IRubyObject fastFetchClassVariable(ThreadContext context, Ruby runtime2, IRubyObject self, String internedName) {
        RubyModule rubyClass = ASTInterpreter.getClassVariableBase(context, runtime2);
        if (rubyClass == null) {
            rubyClass = self.getMetaClass();
        }
        return rubyClass.fastGetClassVar(internedName);
    }

    public static IRubyObject getConstant(ThreadContext context, String internedName) {
        Ruby runtime2 = context.getRuntime();
        return context.getCurrentScope().getStaticScope().getConstantWithConstMissing(runtime2, internedName, runtime2.getObject());
    }

    public static IRubyObject nullToNil(IRubyObject value2, Ruby runtime2) {
        return value2 != null ? value2 : runtime2.getNil();
    }

    public static RubyClass prepareSuperClass(Ruby runtime2, IRubyObject rubyClass) {
        RubyClass.checkInheritable(rubyClass);
        return (RubyClass)rubyClass;
    }

    public static RubyModule prepareClassNamespace(ThreadContext context, IRubyObject rubyModule) {
        if ((rubyModule == null || rubyModule.isNil()) && (rubyModule = context.getCurrentScope().getStaticScope().getModule()) == null) {
            throw context.getRuntime().newTypeError("no outer class/module");
        }
        if (rubyModule instanceof RubyModule) {
            return (RubyModule)rubyModule;
        }
        throw context.getRuntime().newTypeError(rubyModule + " is not a class/module");
    }

    public static IRubyObject setClassVariable(ThreadContext context, Ruby runtime2, IRubyObject self, String name2, IRubyObject value2) {
        RubyModule rubyClass = ASTInterpreter.getClassVariableBase(context, runtime2);
        if (rubyClass == null) {
            rubyClass = self.getMetaClass();
        }
        rubyClass.setClassVar(name2, value2);
        return value2;
    }

    public static IRubyObject fastSetClassVariable(ThreadContext context, Ruby runtime2, IRubyObject self, String internedName, IRubyObject value2) {
        RubyModule rubyClass = ASTInterpreter.getClassVariableBase(context, runtime2);
        if (rubyClass == null) {
            rubyClass = self.getMetaClass();
        }
        rubyClass.fastSetClassVar(internedName, value2);
        return value2;
    }

    public static IRubyObject declareClassVariable(ThreadContext context, Ruby runtime2, IRubyObject self, String name2, IRubyObject value2) {
        RubyModule rubyClass = ASTInterpreter.getClassVariableBase(context, runtime2);
        if (rubyClass == null) {
            throw runtime2.newTypeError("no class/module to define class variable");
        }
        rubyClass.setClassVar(name2, value2);
        return value2;
    }

    public static IRubyObject fastDeclareClassVariable(ThreadContext context, Ruby runtime2, IRubyObject self, String internedName, IRubyObject value2) {
        RubyModule rubyClass = ASTInterpreter.getClassVariableBase(context, runtime2);
        if (rubyClass == null) {
            throw runtime2.newTypeError("no class/module to define class variable");
        }
        rubyClass.fastSetClassVar(internedName, value2);
        return value2;
    }

    public static void handleArgumentSizes(ThreadContext context, Ruby runtime2, int given, int required, int opt, int rest2) {
        if (opt == 0) {
            if (rest2 < 0 ? given != required : given < required) {
                throw runtime2.newArgumentError("wrong number of arguments (" + given + " for " + required + ")");
            }
        } else if (rest2 < 0) {
            if (given < required) {
                throw runtime2.newArgumentError("wrong number of arguments (" + given + " for " + required + ")");
            }
            if (given > required + opt) {
                throw runtime2.newArgumentError("wrong number of arguments (" + given + " for " + (required + opt) + ")");
            }
        } else if (given < required) {
            throw runtime2.newArgumentError("wrong number of arguments (" + given + " for " + required + ")");
        }
    }

    public static Throwable unwrapRedoNextBreakOrJustLocalJump(RaiseException re, ThreadContext context) {
        RubyException exception2 = re.getException();
        if (context.getRuntime().getLocalJumpError().isInstance(exception2)) {
            RubyLocalJumpError jumpError = (RubyLocalJumpError)re.getException();
            switch (jumpError.getReason()) {
                case REDO: {
                    return JumpException.REDO_JUMP;
                }
                case NEXT: {
                    return new JumpException.NextJump(jumpError.exit_value());
                }
                case BREAK: {
                    return new JumpException.BreakJump(context.getFrameJumpTarget(), jumpError.exit_value());
                }
            }
        }
        return re;
    }

    public static String getLocalJumpTypeOrRethrow(RaiseException re) {
        RubyException exception2 = re.getException();
        Ruby runtime2 = exception2.getRuntime();
        if (runtime2.getLocalJumpError().isInstance(exception2)) {
            RubyLocalJumpError jumpError = (RubyLocalJumpError)re.getException();
            IRubyObject reason2 = jumpError.reason();
            return reason2.asJavaString();
        }
        throw re;
    }

    public static IRubyObject unwrapLocalJumpErrorValue(RaiseException re) {
        return ((RubyLocalJumpError)re.getException()).exit_value();
    }

    public static IRubyObject processBlockArgument(Ruby runtime2, Block block) {
        if (!block.isGiven()) {
            return runtime2.getNil();
        }
        return RuntimeHelpers.processGivenBlock(block, runtime2);
    }

    private static IRubyObject processGivenBlock(Block block, Ruby runtime2) {
        RubyProc blockArg = block.getProcObject();
        if (blockArg == null) {
            blockArg = runtime2.newBlockPassProc(Block.Type.PROC, block);
            blockArg.getBlock().type = Block.Type.PROC;
        }
        return blockArg;
    }

    public static Block getBlockFromBlockPassBody(Ruby runtime2, IRubyObject proc2, Block currentBlock) {
        if (proc2.isNil()) {
            return Block.NULL_BLOCK;
        }
        if (!(proc2 instanceof RubyProc)) {
            proc2 = RuntimeHelpers.coerceProc(proc2, runtime2);
        }
        return RuntimeHelpers.getBlockFromProc(currentBlock, proc2);
    }

    private static IRubyObject coerceProc(IRubyObject proc2, Ruby runtime2) throws RaiseException {
        if (!((proc2 = TypeConverter.convertToType(proc2, runtime2.getProc(), "to_proc", false)) instanceof RubyProc)) {
            throw runtime2.newTypeError("wrong argument type " + proc2.getMetaClass().getName() + " (expected Proc)");
        }
        return proc2;
    }

    private static Block getBlockFromProc(Block currentBlock, IRubyObject proc2) {
        RubyProc procObject;
        if (currentBlock != null && currentBlock.isGiven() && (procObject = currentBlock.getProcObject()) != null && procObject == proc2) {
            return currentBlock;
        }
        return ((RubyProc)proc2).getBlock();
    }

    public static Block getBlockFromBlockPassBody(IRubyObject proc2, Block currentBlock) {
        return RuntimeHelpers.getBlockFromBlockPassBody(proc2.getRuntime(), proc2, currentBlock);
    }

    public static IRubyObject backref(ThreadContext context) {
        IRubyObject backref = context.getCurrentScope().getBackRef(context.getRuntime());
        if (backref instanceof RubyMatchData) {
            ((RubyMatchData)backref).use();
        }
        return backref;
    }

    public static IRubyObject backrefLastMatch(ThreadContext context) {
        IRubyObject backref = context.getCurrentScope().getBackRef(context.getRuntime());
        return RubyRegexp.last_match(backref);
    }

    public static IRubyObject backrefMatchPre(ThreadContext context) {
        IRubyObject backref = context.getCurrentScope().getBackRef(context.getRuntime());
        return RubyRegexp.match_pre(backref);
    }

    public static IRubyObject backrefMatchPost(ThreadContext context) {
        IRubyObject backref = context.getCurrentScope().getBackRef(context.getRuntime());
        return RubyRegexp.match_post(backref);
    }

    public static IRubyObject backrefMatchLast(ThreadContext context) {
        IRubyObject backref = context.getCurrentScope().getBackRef(context.getRuntime());
        return RubyRegexp.match_last(backref);
    }

    public static IRubyObject[] getArgValues(ThreadContext context) {
        return context.getCurrentScope().getArgValues();
    }

    public static IRubyObject callZSuper(Ruby runtime2, ThreadContext context, Block block, IRubyObject self) {
        if (!block.isGiven()) {
            block = context.getCurrentFrame().getBlock();
        }
        return RuntimeHelpers.invokeSuper(context, self, context.getCurrentScope().getArgValues(), block);
    }

    public static IRubyObject[] appendToObjectArray(IRubyObject[] array, IRubyObject add3) {
        IRubyObject[] newArray = new IRubyObject[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = add3;
        return newArray;
    }

    public static JumpException.ReturnJump returnJump(IRubyObject result, ThreadContext context) {
        return context.returnJump(result);
    }

    public static IRubyObject breakJumpInWhile(JumpException.BreakJump bj, ThreadContext context) {
        if (bj.getTarget() == context.getFrameJumpTarget()) {
            return (IRubyObject)bj.getValue();
        }
        throw bj;
    }

    public static IRubyObject breakJump(ThreadContext context, IRubyObject value2) {
        throw new JumpException.BreakJump(context.getFrameJumpTarget(), value2);
    }

    public static IRubyObject breakLocalJumpError(Ruby runtime2, IRubyObject value2) {
        throw runtime2.newLocalJumpError(RubyLocalJumpError.Reason.BREAK, value2, "unexpected break");
    }

    public static IRubyObject[] concatObjectArrays(IRubyObject[] array, IRubyObject[] add3) {
        IRubyObject[] newArray = new IRubyObject[array.length + add3.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        System.arraycopy(add3, 0, newArray, array.length, add3.length);
        return newArray;
    }

    public static IRubyObject isExceptionHandled(RubyException currentException, IRubyObject[] exceptions, ThreadContext context) {
        for (int i2 = 0; i2 < exceptions.length; ++i2) {
            IRubyObject result = RuntimeHelpers.isExceptionHandled(currentException, exceptions[i2], context);
            if (!result.isTrue()) continue;
            return result;
        }
        return context.getRuntime().getFalse();
    }

    public static IRubyObject isExceptionHandled(RubyException currentException, IRubyObject exception2, ThreadContext context) {
        return RuntimeHelpers.isExceptionHandled((IRubyObject)currentException, exception2, context);
    }

    public static IRubyObject isExceptionHandled(IRubyObject currentException, IRubyObject exception2, ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (!runtime2.getModule().isInstance(exception2)) {
            throw runtime2.newTypeError("class or module required for rescue clause");
        }
        IRubyObject result = RuntimeHelpers.invoke(context, exception2, "===", currentException);
        if (result.isTrue()) {
            return result;
        }
        return runtime2.getFalse();
    }

    public static IRubyObject isExceptionHandled(RubyException currentException, IRubyObject exception0, IRubyObject exception1, ThreadContext context) {
        IRubyObject result = RuntimeHelpers.isExceptionHandled(currentException, exception0, context);
        if (result.isTrue()) {
            return result;
        }
        return RuntimeHelpers.isExceptionHandled(currentException, exception1, context);
    }

    public static IRubyObject isExceptionHandled(RubyException currentException, IRubyObject exception0, IRubyObject exception1, IRubyObject exception2, ThreadContext context) {
        IRubyObject result = RuntimeHelpers.isExceptionHandled(currentException, exception0, context);
        if (result.isTrue()) {
            return result;
        }
        return RuntimeHelpers.isExceptionHandled(currentException, exception1, exception2, context);
    }

    private static boolean checkJavaException(Throwable throwable, IRubyObject catchable, ThreadContext context) {
        Class cls;
        RubyClass rubyClass;
        JavaClass javaClass;
        if (context.getRuntime().getException().op_ge(catchable).isTrue() || context.getRuntime().getObject() == catchable) {
            if (throwable instanceof RaiseException) {
                return RuntimeHelpers.isExceptionHandled(((RaiseException)throwable).getException(), catchable, context).isTrue();
            }
            return RuntimeHelpers.isExceptionHandled(JavaUtil.convertJavaToUsableRubyObject(context.getRuntime(), throwable), catchable, context).isTrue();
        }
        return catchable instanceof RubyClass && catchable.getInstanceVariables().hasInstanceVariable("@java_class") && (javaClass = (JavaClass)(rubyClass = (RubyClass)catchable).fastGetInstanceVariable("@java_class")) != null && (cls = javaClass.javaClass()).isInstance(throwable);
    }

    public static IRubyObject isJavaExceptionHandled(Throwable currentThrowable, IRubyObject[] throwables, ThreadContext context) {
        if (currentThrowable instanceof Unrescuable) {
            UnsafeFactory.getUnsafe().throwException(currentThrowable);
        }
        if (currentThrowable instanceof RaiseException) {
            return RuntimeHelpers.isExceptionHandled(((RaiseException)currentThrowable).getException(), throwables, context);
        }
        for (int i2 = 0; i2 < throwables.length; ++i2) {
            if (!RuntimeHelpers.checkJavaException(currentThrowable, throwables[0], context)) continue;
            return context.getRuntime().getTrue();
        }
        return context.getRuntime().getFalse();
    }

    public static IRubyObject isJavaExceptionHandled(Throwable currentThrowable, IRubyObject throwable, ThreadContext context) {
        if (currentThrowable instanceof Unrescuable) {
            UnsafeFactory.getUnsafe().throwException(currentThrowable);
        }
        if (currentThrowable instanceof RaiseException) {
            return RuntimeHelpers.isExceptionHandled(((RaiseException)currentThrowable).getException(), throwable, context);
        }
        if (RuntimeHelpers.checkJavaException(currentThrowable, throwable, context)) {
            return context.getRuntime().getTrue();
        }
        return context.getRuntime().getFalse();
    }

    public static IRubyObject isJavaExceptionHandled(Throwable currentThrowable, IRubyObject throwable0, IRubyObject throwable1, ThreadContext context) {
        if (currentThrowable instanceof Unrescuable) {
            UnsafeFactory.getUnsafe().throwException(currentThrowable);
        }
        if (currentThrowable instanceof RaiseException) {
            return RuntimeHelpers.isExceptionHandled(((RaiseException)currentThrowable).getException(), throwable0, throwable1, context);
        }
        if (RuntimeHelpers.checkJavaException(currentThrowable, throwable0, context)) {
            return context.getRuntime().getTrue();
        }
        if (RuntimeHelpers.checkJavaException(currentThrowable, throwable1, context)) {
            return context.getRuntime().getTrue();
        }
        return context.getRuntime().getFalse();
    }

    public static IRubyObject isJavaExceptionHandled(Throwable currentThrowable, IRubyObject throwable0, IRubyObject throwable1, IRubyObject throwable2, ThreadContext context) {
        if (currentThrowable instanceof Unrescuable) {
            UnsafeFactory.getUnsafe().throwException(currentThrowable);
        }
        if (currentThrowable instanceof RaiseException) {
            return RuntimeHelpers.isExceptionHandled(((RaiseException)currentThrowable).getException(), throwable0, throwable1, throwable2, context);
        }
        if (RuntimeHelpers.checkJavaException(currentThrowable, throwable0, context)) {
            return context.getRuntime().getTrue();
        }
        if (RuntimeHelpers.checkJavaException(currentThrowable, throwable1, context)) {
            return context.getRuntime().getTrue();
        }
        if (RuntimeHelpers.checkJavaException(currentThrowable, throwable2, context)) {
            return context.getRuntime().getTrue();
        }
        return context.getRuntime().getFalse();
    }

    public static void storeExceptionInErrorInfo(Throwable currentThrowable, ThreadContext context) {
        IRubyObject exception2 = null;
        exception2 = currentThrowable instanceof RaiseException ? ((RaiseException)currentThrowable).getException() : JavaUtil.convertJavaToUsableRubyObject(context.getRuntime(), currentThrowable);
        context.setErrorInfo(exception2);
    }

    public static void clearErrorInfo(ThreadContext context) {
        context.setErrorInfo(context.getRuntime().getNil());
    }

    public static void checkSuperDisabledOrOutOfMethod(ThreadContext context) {
        if (context.getFrameKlazz() == null) {
            String name2 = context.getFrameName();
            if (name2 != null) {
                throw context.getRuntime().newNameError("superclass method '" + name2 + "' disabled", name2);
            }
            throw context.getRuntime().newNoMethodError("super called outside of method", null, context.getRuntime().getNil());
        }
    }

    public static Block ensureSuperBlock(Block given, Block parent) {
        if (!given.isGiven()) {
            return parent;
        }
        return given;
    }

    public static RubyModule findImplementerIfNecessary(RubyModule clazz, RubyModule implementationClass) {
        if (implementationClass != null && implementationClass.needsImplementer()) {
            return clazz.findImplementer(implementationClass);
        }
        return implementationClass;
    }

    public static RubyArray createSubarray(RubyArray input, int start2) {
        return (RubyArray)input.subseqLight(start2, input.size() - start2);
    }

    public static RubyArray createSubarray(RubyArray input, int start2, int post) {
        return (RubyArray)input.subseqLight(start2, input.size() - post - start2);
    }

    public static RubyArray createSubarray(IRubyObject[] input, Ruby runtime2, int start2) {
        if (start2 >= input.length) {
            return RubyArray.newEmptyArray(runtime2);
        }
        return RubyArray.newArrayNoCopy(runtime2, input, start2);
    }

    public static RubyArray createSubarray(IRubyObject[] input, Ruby runtime2, int start2, int exclude) {
        int length2 = input.length - exclude - start2;
        if (length2 <= 0) {
            return RubyArray.newEmptyArray(runtime2);
        }
        return RubyArray.newArrayNoCopy(runtime2, input, start2, length2);
    }

    public static IRubyObject elementOrNull(IRubyObject[] input, int element) {
        if (element >= input.length) {
            return null;
        }
        return input[element];
    }

    public static IRubyObject optElementOrNull(IRubyObject[] input, int element, int postCount) {
        if (element + postCount >= input.length) {
            return null;
        }
        return input[element];
    }

    public static IRubyObject elementOrNil(IRubyObject[] input, int element, IRubyObject nil) {
        if (element >= input.length) {
            return nil;
        }
        return input[element];
    }

    public static IRubyObject postElementOrNil(IRubyObject[] input, int postCount, int postIndex, IRubyObject nil) {
        int aryIndex = input.length - postCount + postIndex;
        if (aryIndex >= input.length || aryIndex < 0) {
            return nil;
        }
        return input[aryIndex];
    }

    public static RubyBoolean isWhenTriggered(IRubyObject expression, IRubyObject expressionsObject, ThreadContext context) {
        RubyArray expressions = RuntimeHelpers.splatValue(expressionsObject);
        int k = expressions.getLength();
        for (int j = 0; j < k; ++j) {
            IRubyObject condition = expressions.eltInternal(j);
            if ((expression == null || !condition.callMethod(context, "===", expression).isTrue()) && (expression != null || !condition.isTrue())) continue;
            return context.getRuntime().getTrue();
        }
        return context.getRuntime().getFalse();
    }

    public static IRubyObject setConstantInModule(IRubyObject module, IRubyObject value2, String name2, ThreadContext context) {
        return context.setConstantInModule(name2, module, value2);
    }

    public static IRubyObject setConstantInCurrent(IRubyObject value2, ThreadContext context, String name2) {
        return context.setConstantInCurrent(name2, value2);
    }

    public static IRubyObject retryJump() {
        throw JumpException.RETRY_JUMP;
    }

    public static IRubyObject redoJump() {
        throw JumpException.REDO_JUMP;
    }

    public static IRubyObject redoLocalJumpError(Ruby runtime2) {
        throw runtime2.newLocalJumpError(RubyLocalJumpError.Reason.REDO, runtime2.getNil(), "unexpected redo");
    }

    public static IRubyObject nextJump(IRubyObject value2) {
        throw new JumpException.NextJump(value2);
    }

    public static IRubyObject nextLocalJumpError(Ruby runtime2, IRubyObject value2) {
        throw runtime2.newLocalJumpError(RubyLocalJumpError.Reason.NEXT, value2, "unexpected next");
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one) {
        return new IRubyObject[]{one};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two) {
        return new IRubyObject[]{one, two};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three) {
        return new IRubyObject[]{one, two, three};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four) {
        return new IRubyObject[]{one, two, three, four};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five) {
        return new IRubyObject[]{one, two, three, four, five};
    }

    public static RubyArray constructRubyArray(Ruby runtime2, IRubyObject one) {
        return RubyArray.newArrayLight(runtime2, one);
    }

    public static RubyArray constructRubyArray(Ruby runtime2, IRubyObject one, IRubyObject two) {
        return RubyArray.newArrayLight(runtime2, one, two);
    }

    public static RubyArray constructRubyArray(Ruby runtime2, IRubyObject one, IRubyObject two, IRubyObject three) {
        return RubyArray.newArrayLight(runtime2, one, two, three);
    }

    public static RubyArray constructRubyArray(Ruby runtime2, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four) {
        return RubyArray.newArrayLight(runtime2, one, two, three, four);
    }

    public static RubyArray constructRubyArray(Ruby runtime2, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five) {
        return RubyArray.newArrayLight(runtime2, one, two, three, four, five);
    }

    public static String[] constructStringArray(String one) {
        return new String[]{one};
    }

    public static String[] constructStringArray(String one, String two) {
        return new String[]{one, two};
    }

    public static String[] constructStringArray(String one, String two, String three) {
        return new String[]{one, two, three};
    }

    public static String[] constructStringArray(String one, String two, String three, String four) {
        return new String[]{one, two, three, four};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five) {
        return new String[]{one, two, three, four, five};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six) {
        return new String[]{one, two, three, four, five, six};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six, String seven) {
        return new String[]{one, two, three, four, five, six, seven};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six, String seven, String eight) {
        return new String[]{one, two, three, four, five, six, seven, eight};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six, String seven, String eight, String nine) {
        return new String[]{one, two, three, four, five, six, seven, eight, nine};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six, String seven, String eight, String nine, String ten) {
        return new String[]{one, two, three, four, five, six, seven, eight, nine, ten};
    }

    public static RubyHash constructHash(Ruby runtime2, IRubyObject key1, IRubyObject value1) {
        RubyHash hash2 = RubyHash.newHash(runtime2);
        hash2.fastASetCheckString(runtime2, key1, value1);
        return hash2;
    }

    public static RubyHash constructHash(Ruby runtime2, IRubyObject key1, IRubyObject value1, IRubyObject key2, IRubyObject value2) {
        RubyHash hash2 = RubyHash.newHash(runtime2);
        hash2.fastASetCheckString(runtime2, key1, value1);
        hash2.fastASetCheckString(runtime2, key2, value2);
        return hash2;
    }

    public static RubyHash constructHash(Ruby runtime2, IRubyObject key1, IRubyObject value1, IRubyObject key2, IRubyObject value2, IRubyObject key3, IRubyObject value3) {
        RubyHash hash2 = RubyHash.newHash(runtime2);
        hash2.fastASetCheckString(runtime2, key1, value1);
        hash2.fastASetCheckString(runtime2, key2, value2);
        hash2.fastASetCheckString(runtime2, key3, value3);
        return hash2;
    }

    public static RubyHash constructHash19(Ruby runtime2, IRubyObject key1, IRubyObject value1) {
        RubyHash hash2 = RubyHash.newHash(runtime2);
        hash2.fastASetCheckString19(runtime2, key1, value1);
        return hash2;
    }

    public static RubyHash constructHash19(Ruby runtime2, IRubyObject key1, IRubyObject value1, IRubyObject key2, IRubyObject value2) {
        RubyHash hash2 = RubyHash.newHash(runtime2);
        hash2.fastASetCheckString19(runtime2, key1, value1);
        hash2.fastASetCheckString19(runtime2, key2, value2);
        return hash2;
    }

    public static RubyHash constructHash19(Ruby runtime2, IRubyObject key1, IRubyObject value1, IRubyObject key2, IRubyObject value2, IRubyObject key3, IRubyObject value3) {
        RubyHash hash2 = RubyHash.newHash(runtime2);
        hash2.fastASetCheckString19(runtime2, key1, value1);
        hash2.fastASetCheckString19(runtime2, key2, value2);
        hash2.fastASetCheckString19(runtime2, key3, value3);
        return hash2;
    }

    public static IRubyObject undefMethod(ThreadContext context, Object nameArg) {
        String name2;
        RubyModule module = context.getRubyClass();
        String string2 = name2 = nameArg instanceof String ? (String)nameArg : nameArg.toString();
        if (module == null) {
            throw context.getRuntime().newTypeError("No class to undef method '" + name2 + "'.");
        }
        module.undef(context, name2);
        return context.getRuntime().getNil();
    }

    public static IRubyObject defineAlias(ThreadContext context, IRubyObject self, Object newNameArg, Object oldNameArg) {
        Ruby runtime2 = context.getRuntime();
        RubyModule module = context.getRubyClass();
        if (module == null || self instanceof RubyFixnum || self instanceof RubySymbol) {
            throw runtime2.newTypeError("no class to make alias");
        }
        String newName = newNameArg instanceof String ? (String)newNameArg : newNameArg.toString();
        String oldName = oldNameArg instanceof String ? (String)oldNameArg : oldNameArg.toString();
        module.defineAlias(newName, oldName);
        module.callMethod(context, "method_added", (IRubyObject)runtime2.newSymbol(newName));
        return runtime2.getNil();
    }

    public static IRubyObject negate(IRubyObject value2, Ruby runtime2) {
        if (value2.isTrue()) {
            return runtime2.getFalse();
        }
        return runtime2.getTrue();
    }

    public static IRubyObject stringOrNil(String value2, Ruby runtime2, IRubyObject nil) {
        if (value2 == null) {
            return nil;
        }
        return RubyString.newString(runtime2, value2);
    }

    public static void preLoad(ThreadContext context, String[] varNames) {
        LocalStaticScope staticScope = new LocalStaticScope(null, varNames);
        RuntimeHelpers.preLoadCommon(context, staticScope);
    }

    public static void preLoad(ThreadContext context, String scopeString) {
        LocalStaticScope staticScope = RuntimeHelpers.decodeRootScope(context, scopeString);
        RuntimeHelpers.preLoadCommon(context, staticScope);
    }

    private static void preLoadCommon(ThreadContext context, StaticScope staticScope) {
        RubyClass objectClass = context.getRuntime().getObject();
        IRubyObject topLevel = context.getRuntime().getTopSelf();
        staticScope.setModule(objectClass);
        DynamicScope scope = DynamicScope.newDynamicScope(staticScope);
        context.preScopedBody(scope);
        context.preNodeEval(objectClass, topLevel);
    }

    public static void postLoad(ThreadContext context) {
        context.postNodeEval();
        context.postScopedBody();
    }

    public static void registerEndBlock(Block block, Ruby runtime2) {
        runtime2.pushExitBlock(runtime2.newProc(Block.Type.LAMBDA, block));
    }

    public static IRubyObject match3(RubyRegexp regexp2, IRubyObject value2, ThreadContext context) {
        if (value2 instanceof RubyString) {
            return regexp2.op_match(context, value2);
        }
        return value2.callMethod(context, "=~", regexp2);
    }

    public static IRubyObject getErrorInfo(Ruby runtime2) {
        return runtime2.getGlobalVariables().get("$!");
    }

    public static void setErrorInfo(Ruby runtime2, IRubyObject error2) {
        runtime2.getGlobalVariables().set("$!", error2);
    }

    public static IRubyObject setLastLine(Ruby runtime2, ThreadContext context, IRubyObject value2) {
        return context.getCurrentScope().setLastLine(value2);
    }

    public static IRubyObject getLastLine(Ruby runtime2, ThreadContext context) {
        return context.getCurrentScope().getLastLine(runtime2);
    }

    public static IRubyObject setBackref(Ruby runtime2, ThreadContext context, IRubyObject value2) {
        if (!value2.isNil() && !(value2 instanceof RubyMatchData)) {
            throw runtime2.newTypeError(value2, runtime2.getMatchData());
        }
        return context.getCurrentScope().setBackRef(value2);
    }

    public static IRubyObject getBackref(Ruby runtime2, ThreadContext context) {
        IRubyObject backref = context.getCurrentScope().getBackRef(runtime2);
        if (backref instanceof RubyMatchData) {
            ((RubyMatchData)backref).use();
        }
        return backref;
    }

    public static IRubyObject preOpAsgnWithOrAnd(IRubyObject receiver2, ThreadContext context, IRubyObject self, CallSite varSite) {
        return varSite.call(context, self, receiver2);
    }

    public static IRubyObject postOpAsgnWithOrAnd(IRubyObject receiver2, IRubyObject value2, ThreadContext context, IRubyObject self, CallSite varAsgnSite) {
        varAsgnSite.call(context, self, receiver2, value2);
        return value2;
    }

    public static IRubyObject opAsgnWithMethod(ThreadContext context, IRubyObject self, IRubyObject receiver2, IRubyObject arg2, CallSite varSite, CallSite opSite, CallSite opAsgnSite) {
        IRubyObject var = varSite.call(context, self, receiver2);
        IRubyObject result = opSite.call(context, self, var, arg2);
        opAsgnSite.call(context, self, receiver2, result);
        return result;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext context, IRubyObject self, IRubyObject receiver2, IRubyObject value2, CallSite elementSite, CallSite opSite, CallSite elementAsgnSite) {
        IRubyObject var = elementSite.call(context, self, receiver2);
        IRubyObject result = opSite.call(context, self, var, value2);
        elementAsgnSite.call(context, self, receiver2, result);
        return result;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext context, IRubyObject self, IRubyObject receiver2, IRubyObject arg2, IRubyObject value2, CallSite elementSite, CallSite opSite, CallSite elementAsgnSite) {
        IRubyObject var = elementSite.call(context, self, receiver2, arg2);
        IRubyObject result = opSite.call(context, self, var, value2);
        elementAsgnSite.call(context, self, receiver2, arg2, result);
        return result;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext context, IRubyObject self, IRubyObject receiver2, IRubyObject arg1, IRubyObject arg2, IRubyObject value2, CallSite elementSite, CallSite opSite, CallSite elementAsgnSite) {
        IRubyObject var = elementSite.call(context, self, receiver2, arg1, arg2);
        IRubyObject result = opSite.call(context, self, var, value2);
        elementAsgnSite.call(context, self, receiver2, arg1, arg2, result);
        return result;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext context, IRubyObject self, IRubyObject receiver2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject value2, CallSite elementSite, CallSite opSite, CallSite elementAsgnSite) {
        IRubyObject var = elementSite.call(context, self, receiver2, arg1, arg2, arg3);
        IRubyObject result = opSite.call(context, self, var, value2);
        elementAsgnSite.call(context, self, receiver2, arg1, arg2, arg3, result);
        return result;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext context, IRubyObject self, IRubyObject receiver2, IRubyObject[] args2, IRubyObject value2, CallSite elementSite, CallSite opSite, CallSite elementAsgnSite) {
        IRubyObject var = elementSite.call(context, self, receiver2);
        IRubyObject result = opSite.call(context, self, var, value2);
        elementAsgnSite.call(context, self, receiver2, RuntimeHelpers.appendToObjectArray(args2, result));
        return result;
    }

    public static IRubyObject opElementAsgnWithOrPartTwoOneArg(ThreadContext context, IRubyObject self, IRubyObject receiver2, IRubyObject arg2, IRubyObject value2, CallSite asetSite) {
        asetSite.call(context, self, receiver2, arg2, value2);
        return value2;
    }

    public static IRubyObject opElementAsgnWithOrPartTwoTwoArgs(ThreadContext context, IRubyObject self, IRubyObject receiver2, IRubyObject[] args2, IRubyObject value2, CallSite asetSite) {
        asetSite.call(context, self, receiver2, args2[0], args2[1], value2);
        return value2;
    }

    public static IRubyObject opElementAsgnWithOrPartTwoThreeArgs(ThreadContext context, IRubyObject self, IRubyObject receiver2, IRubyObject[] args2, IRubyObject value2, CallSite asetSite) {
        asetSite.call(context, self, receiver2, args2[0], args2[1], args2[2], value2);
        return value2;
    }

    public static IRubyObject opElementAsgnWithOrPartTwoNArgs(ThreadContext context, IRubyObject self, IRubyObject receiver2, IRubyObject[] args2, IRubyObject value2, CallSite asetSite) {
        IRubyObject[] newArgs = new IRubyObject[args2.length + 1];
        System.arraycopy(args2, 0, newArgs, 0, args2.length);
        newArgs[args2.length] = value2;
        asetSite.call(context, self, receiver2, newArgs);
        return value2;
    }

    public static RubyArray arrayValue(IRubyObject value2) {
        Ruby runtime2 = value2.getRuntime();
        return RuntimeHelpers.arrayValue(runtime2.getCurrentContext(), runtime2, value2);
    }

    public static RubyArray arrayValue(ThreadContext context, Ruby runtime2, IRubyObject value2) {
        IRubyObject tmp = value2.checkArrayType();
        if (tmp.isNil()) {
            if (value2.respondsTo("to_a") && value2.getMetaClass().searchMethod("to_a").getImplementationClass() != runtime2.getKernel()) {
                IRubyObject avalue = value2.callMethod(context, "to_a");
                if (!(avalue instanceof RubyArray)) {
                    if (runtime2.is1_9() && avalue.isNil()) {
                        return runtime2.newArray(value2);
                    }
                    throw runtime2.newTypeError("`to_a' did not return Array");
                }
                return (RubyArray)avalue;
            }
            return runtime2.newArray(value2);
        }
        return (RubyArray)tmp;
    }

    public static IRubyObject aryToAry(IRubyObject value2) {
        if (value2 instanceof RubyArray) {
            return value2;
        }
        if (value2.respondsTo("to_ary")) {
            return TypeConverter.convertToType(value2, value2.getRuntime().getArray(), "to_ary", false);
        }
        return value2.getRuntime().newArray(value2);
    }

    public static IRubyObject aValueSplat(IRubyObject value2) {
        if (!(value2 instanceof RubyArray) || ((RubyArray)value2).length().getLongValue() == 0L) {
            return value2.getRuntime().getNil();
        }
        RubyArray array = (RubyArray)value2;
        return array.getLength() == 1 ? array.first() : array;
    }

    public static IRubyObject aValueSplat19(IRubyObject value2) {
        if (!(value2 instanceof RubyArray)) {
            return value2.getRuntime().getNil();
        }
        return (RubyArray)value2;
    }

    public static RubyArray splatValue(IRubyObject value2) {
        if (value2.isNil()) {
            return value2.getRuntime().newArray(value2);
        }
        return RuntimeHelpers.arrayValue(value2);
    }

    public static RubyArray splatValue19(IRubyObject value2) {
        if (value2.isNil()) {
            return value2.getRuntime().newEmptyArray();
        }
        return RuntimeHelpers.arrayValue(value2);
    }

    public static void addInstanceMethod(RubyModule containingClass, String name2, DynamicMethod method2, Visibility visibility, ThreadContext context, Ruby runtime2) {
        containingClass.addMethod(name2, method2);
        RubySymbol sym = runtime2.fastNewSymbol(name2);
        if (visibility == Visibility.MODULE_FUNCTION) {
            RuntimeHelpers.addModuleMethod(containingClass, name2, method2, context, sym);
        }
        RuntimeHelpers.callNormalMethodHook(containingClass, context, sym);
    }

    private static void addModuleMethod(RubyModule containingClass, String name2, DynamicMethod method2, ThreadContext context, RubySymbol sym) {
        containingClass.getSingletonClass().addMethod(name2, new WrapperMethod((RubyModule)containingClass.getSingletonClass(), method2, Visibility.PUBLIC));
        containingClass.callMethod(context, "singleton_method_added", (IRubyObject)sym);
    }

    private static void callNormalMethodHook(RubyModule containingClass, ThreadContext context, RubySymbol name2) {
        if (containingClass.isSingleton()) {
            RuntimeHelpers.callSingletonMethodHook(((MetaClass)containingClass).getAttached(), context, name2);
        } else {
            containingClass.callMethod(context, "method_added", (IRubyObject)name2);
        }
    }

    private static void callSingletonMethodHook(IRubyObject receiver2, ThreadContext context, RubySymbol name2) {
        receiver2.callMethod(context, "singleton_method_added", name2);
    }

    private static DynamicMethod constructNormalMethod(MethodFactory factory, String javaName, String name2, RubyModule containingClass, ISourcePosition position, int arity2, StaticScope scope, Visibility visibility, Object scriptObject, CallConfiguration callConfig, String parameterDesc) {
        if (name2.equals("initialize") || name2.equals("initialize_copy") || visibility == Visibility.MODULE_FUNCTION) {
            visibility = Visibility.PRIVATE;
        }
        DynamicMethod method2 = RubyInstanceConfig.LAZYHANDLES_COMPILE ? factory.getCompiledMethodLazily(containingClass, javaName, Arity.createArity(arity2), visibility, scope, scriptObject, callConfig, position, parameterDesc) : factory.getCompiledMethod(containingClass, javaName, Arity.createArity(arity2), visibility, scope, scriptObject, callConfig, position, parameterDesc);
        return method2;
    }

    private static DynamicMethod constructSingletonMethod(MethodFactory factory, String javaName, RubyClass rubyClass, ISourcePosition position, int arity2, StaticScope scope, Object scriptObject, CallConfiguration callConfig, String parameterDesc) {
        if (RubyInstanceConfig.LAZYHANDLES_COMPILE) {
            return factory.getCompiledMethodLazily(rubyClass, javaName, Arity.createArity(arity2), Visibility.PUBLIC, scope, scriptObject, callConfig, position, parameterDesc);
        }
        return factory.getCompiledMethod(rubyClass, javaName, Arity.createArity(arity2), Visibility.PUBLIC, scope, scriptObject, callConfig, position, parameterDesc);
    }

    public static String encodeScope(StaticScope scope) {
        StringBuilder namesBuilder = new StringBuilder();
        boolean first2 = true;
        for (String name2 : scope.getVariables()) {
            if (!first2) {
                namesBuilder.append(';');
            }
            first2 = false;
            namesBuilder.append(name2);
        }
        namesBuilder.append(',').append(scope.getRequiredArgs()).append(',').append(scope.getOptionalArgs()).append(',').append(scope.getRestArg());
        return namesBuilder.toString();
    }

    public static LocalStaticScope decodeRootScope(ThreadContext context, String scopeString) {
        String[][] decodedScope = RuntimeHelpers.decodeScopeDescriptor(scopeString);
        LocalStaticScope scope = new LocalStaticScope(null, decodedScope[1]);
        RuntimeHelpers.setAritiesFromDecodedScope(scope, decodedScope[0]);
        return scope;
    }

    public static LocalStaticScope decodeLocalScope(ThreadContext context, String scopeString) {
        String[][] decodedScope = RuntimeHelpers.decodeScopeDescriptor(scopeString);
        LocalStaticScope scope = new LocalStaticScope(context.getCurrentScope().getStaticScope(), decodedScope[1]);
        RuntimeHelpers.setAritiesFromDecodedScope(scope, decodedScope[0]);
        return scope;
    }

    public static BlockStaticScope decodeBlockScope(ThreadContext context, String scopeString) {
        String[][] decodedScope = RuntimeHelpers.decodeScopeDescriptor(scopeString);
        BlockStaticScope scope = new BlockStaticScope(context.getCurrentScope().getStaticScope(), decodedScope[1]);
        RuntimeHelpers.setAritiesFromDecodedScope(scope, decodedScope[0]);
        return scope;
    }

    private static String[][] decodeScopeDescriptor(String scopeString) {
        String[] scopeElements = scopeString.split(",");
        String[] scopeNames = scopeElements[0].length() == 0 ? new String[]{} : RuntimeHelpers.getScopeNames(scopeElements[0]);
        return new String[][]{scopeElements, scopeNames};
    }

    private static void setAritiesFromDecodedScope(StaticScope scope, String[] scopeElements) {
        scope.setArities(Integer.parseInt(scopeElements[1]), Integer.parseInt(scopeElements[2]), Integer.parseInt(scopeElements[3]));
    }

    private static StaticScope createScopeForClass(ThreadContext context, String scopeString) {
        LocalStaticScope scope = RuntimeHelpers.decodeLocalScope(context, scopeString);
        scope.determineModule();
        return scope;
    }

    private static void performNormalMethodChecks(RubyModule containingClass, Ruby runtime2, String name2) throws RaiseException {
        if (containingClass == runtime2.getDummy()) {
            throw runtime2.newTypeError("no class/module to add method");
        }
        if (containingClass == runtime2.getObject() && name2.equals("initialize")) {
            runtime2.getWarnings().warn(IRubyWarnings.ID.REDEFINING_DANGEROUS, "redefining Object#initialize may cause infinite loop", "Object#initialize");
        }
        if (name2.equals("__id__") || name2.equals("__send__")) {
            runtime2.getWarnings().warn(IRubyWarnings.ID.REDEFINING_DANGEROUS, "redefining `" + name2 + "' may cause serious problem", name2);
        }
    }

    private static RubyClass performSingletonMethodChecks(Ruby runtime2, IRubyObject receiver2, String name2) throws RaiseException {
        if (runtime2.getSafeLevel() >= 4 && !receiver2.isTaint()) {
            throw runtime2.newSecurityError("Insecure; can't define singleton method.");
        }
        if (receiver2 instanceof RubyFixnum || receiver2 instanceof RubySymbol) {
            throw runtime2.newTypeError("can't define singleton method \"" + name2 + "\" for " + receiver2.getMetaClass().getBaseName());
        }
        if (receiver2.isFrozen()) {
            throw runtime2.newFrozenError("object");
        }
        RubyClass rubyClass = receiver2.getSingletonClass();
        if (runtime2.getSafeLevel() >= 4 && rubyClass.getMethods().get(name2) != null) {
            throw runtime2.newSecurityError("redefining method prohibited.");
        }
        return rubyClass;
    }

    public static IRubyObject arrayEntryOrNil(RubyArray array, int index2) {
        if (index2 < array.getLength()) {
            return array.eltInternal(index2);
        }
        return array.getRuntime().getNil();
    }

    public static IRubyObject arrayEntryOrNilZero(RubyArray array) {
        if (0 < array.getLength()) {
            return array.eltInternal(0);
        }
        return array.getRuntime().getNil();
    }

    public static IRubyObject arrayEntryOrNilOne(RubyArray array) {
        if (1 < array.getLength()) {
            return array.eltInternal(1);
        }
        return array.getRuntime().getNil();
    }

    public static IRubyObject arrayEntryOrNilTwo(RubyArray array) {
        if (2 < array.getLength()) {
            return array.eltInternal(2);
        }
        return array.getRuntime().getNil();
    }

    public static IRubyObject arrayPostOrNil(RubyArray array, int pre, int post, int index2) {
        if (pre + post < array.getLength()) {
            return array.eltInternal(array.getLength() - post + index2);
        }
        if (pre + index2 < array.getLength()) {
            return array.eltInternal(pre + index2);
        }
        return array.getRuntime().getNil();
    }

    public static IRubyObject arrayPostOrNilZero(RubyArray array, int pre, int post) {
        if (pre + post < array.getLength()) {
            return array.eltInternal(array.getLength() - post + 0);
        }
        if (pre + 0 < array.getLength()) {
            return array.eltInternal(pre + 0);
        }
        return array.getRuntime().getNil();
    }

    public static IRubyObject arrayPostOrNilOne(RubyArray array, int pre, int post) {
        if (pre + post < array.getLength()) {
            return array.eltInternal(array.getLength() - post + 1);
        }
        if (pre + 1 < array.getLength()) {
            return array.eltInternal(pre + 1);
        }
        return array.getRuntime().getNil();
    }

    public static IRubyObject arrayPostOrNilTwo(RubyArray array, int pre, int post) {
        if (pre + post < array.getLength()) {
            return array.eltInternal(array.getLength() - post + 2);
        }
        if (pre + 2 < array.getLength()) {
            return array.eltInternal(pre + 2);
        }
        return array.getRuntime().getNil();
    }

    public static RubyArray subarrayOrEmpty(RubyArray array, Ruby runtime2, int index2) {
        if (index2 < array.getLength()) {
            return RuntimeHelpers.createSubarray(array, index2);
        }
        return RubyArray.newEmptyArray(runtime2);
    }

    public static RubyArray subarrayOrEmpty(RubyArray array, Ruby runtime2, int index2, int post) {
        if (index2 + post < array.getLength()) {
            return RuntimeHelpers.createSubarray(array, index2, post);
        }
        return RubyArray.newEmptyArray(runtime2);
    }

    public static RubyModule checkIsModule(IRubyObject maybeModule) {
        if (maybeModule instanceof RubyModule) {
            return (RubyModule)maybeModule;
        }
        throw maybeModule.getRuntime().newTypeError(maybeModule + " is not a class/module");
    }

    public static IRubyObject getGlobalVariable(Ruby runtime2, String name2) {
        return runtime2.getGlobalVariables().get(name2);
    }

    public static IRubyObject setGlobalVariable(IRubyObject value2, Ruby runtime2, String name2) {
        return runtime2.getGlobalVariables().set(name2, value2);
    }

    public static IRubyObject getInstanceVariable(IRubyObject self, Ruby runtime2, String internedName) {
        IRubyObject result = self.getInstanceVariables().fastGetInstanceVariable(internedName);
        if (result != null) {
            return result;
        }
        if (runtime2.isVerbose()) {
            RuntimeHelpers.warnAboutUninitializedIvar(runtime2, internedName);
        }
        return runtime2.getNil();
    }

    private static void warnAboutUninitializedIvar(Ruby runtime2, String internedName) {
        runtime2.getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, "instance variable " + internedName + " not initialized", new Object[0]);
    }

    public static IRubyObject setInstanceVariable(IRubyObject value2, IRubyObject self, String name2) {
        return self.getInstanceVariables().fastSetInstanceVariable(name2, value2);
    }

    public static RubyProc newLiteralLambda(ThreadContext context, Block block, IRubyObject self) {
        return RubyProc.newProc(context.getRuntime(), block, Block.Type.LAMBDA);
    }

    public static void fillNil(IRubyObject[] arr, int from, int to, Ruby runtime2) {
        IRubyObject[] nils = runtime2.getNilPrefilledArray();
        int i2 = from;
        while (i2 + 128 < to) {
            System.arraycopy(nils, 0, arr, i2, 128);
            i2 += 128;
        }
        System.arraycopy(nils, 0, arr, i2, to - i2);
    }

    public static void fillNil(IRubyObject[] arr, Ruby runtime2) {
        RuntimeHelpers.fillNil(arr, 0, arr.length, runtime2);
    }

    public static boolean isFastSwitchableString(IRubyObject str) {
        return str instanceof RubyString;
    }

    public static boolean isFastSwitchableSingleCharString(IRubyObject str) {
        return str instanceof RubyString && ((RubyString)str).getByteList().length() == 1;
    }

    public static int getFastSwitchString(IRubyObject str) {
        ByteList byteList = ((RubyString)str).getByteList();
        return byteList.hashCode();
    }

    public static int getFastSwitchSingleCharString(IRubyObject str) {
        ByteList byteList = ((RubyString)str).getByteList();
        return byteList.get(0);
    }

    public static boolean isFastSwitchableSymbol(IRubyObject sym) {
        return sym instanceof RubySymbol;
    }

    public static boolean isFastSwitchableSingleCharSymbol(IRubyObject sym) {
        return sym instanceof RubySymbol && ((RubySymbol)sym).asJavaString().length() == 1;
    }

    public static int getFastSwitchSymbol(IRubyObject sym) {
        String str = ((RubySymbol)sym).asJavaString();
        return str.hashCode();
    }

    public static int getFastSwitchSingleCharSymbol(IRubyObject sym) {
        String str = ((RubySymbol)sym).asJavaString();
        return str.charAt(0);
    }

    public static Block getBlock(ThreadContext context, IRubyObject self, Node node) {
        IterNode iter = (IterNode)node;
        iter.getScope().determineModule();
        if (iter.getBlockBody() instanceof InterpretedBlock) {
            return InterpretedBlock.newInterpretedClosure(context, iter.getBlockBody(), self);
        }
        return Interpreted19Block.newInterpretedClosure(context, iter.getBlockBody(), self);
    }

    public static Block getBlock(Ruby runtime2, ThreadContext context, IRubyObject self, Node node, Block aBlock) {
        return RuntimeHelpers.getBlockFromBlockPassBody(runtime2, node.interpret(runtime2, context, self, aBlock), aBlock);
    }

    public static RubyBoolean rbEqual(ThreadContext context, IRubyObject a, IRubyObject b) {
        Ruby runtime2 = context.getRuntime();
        if (a == b) {
            return runtime2.getTrue();
        }
        IRubyObject res = RuntimeHelpers.invokedynamic(context, a, 1, b);
        return runtime2.newBoolean(res.isTrue());
    }

    public static void traceLine(ThreadContext context) {
        String name2 = context.getFrameName();
        RubyModule type2 = context.getFrameKlazz();
        context.getRuntime().callEventHooks(context, RubyEvent.LINE, context.getFile(), context.getLine(), name2, type2);
    }

    public static void traceClass(ThreadContext context) {
        String name2 = context.getFrameName();
        RubyModule type2 = context.getFrameKlazz();
        context.getRuntime().callEventHooks(context, RubyEvent.CLASS, context.getFile(), context.getLine(), name2, type2);
    }

    public static void traceEnd(ThreadContext context) {
        String name2 = context.getFrameName();
        RubyModule type2 = context.getFrameKlazz();
        context.getRuntime().callEventHooks(context, RubyEvent.END, context.getFile(), context.getLine(), name2, type2);
    }

    public static String interpretAliasUndefName(Node nameNode, Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        String name2;
        if (nameNode instanceof LiteralNode) {
            name2 = ((LiteralNode)nameNode).getName();
        } else {
            assert (nameNode instanceof DSymbolNode) : "Alias or Undef not literal or dsym";
            name2 = ((RubySymbol)nameNode.interpret(runtime2, context, self, aBlock)).asJavaString();
        }
        return name2;
    }

    public static void checkArgumentCount(ThreadContext context, IRubyObject[] args2, int min2, int max2) {
        RuntimeHelpers.checkArgumentCount(context, args2.length, min2, max2);
    }

    public static void checkArgumentCount(ThreadContext context, IRubyObject[] args2, int req) {
        RuntimeHelpers.checkArgumentCount(context, args2.length, req, req);
    }

    public static void checkArgumentCount(ThreadContext context, int length2, int min2, int max2) {
        int expected = 0;
        if (length2 < min2) {
            expected = min2;
        } else if (max2 > -1 && length2 > max2) {
            expected = max2;
        } else {
            return;
        }
        throw context.getRuntime().newArgumentError(length2, expected);
    }

    public static boolean isModuleAndHasConstant(IRubyObject left, String name2) {
        return left instanceof RubyModule && ((RubyModule)left).fastGetConstantFromNoConstMissing(name2) != null;
    }

    public static String getDefinedConstantOrBoundMethod(IRubyObject left, String name2) {
        if (RuntimeHelpers.isModuleAndHasConstant(left, name2)) {
            return "constant";
        }
        if (left.getMetaClass().isMethodBound(name2, true)) {
            return "method";
        }
        return null;
    }

    public static RubyModule getSuperClassForDefined(Ruby runtime2, RubyModule klazz) {
        RubyClass superklazz = klazz.getSuperClass();
        if (superklazz == null && klazz.isModule()) {
            superklazz = runtime2.getObject();
        }
        return superklazz;
    }

    public static boolean isGenerationEqual(IRubyObject object, int generation) {
        RubyClass metaClass = object instanceof RubyBasicObject ? ((RubyBasicObject)object).getMetaClass() : object.getMetaClass();
        return metaClass.getCacheToken() == generation;
    }

    public static String[] getScopeNames(String scopeNames) {
        StringTokenizer toker = new StringTokenizer(scopeNames, ";");
        ArrayList<String> list2 = new ArrayList<String>(10);
        while (toker.hasMoreTokens()) {
            list2.add(toker.nextToken().intern());
        }
        return list2.toArray(new String[list2.size()]);
    }

    public static IRubyObject[] arraySlice1N(IRubyObject arrayish) {
        arrayish = RuntimeHelpers.aryToAry(arrayish);
        RubyArray arrayish2 = RuntimeHelpers.ensureMultipleAssignableRubyArray(arrayish, arrayish.getRuntime(), true);
        return new IRubyObject[]{RuntimeHelpers.arrayEntryOrNilZero(arrayish2), RuntimeHelpers.subarrayOrEmpty(arrayish2, arrayish2.getRuntime(), 1)};
    }

    public static IRubyObject arraySlice1(IRubyObject arrayish) {
        arrayish = RuntimeHelpers.aryToAry(arrayish);
        RubyArray arrayish2 = RuntimeHelpers.ensureMultipleAssignableRubyArray(arrayish, arrayish.getRuntime(), true);
        return RuntimeHelpers.arrayEntryOrNilZero(arrayish2);
    }

    public static RubyClass metaclass(IRubyObject object) {
        return object instanceof RubyBasicObject ? ((RubyBasicObject)object).getMetaClass() : object.getMetaClass();
    }

    public static String rawBytesToString(byte[] bytes2) {
        char[] chars2 = new char[bytes2.length];
        for (int i2 = 0; i2 < bytes2.length; ++i2) {
            chars2[i2] = (char)bytes2[i2];
        }
        return new String(chars2);
    }

    public static byte[] stringToRawBytes(String string2) {
        char[] chars2 = string2.toCharArray();
        byte[] bytes2 = new byte[chars2.length];
        for (int i2 = 0; i2 < chars2.length; ++i2) {
            bytes2[i2] = (byte)chars2[i2];
        }
        return bytes2;
    }

    public static String encodeCaptureOffsets(int[] scopeOffsets) {
        char[] encoded = new char[scopeOffsets.length * 2];
        for (int i2 = 0; i2 < scopeOffsets.length; ++i2) {
            int offDepth = scopeOffsets[i2];
            char off = (char)(offDepth & 0xFFFF);
            char depth = (char)(offDepth >> 16);
            encoded[2 * i2] = off;
            encoded[2 * i2 + 1] = depth;
        }
        return new String(encoded);
    }

    public static int[] decodeCaptureOffsets(String encoded) {
        char[] chars2 = encoded.toCharArray();
        int[] scopeOffsets = new int[chars2.length / 2];
        for (int i2 = 0; i2 < scopeOffsets.length; ++i2) {
            char off = chars2[2 * i2];
            char depth = chars2[2 * i2 + 1];
            scopeOffsets[i2] = depth << 16 | off;
        }
        return scopeOffsets;
    }

    public static IRubyObject match2AndUpdateScope(IRubyObject receiver2, ThreadContext context, IRubyObject value2, String scopeOffsets) {
        DynamicScope scope = context.getCurrentScope();
        IRubyObject match2 = ((RubyRegexp)receiver2).op_match(context, value2);
        RuntimeHelpers.updateScopeWithCaptures(context, scope, RuntimeHelpers.decodeCaptureOffsets(scopeOffsets), value2);
        return match2;
    }

    public static void updateScopeWithCaptures(ThreadContext context, DynamicScope scope, int[] scopeOffsets, IRubyObject result) {
        Ruby runtime2 = context.runtime;
        if (result.isNil()) {
            IRubyObject nil = runtime2.getNil();
            for (int i2 = 0; i2 < scopeOffsets.length; ++i2) {
                scope.setValue(nil, scopeOffsets[i2], 0);
            }
        } else {
            RubyMatchData matchData = (RubyMatchData)scope.getBackRef(runtime2);
            IRubyObject[] namedValues = matchData.getNamedBackrefValues(runtime2);
            for (int i3 = 0; i3 < scopeOffsets.length; ++i3) {
                scope.setValue(namedValues[i3], scopeOffsets[i3] & 0xFFFF, scopeOffsets[i3] >> 16);
            }
        }
    }

    public static RubyArray argsPush(RubyArray first2, IRubyObject second) {
        return ((RubyArray)first2.dup()).append(second);
    }

    public static RubyArray argsCat(IRubyObject first2, IRubyObject second) {
        Ruby runtime2 = first2.getRuntime();
        RubyArray secondArgs = runtime2.is1_9() ? RuntimeHelpers.splatValue19(second) : RuntimeHelpers.splatValue(second);
        return ((RubyArray)RuntimeHelpers.ensureRubyArray(runtime2, first2).dup()).concat(secondArgs);
    }

    public static String encodeParameterList(ArgsNode argsNode) {
        StringBuilder builder = new StringBuilder();
        boolean added = false;
        if (argsNode.getPre() != null) {
            for (Node preNode : argsNode.getPre().childNodes()) {
                if (added) {
                    builder.append(';');
                }
                added = true;
                if (preNode instanceof MultipleAsgn19Node) {
                    builder.append("nil");
                    continue;
                }
                builder.append("q").append(((ArgumentNode)preNode).getName());
            }
        }
        if (argsNode.getOptArgs() != null) {
            for (Node optNode : argsNode.getOptArgs().childNodes()) {
                if (added) {
                    builder.append(';');
                }
                added = true;
                builder.append("o");
                if (optNode instanceof OptArgNode) {
                    builder.append(((OptArgNode)optNode).getName());
                    continue;
                }
                if (optNode instanceof LocalAsgnNode) {
                    builder.append(((LocalAsgnNode)optNode).getName());
                    continue;
                }
                if (!(optNode instanceof DAsgnNode)) continue;
                builder.append(((DAsgnNode)optNode).getName());
            }
        }
        if (argsNode.getRestArg() >= 0) {
            if (added) {
                builder.append(';');
            }
            added = true;
            if (argsNode.getRestArgNode() instanceof UnnamedRestArgNode) {
                if (((UnnamedRestArgNode)argsNode.getRestArgNode()).isStar()) {
                    builder.append("R");
                }
            } else {
                builder.append("r").append(argsNode.getRestArgNode().getName());
            }
        }
        if (argsNode.getPost() != null) {
            for (Node postNode : argsNode.getPost().childNodes()) {
                if (added) {
                    builder.append(';');
                }
                added = true;
                if (postNode instanceof MultipleAsgn19Node) {
                    builder.append("nil");
                    continue;
                }
                builder.append("q").append(((ArgumentNode)postNode).getName());
            }
        }
        if (argsNode.getBlock() != null) {
            if (added) {
                builder.append(';');
            }
            added = true;
            builder.append("b").append(argsNode.getBlock().getName());
        }
        if (!added) {
            builder.append("NONE");
        }
        return builder.toString();
    }

    public static RubyArray parameterListToParameters(Ruby runtime2, String[] parameterList, boolean isLambda) {
        RubyArray parms = RubyArray.newEmptyArray(runtime2);
        for (String param : parameterList) {
            if (param.equals("NONE")) break;
            RubyArray elem = RubyArray.newEmptyArray(runtime2);
            if (param.equals("nil")) {
                elem.add(RubySymbol.newSymbol(runtime2, isLambda ? "req" : "opt"));
                parms.add(elem);
                continue;
            }
            if (param.charAt(0) == 'q') {
                elem.add(RubySymbol.newSymbol(runtime2, isLambda ? "req" : "opt"));
            } else if (param.charAt(0) == 'r') {
                elem.add(RubySymbol.newSymbol(runtime2, "rest"));
            } else {
                if (param.charAt(0) == 'R') {
                    elem.add(RubySymbol.newSymbol(runtime2, "rest"));
                    parms.add(elem);
                    continue;
                }
                if (param.charAt(0) == 'o') {
                    elem.add(RubySymbol.newSymbol(runtime2, "opt"));
                    if (param.length() == 1) {
                        parms.add(elem);
                        continue;
                    }
                } else if (param.charAt(0) == 'b') {
                    elem.add(RubySymbol.newSymbol(runtime2, "block"));
                }
            }
            elem.add(RubySymbol.newSymbol(runtime2, param.substring(1)));
            parms.add(elem);
        }
        return parms;
    }

    public static String getDefinedCall(ThreadContext context, IRubyObject self, IRubyObject receiver2, String name2) {
        RubyClass metaClass = receiver2.getMetaClass();
        DynamicMethod method2 = metaClass.searchMethod(name2);
        Visibility visibility = method2.getVisibility();
        if (visibility != Visibility.PRIVATE && (visibility != Visibility.PROTECTED || metaClass.getRealClass().isInstance(self)) && !method2.isUndefined()) {
            return "method";
        }
        if (context.getRuntime().is1_9() && receiver2.callMethod(context, "respond_to_missing?", new IRubyObject[]{context.getRuntime().newSymbol(name2), context.getRuntime().getFalse()}).isTrue()) {
            return "method";
        }
        return null;
    }

    public static String getDefinedNot(Ruby runtime2, String definition) {
        if (definition != null && runtime2.is1_9()) {
            definition = "method";
        }
        return definition;
    }

    public static IRubyObject invokedynamic(ThreadContext context, IRubyObject self, int index2) {
        RubyClass metaclass = self.getMetaClass();
        String name2 = MethodIndex.METHOD_NAMES[index2];
        return RuntimeHelpers.getMethodCached(context, metaclass, index2, name2).call(context, self, metaclass, name2);
    }

    public static IRubyObject invokedynamic(ThreadContext context, IRubyObject self, int index2, IRubyObject arg0) {
        RubyClass metaclass = self.getMetaClass();
        String name2 = MethodIndex.METHOD_NAMES[index2];
        return RuntimeHelpers.getMethodCached(context, metaclass, index2, name2).call(context, self, (RubyModule)metaclass, name2, arg0);
    }

    private static DynamicMethod getMethodCached(ThreadContext context, RubyClass metaclass, int index2, String name2) {
        if (metaclass.index >= 39) {
            return metaclass.searchMethod(name2);
        }
        return context.runtimeCache.getMethod(context, metaclass, metaclass.index * (index2 + 1), name2);
    }

    private static class MethodMissingMethod
    extends DynamicMethod {
        private final DynamicMethod delegate;
        private final CallType lastCallStatus;

        public MethodMissingMethod(DynamicMethod delegate, CallType lastCallStatus) {
            this.delegate = delegate;
            this.lastCallStatus = lastCallStatus;
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            context.setLastCallStatus(this.lastCallStatus);
            return this.delegate.call(context, self, clazz, "method_missing", RuntimeHelpers.prepareMethodMissingArgs(args2, context, name2), block);
        }

        public DynamicMethod dup() {
            return this;
        }
    }
}

