/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.ext.ffi.Factory;
import org.jruby.ext.ffi.Platform;
import org.jruby.runtime.load.Library;

public class FFIService
implements Library {
    public void load(Ruby runtime2, boolean wrap2) throws IOException {
        if (!RubyInstanceConfig.nativeEnabled) {
            throw runtime2.newLoadError("Native API access is disabled");
        }
        if (!Platform.getPlatform().isSupported()) {
            throw runtime2.newLoadError("Unsupported platform: " + Platform.getPlatform().getName());
        }
        RubyModule ffi2 = runtime2.defineModule("FFI");
        try {
            Factory.getInstance().init(runtime2, ffi2);
        }
        catch (Exception e) {
            throw runtime2.newLoadError("Could not load FFI Provider: " + e.getLocalizedMessage() + " See http://jira.codehaus.org/browse/JRUBY-4583");
        }
    }
}

