/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import java.util.Map;
import org.jruby.Ruby;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.internal.AbstractLocalContextProvider;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.internal.LocalContext;

public class ThreadSafeLocalContextProvider
extends AbstractLocalContextProvider {
    private ThreadLocal<LocalContext> contextHolder = new ThreadLocal<LocalContext>(){

        @Override
        public LocalContext initialValue() {
            return ThreadSafeLocalContextProvider.this.getInstance();
        }

        @Override
        public void remove() {
            LocalContext localContext = (LocalContext)this.get();
            localContext.remove();
        }
    };

    public ThreadSafeLocalContextProvider(LocalVariableBehavior behavior, boolean lazy) {
        this.behavior = behavior;
        this.lazy = lazy;
    }

    public Ruby getRuntime() {
        return this.contextHolder.get().getRuntime();
    }

    public BiVariableMap getVarMap() {
        return this.contextHolder.get().getVarMap();
    }

    public Map getAttributeMap() {
        return this.contextHolder.get().getAttributeMap();
    }

    public boolean isRuntimeInitialized() {
        return this.contextHolder.get().initialized;
    }

    public void terminate() {
        this.contextHolder.remove();
        this.contextHolder.set(null);
    }
}

