/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.variable.BiVariable;
import org.jruby.embed.variable.VariableInterceptor;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BiVariableMap<K, V>
implements Map<K, V> {
    private Ruby runtime;
    private List<String> varNames;
    private List<BiVariable> variables;
    private VariableInterceptor interceptor;
    private boolean lazy;

    public BiVariableMap(Ruby runtime2, LocalVariableBehavior behavior, boolean lazy) {
        this.runtime = runtime2;
        this.lazy = lazy;
        this.varNames = Collections.synchronizedList(new ArrayList());
        this.variables = Collections.synchronizedList(new ArrayList());
        this.interceptor = new VariableInterceptor(behavior);
    }

    public List<String> getNames() {
        return this.varNames;
    }

    public List<BiVariable> getVariables() {
        return this.variables;
    }

    public VariableInterceptor getVariableInterceptor() {
        return this.interceptor;
    }

    public Map getMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (BiVariable v : this.variables) {
            m.put(v.getName(), v.getJavaObject());
        }
        return m;
    }

    @Override
    public int size() {
        return this.varNames.size();
    }

    @Override
    public boolean isEmpty() {
        return this.varNames.isEmpty();
    }

    private void checkKey(Object key2) {
        if (key2 == null) {
            throw new NullPointerException("key is null");
        }
        if (!(key2 instanceof String)) {
            throw new ClassCastException("key is NOT String");
        }
        if (((String)key2).length() == 0) {
            throw new IllegalArgumentException("key is empty");
        }
    }

    @Override
    public boolean containsKey(Object key2) {
        this.checkKey(key2);
        return this.varNames.contains((String)key2);
    }

    @Override
    public boolean containsValue(Object value2) {
        for (BiVariable v : this.variables) {
            if (value2 != v.getJavaObject()) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key2) {
        return this.get(this.runtime.getTopSelf(), key2);
    }

    public V get(Object receiver2, Object key2) {
        BiVariable var;
        this.checkKey(key2);
        RubyObject robj = this.getReceiverObject(receiver2);
        if (this.lazy) {
            this.interceptor.tryLazyRetrieval(this, robj, key2);
        }
        if ((var = this.getVariable(robj, (String)key2)) == null) {
            return null;
        }
        return (V)var.getJavaObject();
    }

    private RubyObject getReceiverObject(Object receiver2) {
        if (receiver2 == null || !(receiver2 instanceof IRubyObject)) {
            return (RubyObject)this.runtime.getTopSelf();
        }
        if (receiver2 instanceof RubyObject) {
            return (RubyObject)receiver2;
        }
        return (RubyObject)((IRubyObject)receiver2).getRuntime().getTopSelf();
    }

    @Deprecated
    public BiVariable getVariable(String key2) {
        return this.getVariable((RubyObject)this.runtime.getTopSelf(), key2);
    }

    public BiVariable getVariable(RubyObject receiver2, String key2) {
        for (int i2 = 0; i2 < this.varNames.size(); ++i2) {
            BiVariable var;
            if (!key2.equals(this.varNames.get(i2)) || !(var = this.variables.get(i2)).isReceiverIdentical(receiver2)) continue;
            return var;
        }
        return null;
    }

    @Deprecated
    public void setVariable(BiVariable var) {
        this.setVariable((RubyObject)this.runtime.getTopSelf(), var);
    }

    public void setVariable(RubyObject receiver2, BiVariable var) {
        if (var == null) {
            return;
        }
        String key2 = var.getName();
        BiVariable old = this.getVariable(receiver2, key2);
        if (old != null) {
            old.setJavaObject(receiver2.getRuntime(), var.getJavaObject());
        } else {
            this.varNames.add(key2);
            this.variables.add(var);
        }
    }

    @Override
    public V put(K key2, V value2) {
        return this.put(this.runtime.getTopSelf(), key2, value2);
    }

    public V put(Object receiver2, K key2, V value2) {
        this.checkKey(key2);
        RubyObject robj = this.getReceiverObject(receiver2);
        String name2 = ((String)key2).intern();
        BiVariable v = this.getVariable(robj, name2);
        Object oldValue = null;
        if (v != null) {
            oldValue = v.getJavaObject();
            v.setJavaObject(robj.getRuntime(), value2);
        } else {
            v = this.interceptor.getVariableInstance(robj, name2, value2);
            if (v != null) {
                this.varNames.add(name2);
                this.variables.add(v);
            }
        }
        return (V)oldValue;
    }

    public String[] getLocalVarNames() {
        ArrayList<String> localVarNames = new ArrayList<String>();
        for (BiVariable v : this.variables) {
            if (v.getType() != BiVariable.Type.LocalVariable) continue;
            localVarNames.add(v.getName());
        }
        if (localVarNames.size() > 0) {
            return localVarNames.toArray(new String[localVarNames.size()]);
        }
        return null;
    }

    public IRubyObject[] getLocalVarValues() {
        ArrayList<IRubyObject> localVarValues = new ArrayList<IRubyObject>();
        for (BiVariable v : this.variables) {
            if (v.getType() != BiVariable.Type.LocalVariable) continue;
            localVarValues.add(v.getRubyObject());
        }
        if (localVarValues.size() > 0) {
            return localVarValues.toArray(new IRubyObject[localVarValues.size()]);
        }
        return null;
    }

    void inject(ManyVarsDynamicScope scope, int depth, IRubyObject receiver2) {
        this.interceptor.inject(this, this.runtime, scope, depth, receiver2);
    }

    void retrieve(IRubyObject receiver2) {
        RubyObject robj = this.getReceiverObject(receiver2);
        this.interceptor.retrieve(this, robj);
    }

    void terminate() {
        this.interceptor.terminateGlobalVariables(this.variables, this.runtime);
        this.interceptor.terminateLocalVariables(this.varNames, this.variables);
    }

    @Override
    public V remove(Object key2) {
        return this.remove(this.runtime.getTopSelf(), key2);
    }

    public V remove(Object receiver2, Object key2) {
        this.checkKey(key2);
        RubyObject robj = this.getReceiverObject(receiver2);
        String name2 = ((String)key2).intern();
        for (int i2 = 0; i2 < this.varNames.size(); ++i2) {
            BiVariable var;
            if (!name2.equals(this.varNames.get(i2)) || (var = this.variables.get(i2)).getReceiver() != robj) continue;
            this.varNames.remove(i2);
            BiVariable v = this.variables.remove(i2);
            v.remove();
            return (V)v.getJavaObject();
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        if (t == null) {
            throw new NullPointerException("map is null");
        }
        if (t.isEmpty()) {
            throw new IllegalArgumentException("map is empty");
        }
        Set<Map.Entry<K, V>> set = t.entrySet();
        for (Map.Entry<K, V> entry : set) {
            if (entry.getKey() instanceof String) {
                K key2 = entry.getKey();
                V value2 = entry.getValue();
                this.put(key2, value2);
                continue;
            }
            throw new ClassCastException("key is NOT String");
        }
    }

    @Override
    public void clear() {
        this.varNames.clear();
        for (BiVariable v : this.variables) {
            if (v == null) continue;
            v.remove();
        }
        this.variables.clear();
    }

    @Override
    public Set keySet() {
        if (this.varNames.isEmpty()) {
            return null;
        }
        HashSet<String> s2 = new HashSet<String>();
        for (String name2 : this.varNames) {
            s2.add(name2);
        }
        return s2;
    }

    @Override
    public Collection values() {
        if (this.varNames.isEmpty()) {
            return null;
        }
        ArrayList<Object> l = new ArrayList<Object>();
        for (BiVariable v : this.variables) {
            l.add(v.getJavaObject());
        }
        return l;
    }

    @Override
    public Set entrySet() {
        if (this.varNames.isEmpty()) {
            return null;
        }
        return this.getMap().entrySet();
    }

    public void update(String name2, BiVariable value2) {
        this.varNames.add(name2);
        this.variables.add(value2);
    }

    public boolean isLazy() {
        return this.lazy;
    }
}

