/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.RubyModule;
import org.jruby.compiler.ir.IRModule;
import org.jruby.compiler.ir.IRScope;
import org.jruby.compiler.ir.IRScript;
import org.jruby.compiler.ir.compiler_pass.AddBindingInstructions;
import org.jruby.compiler.ir.compiler_pass.CFG_Builder;
import org.jruby.compiler.ir.compiler_pass.CompilerPass;
import org.jruby.compiler.ir.compiler_pass.LiveVariableAnalysis;
import org.jruby.compiler.ir.compiler_pass.opts.DeadCodeElimination;
import org.jruby.compiler.ir.compiler_pass.opts.LocalOptimizationPass;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.RenamedVariable;
import org.jruby.compiler.ir.operands.TemporaryClosureVariable;
import org.jruby.compiler.ir.operands.TemporaryVariable;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.parser.StaticScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IRScopeImpl
implements IRScope {
    Operand container;
    RubyModule containerModule;
    IRScope lexicalParent;
    private String name;
    private Map<String, String> aliases = new HashMap<String, String>();
    private int nextClosureIndex = 0;
    private Map<String, Integer> nextVarIndex = new HashMap<String, Integer>();
    private StaticScope staticScope;

    public IRScopeImpl(IRScope lexicalParent, Operand container, String name2, StaticScope staticScope) {
        this.lexicalParent = lexicalParent;
        this.container = container;
        this.name = name2;
        this.staticScope = staticScope;
    }

    public void setContainer(Operand o) {
        this.container = o;
    }

    @Override
    public Operand getContainer() {
        return this.container;
    }

    public RubyModule getContainerModule() {
        return this.containerModule;
    }

    @Override
    public IRScope getLexicalParent() {
        return this.lexicalParent;
    }

    @Override
    public IRModule getNearestModule() {
        IRScope current2;
        for (current2 = this.lexicalParent; current2 != null && !(current2 instanceof IRModule) && !(current2 instanceof IRScript); current2 = current2.getLexicalParent()) {
        }
        if (current2 instanceof IRScript) {
            current2 = ((IRScript)current2).getRootClass();
        }
        return (IRModule)current2;
    }

    @Override
    public int getNextClosureId() {
        ++this.nextClosureIndex;
        return this.nextClosureIndex;
    }

    public Variable getNewTemporaryClosureVariable(int closureId) {
        return new TemporaryClosureVariable(closureId, this.allocateNextPrefixedName("%cl_" + closureId));
    }

    @Override
    public Variable getNewTemporaryVariable() {
        return new TemporaryVariable(this.allocateNextPrefixedName("%v"));
    }

    public Variable getNewInlineVariable() {
        return new RenamedVariable("%i", this.allocateNextPrefixedName("%i"));
    }

    @Override
    public int getTemporaryVariableSize() {
        return this.getPrefixCountSize("%v");
    }

    @Override
    public int getRenamedVariableSize() {
        return this.getPrefixCountSize("%i");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public abstract String getScopeName();

    @Override
    public Label getNewLabel(String prefix) {
        return new Label(prefix + "_" + this.allocateNextPrefixedName(prefix));
    }

    @Override
    public Label getNewLabel() {
        return this.getNewLabel("LBL");
    }

    private int allocateNextPrefixedName(String prefix) {
        int index2 = this.getPrefixCountSize(prefix);
        this.nextVarIndex.put(prefix, index2 + 1);
        return index2;
    }

    protected int getPrefixCountSize(String prefix) {
        Integer index2 = this.nextVarIndex.get(prefix);
        if (index2 == null) {
            return 0;
        }
        return index2;
    }

    @Override
    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    @Override
    public void addInstr(Instr i2) {
        throw new RuntimeException("Encountered instruction add in a non-execution scope!");
    }

    @Override
    public void recordMethodAlias(String newName, String oldName) {
        this.aliases.put(oldName, newName);
    }

    @Override
    public String unaliasMethodName(String name2) {
        String n = name2;
        String a = null;
        do {
            if ((a = this.aliases.get(n)) == null) continue;
            n = a;
        } while (a != null);
        return n;
    }

    public List<Instr> getInstrs() {
        return null;
    }

    public String toString() {
        return this.getScopeName() + " " + this.getName();
    }

    public void runCompilerPassOnNestedScopes(CompilerPass p2) {
    }

    @Override
    public void runCompilerPass(CompilerPass p2) {
        boolean isPreOrder = p2.isPreOrder();
        if (isPreOrder) {
            p2.run(this);
        }
        this.runCompilerPassOnNestedScopes(p2);
        if (!isPreOrder) {
            p2.run(this);
        }
    }

    @Override
    public void prepareForInterpretation() {
        this.runCompilerPass(new LocalOptimizationPass());
        this.runCompilerPass(new CFG_Builder());
        this.runCompilerPass(new LiveVariableAnalysis());
        this.runCompilerPass(new DeadCodeElimination());
        this.runCompilerPass(new AddBindingInstructions());
    }

    public String toStringInstrs() {
        return "";
    }

    public String toStringVariables() {
        return "";
    }
}

