/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.make.util;

import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.tools.cli.CommandLineManager;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ChmodMojo
extends AbstractMojo {
    private String mode;
    private boolean recursive;
    private List<String> chmodPaths;
    private CommandLineManager cliManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Commandline cli = new Commandline();
        cli.setExecutable("chmod");
        if (this.recursive) {
            cli.createArg().setLine("-R");
        }
        cli.createArg().setLine(this.mode);
        String aggregatedPaths = StringUtils.join(this.chmodPaths.iterator(), (String)" ");
        cli.createArg().setLine(aggregatedPaths);
        try {
            StreamConsumer consumer = this.cliManager.newDebugStreamConsumer();
            int result = this.cliManager.execute(cli, consumer, consumer);
            if (result != 0) {
                throw new MojoExecutionException("chmod command returned an exit value != 0. Aborting build; see debug output for more information.");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Failed to execute chmod with mode: " + this.mode + " on files:\n" + this.chmodPaths + "\n\nReason: " + e.getMessage(), (Exception)((Object)e));
        }
    }
}

