/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tools.project.extras;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredPOMPropertyMissingException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final MavenProject project;
    private final Set<String> missingProperties;
    private final String longMessage;

    public RequiredPOMPropertyMissingException(MavenProject project, String property, Throwable cause) {
        super("POM property: " + property + " is missing in project: " + project.getId(), cause);
        this.project = project;
        this.missingProperties = Collections.singleton(property);
        this.longMessage = RequiredPOMPropertyMissingException.formatLongMessage(this.missingProperties, project);
    }

    public RequiredPOMPropertyMissingException(MavenProject project, String property) {
        super("POM property: " + property + " is missing in project: " + project.getId());
        this.project = project;
        this.missingProperties = Collections.singleton(property);
        this.longMessage = RequiredPOMPropertyMissingException.formatLongMessage(this.missingProperties, project);
    }

    public RequiredPOMPropertyMissingException(MavenProject project, Set<String> missingProperties) {
        super("POM property: " + RequiredPOMPropertyMissingException.join(missingProperties, ",") + " are missing in project: " + project.getId());
        this.project = project;
        this.missingProperties = missingProperties;
        this.longMessage = RequiredPOMPropertyMissingException.formatLongMessage(missingProperties, project);
    }

    public MavenProject getProject() {
        return this.project;
    }

    public Set<String> getMissingProperties() {
        return this.missingProperties;
    }

    public String getLongMessage() {
        return this.longMessage;
    }

    private static String formatLongMessage(Set<String> missingProperties, MavenProject project) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Missing one or more POM properties. The following is required in your POM:\n\n");
        buffer.append("<properties>\n");
        for (String property : missingProperties) {
            buffer.append("  <").append(property).append(">VALUE</").append(property).append(">\n");
        }
        buffer.append("</properties>\n");
        buffer.append("\n*** NOTE: Please verify that the POM for: " + project.getId() + " is in at least one of your repositories. ***\n");
        return buffer.toString();
    }

    private static String join(Set<String> properties, String separator) {
        StringBuffer buffer = new StringBuffer();
        Iterator<String> it = properties.iterator();
        while (it.hasNext()) {
            String property = it.next();
            buffer.append(property);
            if (!it.hasNext()) continue;
            buffer.append(separator);
        }
        return buffer.toString();
    }
}

