/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tools.project.extras;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.mojo.tools.project.extras.ArtifactPathResolver;
import org.codehaus.mojo.tools.project.extras.PathResolutionException;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefixPropertyPathResolver
implements ArtifactPathResolver {
    private final MavenProjectBuilder projectBuilder;
    private final List<ArtifactRepository> remoteRepositories;
    private final ArtifactRepository localRepository;
    private final Log log;
    private final ArtifactFactory artifactFactory;

    public PrefixPropertyPathResolver(MavenProjectBuilder projectBuilder, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository, ArtifactFactory artifactFactory, Log log) {
        this.projectBuilder = projectBuilder;
        this.remoteRepositories = remoteRepositories;
        this.localRepository = localRepository;
        this.artifactFactory = artifactFactory;
        this.log = log;
    }

    @Override
    public File resolve(Artifact artifact) throws PathResolutionException {
        MavenProject project;
        try {
            Artifact dummy = this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            project = this.projectBuilder.buildFromRepository(dummy, this.remoteRepositories, this.localRepository);
        }
        catch (ProjectBuildingException e) {
            throw new PathResolutionException("Cannot build project for artifact: " + artifact + ". Reason: " + e.getMessage(), e);
        }
        String prefix = project.getProperties().getProperty("prefix");
        ArrayList<Object> valueSources = new ArrayList<Object>();
        valueSources.add(new ObjectBasedValueSource((Object)project));
        valueSources.add(new MapBasedValueSource((Map)project.getProperties()));
        valueSources.add(new MapBasedValueSource((Map)System.getProperties()));
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator(valueSources);
        try {
            prefix = interpolator.interpolate(prefix, "project|pom");
        }
        catch (InterpolationException e) {
            throw new PathResolutionException("Cannot build project for artifact: " + artifact + ". Reason: " + e.getMessage(), e);
        }
        this.log.debug((CharSequence)("Prefix for project: " + project.getId() + " is: " + prefix));
        return new File(prefix);
    }
}

