/*
 * Decompiled with CFR 0.152.
 */
package cz.sokoban4j.agents;

import cz.sokoban4j.Sokoban;
import cz.sokoban4j.agents.ArtificialAgent;
import cz.sokoban4j.simulation.SokobanResult;
import cz.sokoban4j.simulation.actions.EDirection;
import cz.sokoban4j.simulation.actions.compact.CAction;
import cz.sokoban4j.simulation.actions.compact.CMove;
import cz.sokoban4j.simulation.actions.compact.CPush;
import cz.sokoban4j.simulation.agent.IAgent;
import cz.sokoban4j.simulation.board.compact.BoardCompact;
import java.util.ArrayList;
import java.util.List;

public class DFS1Agent
extends ArtificialAgent {
    protected List<EDirection> result;
    protected BoardCompact board;
    protected boolean solutionFound;
    protected int searchedNodes;
    protected long searchStartMillis;

    protected List<EDirection> think(BoardCompact board) {
        this.board = board;
        this.result = new ArrayList<EDirection>();
        this.solutionFound = false;
        this.searchedNodes = 0;
        System.out.println("=================");
        System.out.println("===== BOARD =====");
        this.board.debugPrint();
        System.out.println("=================");
        this.searchStartMillis = System.currentTimeMillis();
        this.dfs(13);
        long searchTime = System.currentTimeMillis() - this.searchStartMillis;
        System.out.println("SEARCH TOOK:   " + searchTime + " ms");
        System.out.println("NODES VISITED: " + this.searchedNodes);
        System.out.println("PERFORMANCE:   " + (double)this.searchedNodes / (double)searchTime * 1000.0 + " nodes/sec");
        System.out.println("SOLUTION:      " + (this.result.size() == 0 ? "NOT FOUND" : "FOUND in " + this.result.size() + " steps"));
        if (this.result.size() > 0) {
            System.out.print("STEPS:         ");
            for (EDirection winDirection : this.result) {
                System.out.print(winDirection + " -> ");
            }
            System.out.println("BOARD SOLVED!");
        }
        System.out.println("=================");
        if (this.result.size() == 0) {
            throw new RuntimeException("FAILED TO SOLVE THE BOARD...");
        }
        return this.result;
    }

    private boolean dfs(int level) {
        if (level <= 0) {
            return false;
        }
        ++this.searchedNodes;
        ArrayList<Object> actions = new ArrayList<Object>(4);
        for (CMove cMove : CMove.getActions()) {
            if (!cMove.isPossible(this.board)) continue;
            actions.add(cMove);
        }
        for (CPush cPush : CPush.getActions()) {
            if (!cPush.isPossible(this.board)) continue;
            actions.add(cPush);
        }
        for (CAction cAction : actions) {
            this.result.add(cAction.getDirection());
            cAction.perform(this.board);
            if (this.board.isVictory()) {
                return true;
            }
            if (this.dfs(level - 1)) {
                return true;
            }
            this.result.remove(this.result.size() - 1);
            cAction.reverse(this.board);
        }
        return false;
    }

    public static void main(String[] args) {
        SokobanResult result = Sokoban.playAgentLevel((String)"../Sokoban4J/levels/Easy/level0001.s4jl", (IAgent)new DFS1Agent());
        System.out.println("DFS1Agent result: " + result.getResult());
        System.exit(0);
    }
}

