/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutionEstimator;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutorState;
import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorState;
import cz.cuni.amis.pogamut.base.agent.navigation.impl.BasePathExecutor;
import cz.cuni.amis.pogamut.base.agent.navigation.impl.PrecomputedPathFuture;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectFirstEncounteredEvent;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathExecutorHelper;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathNavigator;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathExecutorStuckState;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.loquenavigator.LoqueNavigator;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.timeoutestimator.UT2004BasicTimeoutEstimator;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SetRoute;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.utils.PogamutUT2004Property;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.Tuple2;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UT2004PathExecutor<PATH_ELEMENT extends ILocated>
extends BasePathExecutor<PATH_ELEMENT>
implements IUT2004PathExecutor<PATH_ELEMENT>,
IUT2004PathExecutorHelper<PATH_ELEMENT> {
    public static final int PATH_MERGE_CUTOFF = 3;
    private IUT2004PathNavigator<PATH_ELEMENT> navigator;
    private UT2004Bot bot;
    private Self self;
    private long pathExecutionStart = Long.MIN_VALUE;
    private double pathExecutionTimeout = Double.POSITIVE_INFINITY;
    private IWorldObjectEventListener<Self, WorldObjectFirstEncounteredEvent<Self>> selfListener = new IWorldObjectEventListener<Self, WorldObjectFirstEncounteredEvent<Self>>(){

        public void notify(WorldObjectFirstEncounteredEvent<Self> event) {
            UT2004PathExecutor.this.self = (Self)event.getObject();
        }
    };
    private IWorldEventListener<EndMessage> endMessageListener = new IWorldEventListener<EndMessage>(){

        public void notify(EndMessage event) {
            UT2004PathExecutor.this.eventEndMessage();
        }
    };
    private IWorldEventListener<BotKilled> botKilledListener = new IWorldEventListener<BotKilled>(){

        public void notify(BotKilled event) {
            UT2004PathExecutor.this.stop();
        }
    };
    private IPathExecutionEstimator<PATH_ELEMENT> timeoutEstimator;
    private ILocated focus;
    private Boolean sendingSetRoute = Pogamut.getPlatform().getBooleanProperty(PogamutUT2004Property.POGAMUT_UT2004_PATH_EXECUTOR_SEND_SET_ROUTE.getKey());

    public UT2004PathExecutor(UT2004Bot bot, AgentInfo info, AdvancedLocomotion body, IUT2004PathNavigator<PATH_ELEMENT> navigator) {
        this(bot, info, body, navigator, null);
    }

    public UT2004PathExecutor(UT2004Bot bot, AgentInfo info, AdvancedLocomotion move, IUT2004PathNavigator<PATH_ELEMENT> navigator, Logger log) {
        super(log);
        if (this.getLog() == null) {
            this.setLog((Logger)bot.getLogger().getCategory(this.getClass().getSimpleName()));
        }
        NullCheck.check((Object)bot, (String)"bot");
        if (this.sendingSetRoute == null) {
            this.sendingSetRoute = false;
        }
        this.bot = bot;
        this.navigator = navigator;
        if (this.navigator == null) {
            this.navigator = new LoqueNavigator(bot, info, move, this.getLog());
        }
        this.navigator.setBot(bot);
        this.navigator.setExecutor(this);
        bot.getWorldView().addObjectListener(Self.class, WorldObjectFirstEncounteredEvent.class, this.selfListener);
        bot.getWorldView().addEventListener(EndMessage.class, this.endMessageListener);
        bot.getWorldView().addEventListener(BotKilled.class, this.botKilledListener);
        this.timeoutEstimator = new UT2004BasicTimeoutEstimator();
    }

    public UT2004PathExecutor<PATH_ELEMENT> setTimeoutEstimator(IPathExecutionEstimator<PATH_ELEMENT> timeoutEstimator) {
        this.timeoutEstimator = timeoutEstimator;
        return this;
    }

    protected IPathExecutorState createState(PathExecutorState state) {
        switch (state) {
            case STUCK: {
                UT2004PathExecutorStuckState newState = new UT2004PathExecutorStuckState();
                IStuckDetector detector = this.checkStuckDetectors();
                if (detector == null) {
                    newState.setGlobalTimeout(true);
                } else {
                    newState.setStuckDetector(detector);
                }
                newState.setLink(this.navigator.getCurrentLink());
                return newState;
            }
        }
        return super.createState(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extendPath(List<PATH_ELEMENT> morePath) {
        Object object = this.mutex;
        synchronized (object) {
            if (morePath == null) {
                this.log.warning("Cannot extendPath() with NULL path.");
                return;
            }
            if (morePath.size() == 0) {
                this.log.warning("Cannot extendPath() with 0-sized path.");
                return;
            }
            List currPath = this.getPath();
            if (currPath == null) {
                this.log.warning("Does not follow any path, cannot extendPath() now!");
                return;
            }
            int currIndex = this.getPathElementIndex();
            Tuple2<List<PATH_ELEMENT>, Integer> mergedPathAndIndex = this.mergePath(currPath, currIndex, morePath);
            List newPath = (List)mergedPathAndIndex.getFirst();
            int newPathIndex = (Integer)mergedPathAndIndex.getSecond();
            this.pathFuture = new PrecomputedPathFuture(newPath.get(0), newPath.get(newPath.size() - 1), newPath);
            int previousPathIndexDelta = this.pathElementIndex - this.previousPathElementIndex;
            this.pathElementIndex = newPathIndex;
            this.previousPathElementIndex = newPathIndex - previousPathIndexDelta;
            if (this.previousPathElementIndex < 0) {
                this.previousPathElementIndex = 0;
            }
            this.navigator.pathExtended(newPath, this.pathElementIndex);
        }
    }

    protected Tuple2<List<PATH_ELEMENT>, Integer> mergePath(List<PATH_ELEMENT> currPath, int currIndex, List<PATH_ELEMENT> morePath) {
        ILocated element;
        int i;
        ILocated currPathElement = currIndex >= 0 && currIndex < currPath.size() ? (ILocated)currPath.get(currIndex) : null;
        ILocated lastCurrPathElement = (ILocated)currPath.get(currPath.size() - 1);
        ILocated firstMorePathElement = (ILocated)morePath.get(0);
        boolean mergeFirst = lastCurrPathElement.getLocation().getDistance(firstMorePathElement.getLocation()) < 50.0;
        int cutOffIndex = currIndex > 3 ? currIndex - 3 : 0;
        int newPathSize = currPath.size() - cutOffIndex + morePath.size() + (mergeFirst ? -1 : 0);
        ArrayList<ILocated> mergedPath = new ArrayList<ILocated>(newPathSize);
        int mergedIndex = currIndex - cutOffIndex;
        for (i = cutOffIndex; i < currPath.size(); ++i) {
            element = (ILocated)currPath.get(i);
            mergedPath.add(element);
        }
        int n = i = mergeFirst ? 1 : 0;
        while (i < morePath.size()) {
            element = (ILocated)morePath.get(i);
            mergedPath.add(element);
            ++i;
        }
        return new Tuple2(mergedPath, (Object)mergedIndex);
    }

    @Override
    public NavPointNeighbourLink getCurrentLink() {
        return this.navigator.getCurrentLink();
    }

    protected void stopped() {
    }

    protected void followPathImpl() {
    }

    protected void pathComputedImpl() {
        if (this.getPath().size() == 0) {
            this.targetReached();
        } else {
            if (this.sendingSetRoute.booleanValue()) {
                this.bot.getAct().act((CommandMessage)new SetRoute().setRoute(this.getPath()));
            }
            this.navigator.newPath(this.getPath());
            this.pathExecutionStart = System.currentTimeMillis();
            this.calculateTimeout();
        }
    }

    protected void pathComputationFailedImpl() {
    }

    protected void switchToAnotherPathElementImpl() {
        List path = this.getPath();
        if (path == null) {
            return;
        }
        if (path.size() > 31 + this.getPathElementIndex()) {
            ArrayList pathPart = new ArrayList(32);
            for (int i = this.getPathElementIndex(); i < path.size() && i < this.getPathElementIndex() + 31; ++i) {
                pathPart.add(path.get(i));
            }
            this.bot.getAct().act((CommandMessage)new SetRoute().setRoute(pathPart));
        }
        ILocated pathElement = (ILocated)this.getPathElement();
        for (IStuckDetector detector : this.getStuckDetectors()) {
            detector.setBotTarget(pathElement);
        }
    }

    protected void calculateTimeout() {
        IPathExecutionEstimator<PATH_ELEMENT> estimator = this.timeoutEstimator;
        this.pathExecutionTimeout = estimator != null ? estimator.getTimeout(this.getPath()) : 9.223372036854776E18;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void eventEndMessage() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.inState(new PathExecutorState[]{PathExecutorState.PATH_COMPUTED}) || this.inState(new PathExecutorState[]{PathExecutorState.SWITCHED_TO_ANOTHER_PATH_ELEMENT})) {
                this.navigate();
            }
        }
    }

    protected void navigate() {
        double timeDelta;
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer("navigating");
        }
        if ((timeDelta = (double)(System.currentTimeMillis() - this.pathExecutionStart)) > this.pathExecutionTimeout) {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.finer("TIMEOUT! (" + this.pathExecutionTimeout + "ms)");
            }
            this.stuck();
            return;
        }
        IStuckDetector detector = this.checkStuckDetectors();
        if (detector != null) {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning(detector.getClass().getSimpleName() + " has reported that the bot has stuck");
            }
            this.stuck();
        } else {
            this.navigator.navigate(this.focus);
        }
    }

    @Override
    public double getRemainingDistance() {
        double result = 0.0;
        List path = this.getPath();
        if (path == null) {
            return 0.0;
        }
        int currPathIndex = this.getPathElementIndex();
        if (currPathIndex >= path.size()) {
            return 0.0;
        }
        if (currPathIndex < 0) {
            currPathIndex = 0;
        }
        result += this.self.getLocation().getDistance(((ILocated)path.get(currPathIndex)).getLocation());
        for (int i = ++currPathIndex; i < path.size(); ++i) {
            result += ((ILocated)path.get(i - 1)).getLocation().getDistance(((ILocated)path.get(i)).getLocation());
        }
        return result;
    }

    public ILocated getFocus() {
        return this.focus;
    }

    public void setFocus(ILocated located) {
        this.focus = located;
    }

    @Override
    public List<IStuckDetector> getStuckDetectors() {
        return this.stuckDetectors;
    }

    protected void preStuckImpl() {
        super.preStuckImpl();
    }

    protected void stuckImpl() {
    }

    protected void stopImpl() {
        super.stopImpl();
    }

    protected void preTargetReachedImpl() {
        super.preTargetReachedImpl();
    }

    protected void targetReachedImpl() {
    }

    public IUT2004PathNavigator<PATH_ELEMENT> getNavigator() {
        return this.navigator;
    }
}

