/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.visualizer.ut3.util;

import cz.cuni.amis.pogamut.unreal.communication.messages.gbinfomessages.IPlayer;
import cz.cuni.amis.pogamut.unreal.communication.worldview.map.IUnrealWaypoint;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Point;
import nl.tudelft.goal.ut2004.visualizer.gui.action.AddInventoryAction;
import nl.tudelft.goal.ut2004.visualizer.gui.action.SpawnItemAction;
import nl.tudelft.goal.visualizer.ut3.util.Unreal3Actors;

public class UT3MenuBuilder {
    public static Menu buildUT3NavPointMenu(IUnrealWaypoint navPoint, Point at) {
        Menu UT3Menu = UT3MenuBuilder.buildUT3Menu();
        UT3Menu.add(UT3MenuBuilder.buildUTObjectMenu(navPoint, "Weapons", Unreal3Actors.WEAPON_TYPES));
        UT3Menu.add(UT3MenuBuilder.buildUTObjectMenu(navPoint, "Deployables", Unreal3Actors.DEPLOYABLE_TYPES));
        UT3Menu.add(UT3MenuBuilder.buildUTObjectMenu(navPoint, "Ammo", Unreal3Actors.AMMO_TYPES));
        UT3Menu.add(UT3MenuBuilder.buildUTObjectMenu(navPoint, "Pickups", Unreal3Actors.PICKUP_TYPES));
        UT3Menu.add(UT3MenuBuilder.buildUTObjectMenu(navPoint, "Vehicles", Unreal3Actors.VEHICLE_TYPES));
        return UT3Menu;
    }

    public static Menu buildUT3AgentMenu(IPlayer bot) {
        Menu UT3Menu = UT3MenuBuilder.buildUT3Menu();
        UT3Menu.add(UT3MenuBuilder.buildUTObjectInventoryMenu(bot, "Weapons", Unreal3Actors.WEAPON_TYPES));
        UT3Menu.add(UT3MenuBuilder.buildUTObjectInventoryMenu(bot, "Deployables", Unreal3Actors.DEPLOYABLE_TYPES));
        UT3Menu.add(UT3MenuBuilder.buildUTObjectInventoryMenu(bot, "Ammo", Unreal3Actors.AMMO_TYPES));
        UT3Menu.add(UT3MenuBuilder.buildUTObjectInventoryMenu(bot, "Pickups", Unreal3Actors.PICKUP_TYPES));
        return UT3Menu;
    }

    private static Menu buildUT3Menu() {
        return new Menu("UT3");
    }

    private static Menu buildUTObjectInventoryMenu(IPlayer bot, String menuName, String[] UTObjects) {
        Menu addUTObject = new Menu(menuName);
        for (String id : UTObjects) {
            MenuItem UTObject = new MenuItem(id);
            UTObject.addActionListener(new AddInventoryAction(bot, id));
            addUTObject.add(UTObject);
        }
        return addUTObject;
    }

    private static Menu buildUTObjectMenu(IUnrealWaypoint navPoint, String menuName, String[] UTObjects) {
        Menu spawnUTObject = new Menu(menuName);
        for (String id : UTObjects) {
            MenuItem UTObject = new MenuItem(id);
            UTObject.addActionListener(new SpawnItemAction(navPoint, id));
            spawnUTObject.add(UTObject);
        }
        return spawnUTObject;
    }
}

