/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.gui.dialogs;

import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.unreal.communication.messages.gbinfomessages.IPlayer;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.utils.collections.CollectionEventListener;
import cz.cuni.amis.utils.collections.ObservableCollection;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import nl.tudelft.goal.ut2004.visualizer.controller.ServerController;
import nl.tudelft.goal.ut2004.visualizer.gui.action.KickAction;
import nl.tudelft.goal.ut2004.visualizer.gui.action.RespawnRandomAction;
import nl.tudelft.goal.ut2004.visualizer.util.CollectionEventAdaptor;
import nl.tudelft.goal.ut2004.visualizer.util.WindowPersistenceHelper;

public class ListPlayerDialog
extends JDialog {
    private WindowPersistenceHelper persistenceHelper;

    public ListPlayerDialog(Frame parent) {
        super(parent, false);
        this.setTitle("Players");
        this.add(new PlayerDisplayList());
        this.setSize(300, 500);
        this.persistenceHelper = new WindowPersistenceHelper(this);
        this.persistenceHelper.load();
    }

    private class PlayerDisplay
    extends JPanel {
        private Player player;

        public PlayerDisplay(Player player) {
            this.player = player;
            this.setLayout(new FlowLayout(0));
            this.add(new JButton(new KickAction((IPlayer)player)));
            this.add(new JButton(new RespawnRandomAction((IPlayer)player)));
            this.add(new JLabel(player.getName()));
        }
    }

    private class PlayerDisplayList
    extends JPanel {
        private HashMap<UnrealId, PlayerDisplay> displays = new HashMap();
        private Component verticalGlue = new Box.Filler(new Dimension(), new Dimension(), new Dimension(0, Integer.MAX_VALUE));

        public PlayerDisplayList() {
            this.setLayout(new BoxLayout(this, 1));
            this.add(this.verticalGlue);
            ObservableCollection<Player> players = ServerController.getInstance().getGameData().getPlayers();
            this.updateList((Collection<Player>)players);
            this.validate();
            players.addCollectionListener((CollectionEventListener)new CollectionEventAdaptor<Player>(){

                @Override
                public void postAddEvent(Collection<Player> alreadyAdded, Collection<Player> whereWereAdded) {
                    PlayerDisplayList.this.updateList(whereWereAdded);
                }

                @Override
                public void postRemoveEvent(Collection<Player> alreadyAdded, Collection<Player> whereWereRemoved) {
                    PlayerDisplayList.this.updateList(whereWereRemoved);
                }
            });
        }

        private void updateList(Collection<Player> players) {
            this.remove(this.verticalGlue);
            for (Player player : players) {
                PlayerDisplay display = this.displays.get(player.getId());
                if (display != null) continue;
                display = new PlayerDisplay(player);
                this.displays.put(player.getId(), display);
                this.add(display);
            }
            HashSet<UnrealId> ids = new HashSet<UnrealId>(this.displays.keySet());
            for (Player player : players) {
                ids.remove(player.getId());
            }
            for (UnrealId id : ids) {
                PlayerDisplay display = this.displays.remove(id);
                this.remove(display);
            }
            this.add(this.verticalGlue);
            this.validate();
            this.repaint();
        }
    }
}

