/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.circulinear;

import java.util.ArrayList;
import java.util.Collection;
import math.geom2d.Box2D;
import math.geom2d.circulinear.CirculinearBoundary2D;
import math.geom2d.circulinear.CirculinearContinuousCurve2D;
import math.geom2d.circulinear.CirculinearContour2D;
import math.geom2d.circulinear.CirculinearCurve2D;
import math.geom2d.circulinear.CirculinearCurve2DUtils;
import math.geom2d.circulinear.CirculinearCurveSet2D;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.Curve2DUtils;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.domain.BoundarySet2D;
import math.geom2d.domain.ContinuousOrientedCurve2D;
import math.geom2d.transform.CircleInversion2D;

public class CirculinearBoundarySet2D<T extends CirculinearContour2D>
extends BoundarySet2D<T>
implements CirculinearBoundary2D {
    public CirculinearBoundarySet2D() {
        this.curves = new ArrayList();
    }

    public CirculinearBoundarySet2D(int n) {
        this.curves = new ArrayList(n);
    }

    public CirculinearBoundarySet2D(T[] curves) {
        this.curves = new ArrayList(curves.length);
        for (T element : curves) {
            this.addCurve(element);
        }
    }

    public CirculinearBoundarySet2D(T curve) {
        this.curves = new ArrayList();
        this.curves.add(curve);
    }

    public CirculinearBoundarySet2D(Collection<? extends T> curves) {
        this.curves = new ArrayList(curves.size());
        this.curves.addAll(curves);
    }

    @Override
    public double getLength() {
        double sum = 0.0;
        for (CirculinearContour2D curve : this.getCurves()) {
            sum += curve.getLength();
        }
        return sum;
    }

    @Override
    public double getLength(double pos) {
        return CirculinearCurve2DUtils.getLength(this, pos);
    }

    @Override
    public double getPosition(double length) {
        return CirculinearCurve2DUtils.getPosition(this, length);
    }

    @Override
    public CirculinearDomain2D getBuffer(double dist) {
        return CirculinearCurve2DUtils.computeBuffer(this, dist);
    }

    @Override
    public CirculinearCurve2D getParallel(double d) {
        return CirculinearCurve2DUtils.createParallel(this, d);
    }

    @Override
    public CirculinearBoundarySet2D<? extends CirculinearContour2D> transform(CircleInversion2D inv) {
        CirculinearBoundarySet2D<CirculinearContour2D> result = new CirculinearBoundarySet2D<CirculinearContour2D>(this.curves.size());
        for (CirculinearContour2D curve : this.curves) {
            result.addCurve(curve.transform(inv));
        }
        return result;
    }

    @Override
    public Collection<? extends CirculinearContour2D> getContinuousCurves() {
        ArrayList result = new ArrayList();
        result.addAll(this.curves);
        return result;
    }

    @Override
    public CirculinearCurveSet2D<? extends CirculinearContinuousCurve2D> clip(Box2D box) {
        CurveSet2D<? extends Curve2D> set = Curve2DUtils.clipCurve(this, box);
        int n = set.getCurveNumber();
        CirculinearCurveSet2D<CirculinearContinuousCurve2D> result = new CirculinearCurveSet2D<CirculinearContinuousCurve2D>(n);
        for (Curve2D curve2D : set.getCurves()) {
            if (!(curve2D instanceof CirculinearContinuousCurve2D)) continue;
            result.addCurve((CirculinearContinuousCurve2D)curve2D);
        }
        return result;
    }

    @Override
    public CirculinearBoundarySet2D<? extends CirculinearContour2D> getReverseCurve() {
        int n = this.curves.size();
        CirculinearContour2D[] curves2 = new CirculinearContour2D[n];
        for (int i = 0; i < n; ++i) {
            curves2[i] = (CirculinearContour2D)((CirculinearContour2D)this.curves.get(n - 1 - i)).getReverseCurve();
        }
        return new CirculinearBoundarySet2D<CirculinearContour2D[]>(curves2);
    }

    @Override
    public CirculinearCurveSet2D<? extends CirculinearContinuousCurve2D> getSubCurve(double t0, double t1) {
        Curve2D curveSet = super.getSubCurve(t0, t1);
        ArrayList<CirculinearContinuousCurve2D> curves = new ArrayList<CirculinearContinuousCurve2D>(((CurveSet2D)curveSet).getCurveNumber());
        for (ContinuousOrientedCurve2D curve : ((CurveSet2D)curveSet).getCurves()) {
            curves.add((CirculinearContinuousCurve2D)curve);
        }
        return new CirculinearCurveSet2D(curves);
    }
}

