/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text.regex;

import java.util.Stack;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.OpCode;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5MatchResult;
import org.apache.oro.text.regex.Perl5Pattern;
import org.apache.oro.text.regex.Perl5Repetition;

public final class Perl5Matcher
implements PatternMatcher {
    private static final char __EOS = '\uffff';
    private static final int __INITIAL_NUM_OFFSETS = 20;
    private static final int __DEFAULT_LAST_MATCH_END_OFFSET = -100;
    private boolean __multiline = false;
    private boolean __lastSuccess = false;
    private char __previousChar;
    private char[] __input;
    private char[] __originalInput;
    private Perl5Repetition __currentRep;
    private int __numParentheses;
    private int __bol;
    private int __eol;
    private int __currentOffset;
    private int __endOffset;
    private char[] __program;
    private int __expSize;
    private int __inputOffset;
    private int __lastParen;
    private int[] __beginMatchOffsets;
    private int[] __endMatchOffsets;
    private Stack __stack = new Stack();
    private Perl5MatchResult __lastMatchResult = null;
    private int __lastMatchInputEndOffset = -100;

    private static final boolean __compare(char[] s1, int s1Offs, char[] s2, int s2Offs, int n) {
        int cnt = 0;
        while (cnt < n) {
            if (s1Offs >= s1.length) {
                return false;
            }
            if (s2Offs >= s2.length) {
                return false;
            }
            if (s1[s1Offs] != s2[s2Offs]) {
                return false;
            }
            ++cnt;
            ++s1Offs;
            ++s2Offs;
        }
        return true;
    }

    private static final int __findFirst(char[] input, int current, int endOffset, char[] mustString) {
        if (input.length == 0) {
            return endOffset;
        }
        char ch = mustString[0];
        while (current < endOffset) {
            if (ch == input[current]) {
                int saveCurrent = current;
                int count = 0;
                while (current < endOffset && count < mustString.length) {
                    if (mustString[count] != input[current]) break;
                    ++count;
                    ++current;
                }
                current = saveCurrent;
                if (count >= mustString.length) break;
            }
            ++current;
        }
        return current;
    }

    private final void __pushState(int parenFloor) {
        int[] state;
        int stateEntries = 3 * (this.__expSize - parenFloor);
        if (stateEntries <= 0) {
            int[] nArray = new int[3];
        } else {
            state = new int[stateEntries + 3];
        }
        state[0] = this.__expSize;
        state[1] = this.__lastParen;
        state[2] = this.__inputOffset;
        int paren = this.__expSize;
        while (paren > parenFloor) {
            state[stateEntries] = this.__endMatchOffsets[paren];
            state[stateEntries + 1] = this.__beginMatchOffsets[paren];
            state[stateEntries + 2] = paren;
            paren -= 3;
            stateEntries -= 3;
        }
        this.__stack.push(state);
    }

    private final void __popState() {
        int paren;
        int[] state = (int[])this.__stack.pop();
        this.__expSize = state[0];
        this.__lastParen = state[1];
        this.__inputOffset = state[2];
        int entry = 3;
        while (entry < state.length) {
            paren = state[entry + 2];
            this.__beginMatchOffsets[paren] = state[entry + 1];
            if (paren <= this.__lastParen) {
                this.__endMatchOffsets[paren] = state[entry];
            }
            entry += 3;
        }
        paren = this.__lastParen + 1;
        while (paren <= this.__numParentheses) {
            if (paren > this.__expSize) {
                this.__beginMatchOffsets[paren] = -1;
            }
            this.__endMatchOffsets[paren] = -1;
            ++paren;
        }
    }

    private final void __initInterpreterGlobals(Perl5Pattern expression, char[] input, int beginOffset, int endOffset) {
        this.__input = input;
        this.__endOffset = endOffset;
        this.__currentRep = new Perl5Repetition();
        this.__currentRep._numInstances = 0;
        this.__currentRep._lastRepetition = null;
        this.__program = expression._program;
        this.__stack.setSize(0);
        if (beginOffset == 0) {
            this.__previousChar = (char)10;
        } else {
            this.__previousChar = input[beginOffset - 1];
            if (!this.__multiline && this.__previousChar == '\n') {
                this.__previousChar = '\u0000';
            }
        }
        this.__numParentheses = expression._numParentheses;
        this.__currentOffset = beginOffset;
        this.__bol = beginOffset;
        this.__eol = endOffset;
        endOffset = this.__numParentheses + 1;
        if (this.__beginMatchOffsets == null || endOffset > this.__beginMatchOffsets.length) {
            if (endOffset < 20) {
                endOffset = 20;
            }
            this.__beginMatchOffsets = new int[endOffset];
            this.__endMatchOffsets = new int[endOffset];
        }
    }

    private final void __setLastMatchResult() {
        this.__lastMatchResult = new Perl5MatchResult(this.__numParentheses + 1);
        if (this.__endMatchOffsets[0] > this.__originalInput.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.__lastMatchResult._match = new String(this.__originalInput, this.__beginMatchOffsets[0], this.__endMatchOffsets[0] - this.__beginMatchOffsets[0]);
        this.__lastMatchResult._matchBeginOffset = this.__beginMatchOffsets[0];
        while (this.__numParentheses >= 0) {
            int offs = this.__beginMatchOffsets[this.__numParentheses];
            this.__lastMatchResult._beginGroupOffset[this.__numParentheses] = offs >= 0 ? offs - this.__lastMatchResult._matchBeginOffset : -1;
            offs = this.__endMatchOffsets[this.__numParentheses];
            this.__lastMatchResult._endGroupOffset[this.__numParentheses] = offs >= 0 ? offs - this.__lastMatchResult._matchBeginOffset : -1;
            --this.__numParentheses;
        }
        this.__originalInput = null;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean __interpret(Perl5Pattern expression, char[] input, int beginOffset, int endOffset) {
        block75: {
            block80: {
                block79: {
                    block78: {
                        block76: {
                            block77: {
                                minLength = 0;
                                dontTry = 0;
                                this.__initInterpreterGlobals(expression, input, beginOffset, endOffset);
                                success = false;
                                mustString = expression._mustString;
                                if (mustString == null || (expression._anchor & 1) != 0 && (!this.__multiline || expression._back < 0)) break block76;
                                this.__currentOffset = Perl5Matcher.__findFirst(this.__input, this.__currentOffset, endOffset, mustString);
                                if (this.__currentOffset < endOffset) break block77;
                                if ((expression._options & 32768) == 0) {
                                    ++expression._mustUtility;
                                }
                                success = false;
                                break block75;
                            }
                            if (expression._back >= 0) {
                                this.__currentOffset -= expression._back;
                                if (this.__currentOffset < beginOffset) {
                                    this.__currentOffset = beginOffset;
                                }
                                minLength = expression._back + mustString.length;
                            } else if (!expression._isExpensive && (expression._options & 32768) == 0 && --expression._mustUtility < 0) {
                                expression._mustString = null;
                                mustString = null;
                                this.__currentOffset = beginOffset;
                            } else {
                                this.__currentOffset = beginOffset;
                                minLength = mustString.length;
                            }
                        }
                        if ((expression._anchor & 1) == 0) break block78;
                        if (this.__tryExpression(expression, beginOffset)) {
                            success = true;
                        } else if (this.__multiline || (expression._anchor & 4) != 0) {
                            if (minLength > 0) {
                                dontTry = minLength - 1;
                            }
                            endOffset -= dontTry;
                            if (this.__currentOffset > beginOffset) {
                                --this.__currentOffset;
                            }
                            while (this.__currentOffset < endOffset) {
                                if (this.__input[this.__currentOffset++] != '\n' || this.__currentOffset >= endOffset || !this.__tryExpression(expression, this.__currentOffset)) continue;
                                success = true;
                                break block75;
                            }
                        }
                        break block75;
                    }
                    if (expression._startString == null) break block79;
                    mustString = expression._startString;
                    if ((expression._anchor & 2) == 0) ** GOTO lbl65
                    ch = mustString[0];
                    while (this.__currentOffset < endOffset) {
                        if (ch == this.__input[this.__currentOffset]) {
                            if (this.__tryExpression(expression, this.__currentOffset)) {
                                success = true;
                                break block75;
                            }
                            ++this.__currentOffset;
                            while (this.__currentOffset < endOffset && this.__input[this.__currentOffset] == ch) {
                                ++this.__currentOffset;
                            }
                        }
                        ++this.__currentOffset;
                    }
                    break block75;
lbl-1000:
                    // 1 sources

                    {
                        if (this.__tryExpression(expression, this.__currentOffset)) {
                            success = true;
                            break block75;
                        }
                        ++this.__currentOffset;
lbl65:
                        // 2 sources

                        ** while ((this.__currentOffset = Perl5Matcher.__findFirst((char[])this.__input, (int)this.__currentOffset, (int)endOffset, (char[])mustString)) < endOffset)
                    }
lbl66:
                    // 1 sources

                    break block75;
                }
                offset = expression._startClassOffset;
                if (offset == -1) break block80;
                v0 = doEvery = (expression._anchor & 2) == 0;
                if (minLength > 0) {
                    dontTry = minLength - 1;
                }
                endOffset -= dontTry;
                tmp = true;
                switch (this.__program[offset]) {
                    case '\t': {
                        offset = OpCode._getOperand(offset);
                        while (this.__currentOffset < endOffset) {
                            ch = this.__input[this.__currentOffset];
                            if (ch < '\u0100' && (this.__program[offset + (ch >> 4)] & 1 << (ch & 15)) == 0) {
                                if (tmp && this.__tryExpression(expression, this.__currentOffset)) {
                                    success = true;
                                    break block75;
                                }
                                tmp = doEvery;
                            } else {
                                tmp = true;
                            }
                            ++this.__currentOffset;
                        }
                        break block75;
                    }
                    case '\u0014': {
                        if (minLength > 0) {
                            ++dontTry;
                            --endOffset;
                        }
                        if (this.__currentOffset != beginOffset) {
                            ch = this.__input[this.__currentOffset - 1];
                            tmp = OpCode._isWordCharacter(ch);
                        } else {
                            tmp = OpCode._isWordCharacter(this.__previousChar);
                        }
                        while (this.__currentOffset < endOffset) {
                            ch = this.__input[this.__currentOffset];
                            if (tmp != OpCode._isWordCharacter(ch)) {
                                v1 = tmp = tmp == false;
                                if (this.__tryExpression(expression, this.__currentOffset)) {
                                    success = true;
                                    break block75;
                                }
                            }
                            ++this.__currentOffset;
                        }
                        if ((minLength > 0 || tmp) && this.__tryExpression(expression, this.__currentOffset)) {
                            success = true;
                        }
                        break block75;
                    }
                    case '\u0015': {
                        if (minLength > 0) {
                            ++dontTry;
                            --endOffset;
                        }
                        if (this.__currentOffset != beginOffset) {
                            ch = this.__input[this.__currentOffset - 1];
                            tmp = OpCode._isWordCharacter(ch);
                        } else {
                            tmp = OpCode._isWordCharacter(this.__previousChar);
                        }
                        while (this.__currentOffset < endOffset) {
                            ch = this.__input[this.__currentOffset];
                            if (tmp != OpCode._isWordCharacter(ch)) {
                                tmp = tmp == false;
                            } else if (this.__tryExpression(expression, this.__currentOffset)) {
                                success = true;
                                break block75;
                            }
                            ++this.__currentOffset;
                        }
                        if ((minLength > 0 || !tmp) && this.__tryExpression(expression, this.__currentOffset)) {
                            success = true;
                        }
                        break block75;
                    }
                    case '\u0012': {
                        while (this.__currentOffset < endOffset) {
                            ch = this.__input[this.__currentOffset];
                            if (OpCode._isWordCharacter(ch)) {
                                if (tmp && this.__tryExpression(expression, this.__currentOffset)) {
                                    success = true;
                                    break block75;
                                }
                                tmp = doEvery;
                            } else {
                                tmp = true;
                            }
                            ++this.__currentOffset;
                        }
                        break block75;
                    }
                    case '\u0013': {
                        while (this.__currentOffset < endOffset) {
                            ch = this.__input[this.__currentOffset];
                            if (!OpCode._isWordCharacter(ch)) {
                                if (tmp && this.__tryExpression(expression, this.__currentOffset)) {
                                    success = true;
                                    break block75;
                                }
                                tmp = doEvery;
                            } else {
                                tmp = true;
                            }
                            ++this.__currentOffset;
                        }
                        break block75;
                    }
                    case '\u0016': {
                        while (this.__currentOffset < endOffset) {
                            if (Character.isWhitespace(this.__input[this.__currentOffset])) {
                                if (tmp && this.__tryExpression(expression, this.__currentOffset)) {
                                    success = true;
                                    break block75;
                                }
                                tmp = doEvery;
                            } else {
                                tmp = true;
                            }
                            ++this.__currentOffset;
                        }
                        break block75;
                    }
                    case '\u0017': {
                        while (this.__currentOffset < endOffset) {
                            if (!Character.isWhitespace(this.__input[this.__currentOffset])) {
                                if (tmp && this.__tryExpression(expression, this.__currentOffset)) {
                                    success = true;
                                    break block75;
                                }
                                tmp = doEvery;
                            } else {
                                tmp = true;
                            }
                            ++this.__currentOffset;
                        }
                        break block75;
                    }
                    case '\u0018': {
                        while (this.__currentOffset < endOffset) {
                            if (Character.isDigit(this.__input[this.__currentOffset])) {
                                if (tmp && this.__tryExpression(expression, this.__currentOffset)) {
                                    success = true;
                                    break block75;
                                }
                                tmp = doEvery;
                            } else {
                                tmp = true;
                            }
                            ++this.__currentOffset;
                        }
                        break block75;
                    }
                    case '\u0019': {
                        while (this.__currentOffset < endOffset) {
                            if (!Character.isDigit(this.__input[this.__currentOffset])) {
                                if (tmp && this.__tryExpression(expression, this.__currentOffset)) {
                                    success = true;
                                    break block75;
                                }
                                tmp = doEvery;
                            } else {
                                tmp = true;
                            }
                            ++this.__currentOffset;
                        }
                        break block75;
                    }
                }
                break block75;
            }
            if (minLength > 0) {
                dontTry = minLength - 1;
            }
            endOffset -= dontTry;
            do {
                if (!this.__tryExpression(expression, this.__currentOffset)) continue;
                success = true;
                break;
            } while (this.__currentOffset++ < endOffset);
        }
        this.__lastSuccess = success;
        this.__lastMatchResult = null;
        return success;
    }

    private final boolean __tryExpression(Perl5Pattern expression, int offset) {
        this.__inputOffset = offset;
        this.__lastParen = 0;
        this.__expSize = 0;
        if (this.__numParentheses > 0) {
            int count = 0;
            while (count <= this.__numParentheses) {
                this.__beginMatchOffsets[count] = -1;
                this.__endMatchOffsets[count] = -1;
                ++count;
            }
        }
        if (this.__match(1)) {
            this.__beginMatchOffsets[0] = offset;
            this.__endMatchOffsets[0] = this.__inputOffset;
            return true;
        }
        return false;
    }

    private final int __repeat(int offset, int max) {
        int scan = this.__inputOffset;
        int eol = this.__eol;
        if (max != 65535 && max < eol - scan) {
            eol = scan + max;
        }
        int operand = OpCode._getOperand(offset);
        block0 : switch (this.__program[offset]) {
            case '\u0007': {
                while (scan < eol && this.__input[scan] != '\n') {
                    ++scan;
                }
                break;
            }
            case '\b': {
                scan = eol;
                break;
            }
            case '\u000e': {
                ++operand;
                while (scan < eol && this.__program[operand] == this.__input[scan]) {
                    ++scan;
                }
                break;
            }
            case '\t': {
                char ch;
                if (scan >= eol || (ch = this.__input[scan]) >= '\u0100') break;
                while ((this.__program[operand + (ch >> 4)] & 1 << (ch & 0xF)) == 0) {
                    if (++scan >= eol) break block0;
                    ch = this.__input[scan];
                }
                break;
            }
            case '\u0012': {
                while (scan < eol && OpCode._isWordCharacter(this.__input[scan])) {
                    ++scan;
                }
                break;
            }
            case '\u0013': {
                while (scan < eol && !OpCode._isWordCharacter(this.__input[scan])) {
                    ++scan;
                }
                break;
            }
            case '\u0016': {
                while (scan < eol && Character.isWhitespace(this.__input[scan])) {
                    ++scan;
                }
                break;
            }
            case '\u0017': {
                while (scan < eol && !Character.isWhitespace(this.__input[scan])) {
                    ++scan;
                }
                break;
            }
            case '\u0018': {
                while (scan < eol && Character.isDigit(this.__input[scan])) {
                    ++scan;
                }
                break;
            }
            case '\u0019': {
                while (scan < eol && !Character.isDigit(this.__input[scan])) {
                    ++scan;
                }
                break;
            }
        }
        int ret = scan - this.__inputOffset;
        this.__inputOffset = scan;
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean __match(int offset) {
        inputRemains = true;
        minMod = false;
        input = this.__inputOffset;
        inputRemains = input < this.__endOffset;
        nextChar = inputRemains != false ? this.__input[input] : '\uffff';
        scan = offset;
        maxScan = this.__program.length;
        while (scan < maxScan) {
            next = OpCode._getNext(this.__program, scan);
            var3_8 = this.__program[scan];
            switch (var3_8) {
                case '\u0001': {
                    if (input == this.__bol ? this.__previousChar == '\n' : this.__multiline != false && (inputRemains != false || input < this.__eol) && this.__input[input - 1] == '\n') break;
                    return false;
                }
                case '\u0002': {
                    if (input == this.__bol ? this.__previousChar == '\n' : (inputRemains != false || input < this.__eol) && this.__input[input - 1] == '\n') break;
                    return false;
                }
                case '\u0003': {
                    if (input == this.__bol && this.__previousChar == '\n') break;
                    return false;
                }
                case '\u001e': {
                    if (input == this.__bol) break;
                    return true;
                }
                case '\u0004': {
                    if ((inputRemains || input < this.__eol) && nextChar != '\n') {
                        return false;
                    }
                    if (this.__multiline || this.__eol - input <= 1) break;
                    return false;
                }
                case '\u0005': {
                    if (!inputRemains && input >= this.__eol || nextChar == 10) break;
                    return false;
                }
                case '\u0006': {
                    if ((inputRemains || input < this.__eol) && nextChar != '\n') {
                        return false;
                    }
                    if (this.__eol - input <= 1) break;
                    return false;
                }
                case '\b': {
                    if (!inputRemains && input >= this.__eol) {
                        return false;
                    }
                    inputRemains = ++input < this.__endOffset;
                    nextChar = inputRemains != false ? this.__input[input] : '\uffff';
                    break;
                }
                case '\u0007': {
                    if (!inputRemains && input >= this.__eol || nextChar == '\n') {
                        return false;
                    }
                    inputRemains = ++input < this.__endOffset;
                    nextChar = inputRemains != false ? this.__input[input] : '\uffff';
                    break;
                }
                case '\u000e': {
                    current = OpCode._getOperand(scan);
                    line = this.__program[current++];
                    if (this.__program[current] != nextChar) {
                        return false;
                    }
                    if (this.__eol - input < line) {
                        return false;
                    }
                    if (line > 1 && !Perl5Matcher.__compare(this.__program, current, this.__input, input, line)) {
                        return false;
                    }
                    inputRemains = (input += line) < this.__endOffset;
                    nextChar = inputRemains != false ? this.__input[input] : '\uffff';
                    break;
                }
                case '\t': {
                    current = OpCode._getOperand(scan);
                    if (nextChar == '\uffff' && inputRemains) {
                        nextChar = this.__input[input];
                    }
                    if (nextChar >= '\u0100' || (this.__program[current + (nextChar >> 4)] & 1 << (nextChar & 15)) != 0) {
                        return false;
                    }
                    if (!inputRemains && input >= this.__eol) {
                        return false;
                    }
                    inputRemains = ++input < this.__endOffset;
                    nextChar = inputRemains != false ? this.__input[input] : '\uffff';
                    break;
                }
                case '\u0012': {
                    if (!inputRemains) {
                        return false;
                    }
                    if (!OpCode._isWordCharacter(nextChar)) {
                        return false;
                    }
                    inputRemains = ++input < this.__endOffset;
                    nextChar = inputRemains != false ? this.__input[input] : '\uffff';
                    break;
                }
                case '\u0013': {
                    if (!inputRemains && input >= this.__eol) {
                        return false;
                    }
                    if (OpCode._isWordCharacter(nextChar)) {
                        return false;
                    }
                    inputRemains = ++input < this.__endOffset;
                    nextChar = inputRemains != false ? this.__input[input] : '\uffff';
                    break;
                }
                case '\u0014': 
                case '\u0015': {
                    if (input == this.__bol) {
                        var14_13 = OpCode._isWordCharacter(this.__previousChar);
                    } else {
                        a = OpCode._isWordCharacter(this.__input[input - 1]);
                    }
                    b = OpCode._isWordCharacter(nextChar);
                    if (a == b != (this.__program[scan] == '\u0014')) break;
                    return false;
                }
                case '\u0016': {
                    if (!inputRemains && input >= this.__eol) {
                        return false;
                    }
                    if (!Character.isWhitespace(nextChar)) {
                        return false;
                    }
                    inputRemains = ++input < this.__endOffset;
                    nextChar = inputRemains != false ? this.__input[input] : '\uffff';
                    break;
                }
                case '\u0017': {
                    if (!inputRemains) {
                        return false;
                    }
                    if (Character.isWhitespace(nextChar)) {
                        return false;
                    }
                    inputRemains = ++input < this.__endOffset;
                    nextChar = inputRemains != false ? this.__input[input] : '\uffff';
                    break;
                }
                case '\u0018': {
                    if (!Character.isDigit(nextChar)) {
                        return false;
                    }
                    inputRemains = ++input < this.__endOffset;
                    nextChar = inputRemains != false ? this.__input[input] : '\uffff';
                    break;
                }
                case '\u0019': {
                    if (!inputRemains && input >= this.__eol) {
                        return false;
                    }
                    if (Character.isDigit(nextChar)) {
                        return false;
                    }
                    inputRemains = ++input < this.__endOffset;
                    nextChar = inputRemains != false ? this.__input[input] : '\uffff';
                    break;
                }
                case '\u001a': {
                    arg = OpCode._getArg1(this.__program, scan);
                    current = this.__beginMatchOffsets[arg];
                    if (current == -1) {
                        return false;
                    }
                    if (this.__endMatchOffsets[arg] == -1) {
                        return false;
                    }
                    if (current == this.__endMatchOffsets[arg]) break;
                    if (this.__input[current] != nextChar) {
                        return false;
                    }
                    line = this.__endMatchOffsets[arg] - current;
                    if (input + line > this.__eol) {
                        return false;
                    }
                    if (line > 1 && !Perl5Matcher.__compare(this.__input, current, this.__input, input, line)) {
                        return false;
                    }
                    inputRemains = (input += line) < this.__endOffset;
                    nextChar = inputRemains != false ? this.__input[input] : '\uffff';
                    break;
                }
                case '\u000f': {
                    break;
                }
                case '\r': {
                    break;
                }
                case '\u001b': {
                    arg = OpCode._getArg1(this.__program, scan);
                    this.__beginMatchOffsets[arg] = input;
                    if (arg <= this.__expSize) break;
                    this.__expSize = arg;
                    break;
                }
                case '\u001c': {
                    arg = OpCode._getArg1(this.__program, scan);
                    this.__endMatchOffsets[arg] = input;
                    if (arg <= this.__lastParen) break;
                    this.__lastParen = arg;
                    break;
                }
                case '\u000b': {
                    rep = new Perl5Repetition();
                    rep._lastRepetition = this.__currentRep;
                    this.__currentRep = rep;
                    rep._parenFloor = this.__lastParen;
                    rep._numInstances = -1;
                    rep._min = OpCode._getArg1(this.__program, scan);
                    rep._max = OpCode._getArg2(this.__program, scan);
                    rep._scan = OpCode._getNextOperator(scan) + 2;
                    rep._next = next;
                    rep._minMod = minMod;
                    rep._lastLocation = -1;
                    this.__inputOffset = input;
                    minMod = this.__match(OpCode._getPrevOperator(next));
                    this.__currentRep = rep._lastRepetition;
                    return minMod;
                }
                case '\"': {
                    rep = this.__currentRep;
                    arg = rep._numInstances + 1;
                    this.__inputOffset = input;
                    if (input == rep._lastLocation) {
                        this.__currentRep = rep._lastRepetition;
                        line = this.__currentRep._numInstances;
                        if (this.__match(rep._next)) {
                            return true;
                        }
                        this.__currentRep._numInstances = line;
                        this.__currentRep = rep;
                        return false;
                    }
                    if (arg < rep._min) {
                        rep._numInstances = arg;
                        rep._lastLocation = input;
                        if (this.__match(rep._scan)) {
                            return true;
                        }
                        rep._numInstances = arg - 1;
                        return false;
                    }
                    if (rep._minMod) {
                        this.__currentRep = rep._lastRepetition;
                        line = this.__currentRep._numInstances;
                        if (this.__match(rep._next)) {
                            return true;
                        }
                        this.__currentRep._numInstances = line;
                        this.__currentRep = rep;
                        if (arg >= rep._max) {
                            return false;
                        }
                        this.__inputOffset = input;
                        rep._numInstances = arg;
                        rep._lastLocation = input;
                        if (this.__match(rep._scan)) {
                            return true;
                        }
                        rep._numInstances = arg - 1;
                        return false;
                    }
                    if (arg < rep._max) {
                        this.__pushState(rep._parenFloor);
                        rep._numInstances = arg;
                        rep._lastLocation = input;
                        if (this.__match(rep._scan)) {
                            return true;
                        }
                        this.__popState();
                        this.__inputOffset = input;
                    }
                    this.__currentRep = rep._lastRepetition;
                    line = this.__currentRep._numInstances;
                    if (this.__match(rep._next)) {
                        return true;
                    }
                    rep._numInstances = line;
                    this.__currentRep = rep;
                    rep._numInstances = arg - 1;
                    return false;
                }
                case '\f': {
                    if (this.__program[next] != '\f') {
                        next = OpCode._getNextOperator(scan);
                        break;
                    }
                    lastParen = this.__lastParen;
                    do {
                        this.__inputOffset = input;
                        if (this.__match(OpCode._getNextOperator(scan))) {
                            return true;
                        }
                        arg = this.__lastParen;
                        while (arg > lastParen) {
                            this.__endMatchOffsets[arg] = -1;
                            --arg;
                        }
                        this.__lastParen = arg;
                    } while ((scan = OpCode._getNext(this.__program, scan)) != -1 && this.__program[scan] == '\f');
                    return false;
                }
                case '\u001d': {
                    minMod = true;
                    break;
                }
                case '\n': 
                case '\u0010': 
                case '\u0011': {
                    if (op == 10) {
                        line = OpCode._getArg1(this.__program, scan);
                        arg = OpCode._getArg2(this.__program, scan);
                        scan = OpCode._getNextOperator(scan) + 2;
                    } else if (op == 16) {
                        line = 0;
                        arg = 65535;
                        scan = OpCode._getNextOperator(scan);
                    } else {
                        line = 1;
                        arg = 65535;
                        scan = OpCode._getNextOperator(scan);
                    }
                    if (this.__program[next] == '\u000e') {
                        nextChar = this.__program[OpCode._getOperand(next) + 1];
                        current = 0;
                    } else {
                        nextChar = '\uffff';
                        current = -1000;
                    }
                    this.__inputOffset = input;
                    if (!minMod) ** GOTO lbl281
                    minMod = false;
                    if (line <= 0 || this.__repeat(scan, line) >= line) ** GOTO lbl279
                    return false;
lbl-1000:
                    // 1 sources

                    {
                        if ((current == -1000 || this.__inputOffset >= this.__endOffset || this.__input[this.__inputOffset] == nextChar) && this.__match(next)) {
                            return true;
                        }
                        this.__inputOffset = input + line;
                        if (this.__repeat(scan, 1) != 0) {
                            this.__inputOffset = input + ++line;
                            continue;
                        }
                        return false;
lbl279:
                        // 2 sources

                        ** while (arg >= line || arg == 65535 && line > 0)
                    }
lbl280:
                    // 1 sources

                    ** GOTO lbl288
lbl281:
                    // 1 sources

                    if (!(line >= (arg = this.__repeat(scan, arg)) || OpCode._opType[this.__program[next]] != '\u0004' || this.__multiline && this.__program[next] != '\u0006')) {
                        line = arg;
                    }
                    while (arg >= line) {
                        if ((current == -1000 || this.__inputOffset >= this.__endOffset || this.__input[this.__inputOffset] == nextChar) && this.__match(next)) {
                            return true;
                        }
                        this.__inputOffset = input + --arg;
                    }
lbl288:
                    // 2 sources

                    return false;
                }
                case '\u0000': 
                case '!': {
                    this.__inputOffset = input;
                    return this.__inputOffset != this.__lastMatchInputEndOffset;
                }
                case '\u001f': {
                    this.__inputOffset = input;
                    scan = OpCode._getNextOperator(scan);
                    if (this.__match(scan)) break;
                    return false;
                }
                case ' ': {
                    this.__inputOffset = input;
                    scan = OpCode._getNextOperator(scan);
                    if (!this.__match(scan)) break;
                    return false;
                }
            }
            scan = next;
        }
        return false;
    }

    public final void setMultiline(boolean multiline) {
        this.__multiline = multiline;
    }

    public final boolean isMultiline() {
        return this.__multiline;
    }

    final char[] _toLower(char[] input) {
        char[] inp = new char[input.length];
        System.arraycopy(input, 0, inp, 0, input.length);
        input = inp;
        int current = 0;
        while (current < input.length) {
            if (Character.isUpperCase(input[current])) {
                input[current] = Character.toLowerCase(input[current]);
            }
            ++current;
        }
        return input;
    }

    public final boolean matchesPrefix(char[] input, Pattern pattern, int offset) {
        Perl5Pattern expression = (Perl5Pattern)pattern;
        this.__originalInput = input;
        if (expression._isCaseInsensitive) {
            input = this._toLower(input);
        }
        this.__initInterpreterGlobals(expression, input, offset, input.length);
        this.__lastSuccess = this.__tryExpression(expression, offset);
        this.__lastMatchResult = null;
        return this.__lastSuccess;
    }

    public final boolean matchesPrefix(char[] input, Pattern pattern) {
        return this.matchesPrefix(input, pattern, 0);
    }

    public final boolean matchesPrefix(String input, Pattern pattern) {
        return this.matchesPrefix(input.toCharArray(), pattern, 0);
    }

    public final boolean matchesPrefix(PatternMatcherInput input, Pattern pattern) {
        char[] inp;
        Perl5Pattern expression = (Perl5Pattern)pattern;
        this.__originalInput = input._originalBuffer;
        if (expression._isCaseInsensitive) {
            if (input._toLowerBuffer == null) {
                input._toLowerBuffer = this._toLower(this.__originalInput);
            }
            char[] cArray = input._toLowerBuffer;
        } else {
            inp = this.__originalInput;
        }
        this.__initInterpreterGlobals(expression, inp, input._currentOffset, input._endOffset);
        this.__lastSuccess = this.__tryExpression(expression, input._currentOffset);
        this.__lastMatchResult = null;
        return this.__lastSuccess;
    }

    public final boolean matches(char[] input, Pattern pattern) {
        Perl5Pattern expression = (Perl5Pattern)pattern;
        this.__originalInput = input;
        if (expression._isCaseInsensitive) {
            input = this._toLower(input);
        }
        this.__initInterpreterGlobals(expression, input, 0, input.length);
        this.__lastSuccess = this.__tryExpression(expression, 0) && this.__endMatchOffsets[0] == input.length;
        this.__lastMatchResult = null;
        return this.__lastSuccess;
    }

    public final boolean matches(String input, Pattern pattern) {
        return this.matches(input.toCharArray(), pattern);
    }

    public final boolean matches(PatternMatcherInput input, Pattern pattern) {
        char[] inp;
        Perl5Pattern expression = (Perl5Pattern)pattern;
        this.__originalInput = input._originalBuffer;
        if (expression._isCaseInsensitive) {
            if (input._toLowerBuffer == null) {
                input._toLowerBuffer = this._toLower(this.__originalInput);
            }
            char[] cArray = input._toLowerBuffer;
        } else {
            inp = this.__originalInput;
        }
        this.__initInterpreterGlobals(expression, inp, input._beginOffset, input._endOffset);
        this.__lastMatchResult = null;
        if (this.__tryExpression(expression, input._beginOffset) && (this.__endMatchOffsets[0] == input._endOffset || input.length() == 0 || input._beginOffset == input._endOffset)) {
            this.__lastSuccess = true;
            return true;
        }
        this.__lastSuccess = false;
        return false;
    }

    public final boolean contains(String input, Pattern pattern) {
        return this.contains(input.toCharArray(), pattern);
    }

    public final boolean contains(char[] input, Pattern pattern) {
        Perl5Pattern expression = (Perl5Pattern)pattern;
        this.__originalInput = input;
        if (expression._isCaseInsensitive) {
            input = this._toLower(input);
        }
        return this.__interpret(expression, input, 0, input.length);
    }

    public final boolean contains(PatternMatcherInput input, Pattern pattern) {
        char[] inp;
        if (input._currentOffset > input._endOffset) {
            return false;
        }
        Perl5Pattern expression = (Perl5Pattern)pattern;
        this.__originalInput = input._originalBuffer;
        this.__originalInput = input._originalBuffer;
        if (expression._isCaseInsensitive) {
            if (input._toLowerBuffer == null) {
                input._toLowerBuffer = this._toLower(this.__originalInput);
            }
            char[] cArray = input._toLowerBuffer;
        } else {
            inp = this.__originalInput;
        }
        this.__lastMatchInputEndOffset = input.getMatchEndOffset();
        boolean matchFound = this.__interpret(expression, inp, input._currentOffset, input._endOffset);
        if (matchFound) {
            input.setCurrentOffset(this.__endMatchOffsets[0]);
            input.setMatchOffsets(this.__beginMatchOffsets[0], this.__endMatchOffsets[0]);
        } else {
            input.setCurrentOffset(input._endOffset + 1);
        }
        this.__lastMatchInputEndOffset = -100;
        return matchFound;
    }

    public final MatchResult getMatch() {
        if (!this.__lastSuccess) {
            return null;
        }
        if (this.__lastMatchResult == null) {
            this.__setLastMatchResult();
        }
        return this.__lastMatchResult;
    }
}

