/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.multi.communication.worldview.property;

import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.multi.agent.ITeamId;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ISharedPropertyUpdateResult;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ISharedPropertyUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.PropertyId;
import cz.cuni.amis.utils.HashCode;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.SafeEquals;
import cz.cuni.amis.utils.exception.PogamutException;

public abstract class AbstractSharedProperty<TYPE>
implements ISharedProperty<TYPE> {
    protected PropertyId propertyId = null;
    protected boolean dirty = false;
    protected Class<?> compositeClass = null;
    protected TYPE value;
    private int hashCode;

    @Override
    public boolean nullOverrides() {
        return false;
    }

    protected abstract TYPE cloneValue();

    public AbstractSharedProperty(WorldObjectId objId, String identifier, TYPE value, Class<?> compositeClass) {
        this.propertyId = PropertyId.get(objId, identifier);
        this.compositeClass = compositeClass;
        this.value = value;
        HashCode hc = new HashCode();
        hc.add((Object)this.propertyId);
        this.hashCode = hc.getHash();
    }

    public AbstractSharedProperty(AbstractSharedProperty source) {
        this.hashCode = source.hashCode;
        this.propertyId = source.propertyId;
        this.dirty = source.dirty;
        this.compositeClass = source.compositeClass;
        this.value = source.cloneValue();
    }

    public AbstractSharedProperty(WorldObjectId objectId, String identifier, Class compositeClass) {
        this(objectId, identifier, null, compositeClass);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object another) {
        if (another == null) {
            return false;
        }
        if (!(another instanceof ISharedProperty)) {
            return false;
        }
        ISharedProperty other = (ISharedProperty)another;
        if (!this.getPropertyValueClass().isAssignableFrom(other.getPropertyValueClass())) {
            return false;
        }
        return this.isDirty() == other.isDirty() && SafeEquals.equals(this.getValue(), other.getValue()) && this.getPropertyId().equals(other.getPropertyId());
    }

    @Override
    public abstract ISharedProperty<TYPE> clone();

    @Override
    public TYPE getValue() {
        return this.value;
    }

    @Override
    public void setValue(TYPE value) {
        this.value = value;
    }

    @Override
    public Class getCompositeClass() {
        return this.compositeClass;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean value) {
        this.dirty = value;
    }

    @Override
    public WorldObjectId getObjectId() {
        return this.propertyId.getWorldObjectId();
    }

    @Override
    public PropertyId getPropertyId() {
        return this.propertyId;
    }

    @Override
    public ISharedPropertyUpdatedEvent createUpdateEvent(long time, ITeamId teamId) {
        return new GenericPropertyUpdate(this, time, teamId);
    }

    public static class GenericPropertyUpdate
    implements ISharedPropertyUpdatedEvent {
        private ISharedProperty data;
        private long time;
        private ITeamId teamId;

        public GenericPropertyUpdate(ISharedProperty data, long time, ITeamId teamId) {
            this.data = data;
            NullCheck.check((Object)this.data, (String)"data");
            this.time = time;
            this.teamId = teamId;
        }

        @Override
        public long getSimTime() {
            return this.time;
        }

        @Override
        public WorldObjectId getObjectId() {
            return this.data.getObjectId();
        }

        @Override
        public PropertyId getPropertyId() {
            return this.data.getPropertyId();
        }

        @Override
        public ITeamId getTeamId() {
            return this.teamId;
        }

        @Override
        public ISharedPropertyUpdateResult update(ISharedProperty property) {
            if (property == null) {
                this.data = this.data.clone();
                return new ISharedPropertyUpdateResult.SharedPropertyUpdateResult(ISharedPropertyUpdateResult.Result.CREATED, this.data);
            }
            if (!this.data.getPropertyValueClass().isAssignableFrom(property.getPropertyValueClass())) {
                throw new PogamutException("Unexpected object type provided for update, expected value class " + this.data.getPropertyValueClass() + " got data with value class " + property.getPropertyValueClass(), (Object)this);
            }
            ISharedProperty original = property;
            boolean updated = false;
            if (!SafeEquals.equals(original.getValue(), this.data.getValue()) && this.data.getValue() != null) {
                original.setValue(this.data.getValue());
            }
            this.data = original;
            if (updated) {
                return new ISharedPropertyUpdateResult.SharedPropertyUpdateResult(ISharedPropertyUpdateResult.Result.UPDATED, original);
            }
            return new ISharedPropertyUpdateResult.SharedPropertyUpdateResult(ISharedPropertyUpdateResult.Result.SAME, original);
        }
    }
}

