/*
 * Decompiled with CFR 0.152.
 */
package eis.iilang;

import eis.iilang.IILObjectVisitor;
import eis.iilang.IILVisitor;
import eis.iilang.Parameter;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class ParameterList
extends Parameter
implements Iterable<Parameter> {
    private static final long serialVersionUID = 5330751271570276475L;
    private LinkedList<Parameter> list = new LinkedList();

    public ParameterList() {
    }

    public ParameterList(Parameter ... parameters) {
        this();
        Parameter[] parameterArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter param = parameterArray[n2];
            this.list.addLast(param);
            ++n2;
        }
    }

    public ParameterList(Collection<Parameter> parameters) {
        this();
        for (Parameter param : parameters) {
            this.list.addLast(param);
        }
    }

    @Override
    public Iterator<Parameter> iterator() {
        return this.list.iterator();
    }

    public int indexOf(Parameter p) {
        return this.list.indexOf(p);
    }

    public int size() {
        return this.list.size();
    }

    public Parameter get(int i) {
        return this.list.get(i);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    protected String toXML(int depth) {
        String xml = "";
        xml = String.valueOf(xml) + this.indent(depth) + "<parameterList>" + "\n";
        for (Parameter p : this.list) {
            xml = String.valueOf(xml) + p.toXML(depth + 1);
        }
        xml = String.valueOf(xml) + this.indent(depth) + "</parameterList>" + "\n";
        return xml;
    }

    public void add(Parameter parameter) {
        this.list.add(parameter);
    }

    @Override
    public String toProlog() {
        String ret = "";
        ret = String.valueOf(ret) + "[";
        if (!this.list.isEmpty()) {
            ret = String.valueOf(ret) + this.list.getFirst().toProlog();
            int a = 1;
            while (a < this.list.size()) {
                ret = String.valueOf(ret) + "," + this.list.get(a).toProlog();
                ++a;
            }
        }
        ret = String.valueOf(ret) + "]";
        return ret;
    }

    @Override
    public Object clone() {
        ParameterList ret = new ParameterList();
        for (Parameter p : this.list) {
            ret.add((Parameter)p.clone());
        }
        return ret;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.list == null ? 0 : this.list.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ParameterList)) {
            return false;
        }
        ParameterList other = (ParameterList)obj;
        return !(this.list == null ? other.list != null : !this.list.equals(other.list));
    }

    @Override
    public Object accept(IILObjectVisitor visitor, Object object) {
        return visitor.visit(this, object);
    }

    @Override
    public void accept(IILVisitor visitor) {
        visitor.visit(this);
    }
}

