/*
 * Decompiled with CFR 0.152.
 */
package eis.eis2java.handlers;

import eis.eis2java.annotation.AsPercept;
import eis.eis2java.exception.TranslationException;
import eis.eis2java.handlers.PerceptHandler;
import eis.eis2java.translation.Filter;
import eis.eis2java.translation.Translator;
import eis.exceptions.PerceiveException;
import eis.iilang.Function;
import eis.iilang.Parameter;
import eis.iilang.ParameterList;
import eis.iilang.Percept;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class AbstractPerceptHandler
extends PerceptHandler {
    protected final Object entity;
    protected final Map<Method, List<Object>> previousPercepts = new HashMap<Method, List<Object>>();

    public AbstractPerceptHandler(Object entity) {
        assert (entity != null);
        this.entity = entity;
    }

    protected final List<Percept> translatePercepts(Method method, List<Object> perceptObjects) throws PerceiveException {
        Parameter[] parameters;
        List<Object> addList = new ArrayList<Object>();
        ArrayList<Object> delList = new ArrayList<Object>();
        AsPercept annotation = method.getAnnotation(AsPercept.class);
        Filter.Type filter = annotation.filter();
        String perceptName = annotation.name();
        List<Object> previous = this.previousPercepts.get(method);
        if (filter == Filter.Type.ONCE && previous != null) {
            return new ArrayList<Percept>();
        }
        if (previous == null) {
            previous = new LinkedList<Object>();
            this.previousPercepts.put(method, previous);
        }
        switch (filter) {
            case ALWAYS: 
            case ONCE: {
                addList = perceptObjects;
                break;
            }
            case ON_CHANGE: {
                if (perceptObjects.equals(previous)) break;
                addList = perceptObjects;
                break;
            }
            case ON_CHANGE_NEG: {
                addList.addAll(perceptObjects);
                addList.removeAll(previous);
                delList.addAll(previous);
                delList.removeAll(perceptObjects);
            }
        }
        ArrayList<Percept> percepts = new ArrayList<Percept>();
        for (Object javaObject : addList) {
            try {
                parameters = Translator.getInstance().translate2Parameter(javaObject);
                if (annotation.multipleArguments()) {
                    parameters = this.extractMultipleParameters(parameters);
                }
            }
            catch (TranslationException e) {
                throw new PerceiveException("Unable to translate percept " + perceptName, e);
            }
            percepts.add(new Percept(perceptName, parameters));
        }
        for (Object javaObject : delList) {
            try {
                parameters = Translator.getInstance().translate2Parameter(javaObject);
                if (annotation.multipleArguments()) {
                    parameters = this.extractMultipleParameters(parameters);
                }
            }
            catch (TranslationException e) {
                throw new PerceiveException("Unable to translate percept " + perceptName, e);
            }
            percepts.add(new Percept("not", new Function(perceptName, parameters)));
        }
        this.previousPercepts.put(method, perceptObjects);
        return percepts;
    }

    private Parameter[] extractMultipleParameters(Parameter[] parameters) throws PerceiveException {
        if (parameters.length == 1 && parameters[0] instanceof ParameterList) {
            ParameterList params = (ParameterList)parameters[0];
            parameters = new Parameter[params.size()];
            int i = 0;
            while (i < params.size()) {
                parameters[i] = params.get(i);
                ++i;
            }
        } else {
            throw new PerceiveException("multipleArguments parameter is set and therefore expecting a set but got " + parameters);
        }
        return parameters;
    }

    protected final List<Object> unpackPerceptObject(Method method, Object perceptObject) throws PerceiveException {
        AsPercept annotation = method.getAnnotation(AsPercept.class);
        String perceptName = annotation.name();
        if (!annotation.multiplePercepts()) {
            ArrayList<Object> unpacked = new ArrayList<Object>(1);
            if (perceptObject != null) {
                unpacked.add(perceptObject);
            }
            return unpacked;
        }
        if (!(perceptObject instanceof Collection)) {
            throw new PerceiveException("Unable to perceive " + perceptName + " because a collection was expected but a " + perceptObject.getClass() + " was returned instead");
        }
        Collection javaCollection = (Collection)perceptObject;
        ArrayList<Object> unpacked = new ArrayList<Object>(javaCollection);
        return unpacked;
    }
}

