/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.gui.panels;

import cz.cuni.amis.pogamut.unreal.communication.messages.gbinfomessages.IPlayer;
import cz.cuni.amis.pogamut.unreal.communication.worldview.map.IUnrealWaypoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.server.IUT2004Server;
import cz.cuni.amis.utils.collections.ObservableCollection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.JPanel;
import nl.tudelft.goal.ut2004.visualizer.controller.ServerController;
import nl.tudelft.goal.ut2004.visualizer.data.EnvironmentData;
import nl.tudelft.goal.ut2004.visualizer.gui.action.AddInventoryAction;
import nl.tudelft.goal.ut2004.visualizer.gui.action.ChangeTeamAction;
import nl.tudelft.goal.ut2004.visualizer.gui.action.KickAction;
import nl.tudelft.goal.ut2004.visualizer.gui.action.RespawnHereAction;
import nl.tudelft.goal.ut2004.visualizer.gui.action.RespawnRandomAction;
import nl.tudelft.goal.ut2004.visualizer.gui.action.SpawnItemAction;
import nl.tudelft.goal.ut2004.visualizer.gui.dialogs.AddNativeBotDialog;
import nl.tudelft.goal.ut2004.visualizer.gui.dialogs.AddUnrealGoalBotDialog;
import nl.tudelft.goal.ut2004.visualizer.map.PureMapTopPanel;
import nl.tudelft.goal.ut2004.visualizer.services.ISelectionHandler;
import nl.tudelft.goal.ut2004.visualizer.util.UnrealActors;
import nl.tudelft.pogamut.base.server.ServerDefinition;

public class MapPanel
extends JPanel {
    private static final String NO_INFO_MSG = "No information Available, please check connection";
    private static final String[] teamNames = new String[]{"Red", "Blue"};
    private final PopupMenuSelectionHandler popupMenuSelectionHandler;
    private final PureMapTopPanel mapVisualization;

    public MapPanel() {
        this.setLayout(new BorderLayout());
        this.popupMenuSelectionHandler = new PopupMenuSelectionHandler();
        ServerController controller = ServerController.getInstance();
        ServerDefinition<IUT2004Server> serverDefition = controller.getServerDefinition();
        this.mapVisualization = new PureMapTopPanel(serverDefition);
        this.mapVisualization.setSelectionHandler((ISelectionHandler)this.popupMenuSelectionHandler);
        this.add(this.popupMenuSelectionHandler);
        this.add((Component)this.mapVisualization);
    }

    private class PopupMenuSelectionHandler
    extends PopupMenu
    implements ISelectionHandler {
        private PopupMenuSelectionHandler() {
        }

        public void selected(Set<Object> selected, Point at, Component origin) {
            this.removeAll();
            if (selected.isEmpty()) {
                return;
            }
            for (Object object : selected) {
                if (object instanceof IPlayer) {
                    this.addAgentMenu((IPlayer)object);
                    continue;
                }
                if (!(object instanceof IUnrealWaypoint)) continue;
                this.addNavPointMenu((IUnrealWaypoint)object, at);
            }
            this.show((Component)MapPanel.this.mapVisualization, at.x, at.y);
        }

        private void addNavPointMenu(IUnrealWaypoint navPoint, Point at) {
            Menu m = new Menu(navPoint.getID());
            Menu respawn = this.getRespawnHereMenu(navPoint);
            if (respawn != null) {
                m.add(respawn);
            }
            Menu addBot = new Menu("Add Bot");
            MenuItem nativeBot = this.getAddNativeMenu(navPoint, at);
            addBot.add(nativeBot);
            MenuItem unrealGoal = this.getAddUnrealGoalMenu(navPoint, at);
            if (unrealGoal != null) {
                addBot.add(unrealGoal);
            }
            m.add(addBot);
            Menu spawnItem = this.getSpawnItemMenu(navPoint);
            m.add(spawnItem);
            this.add(m);
        }

        private Menu getSpawnItemMenu(IUnrealWaypoint navPoint) {
            Menu spawnItem = new Menu("Spawn Item");
            for (String id : UnrealActors.INVENTORY_TYPES) {
                MenuItem item = new MenuItem(id);
                item.addActionListener(new SpawnItemAction(navPoint, id));
                spawnItem.add(item);
            }
            return spawnItem;
        }

        private MenuItem getAddUnrealGoalMenu(final IUnrealWaypoint navPoint, final Point at) {
            ServerController controller = ServerController.getInstance();
            EnvironmentData data = controller.getEnvironmentData();
            if (data.getEnvironments().isEmpty()) {
                return null;
            }
            MenuItem unrealGoal = new MenuItem("UnrealGoal");
            unrealGoal.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddUnrealGoalBotDialog d = new AddUnrealGoalBotDialog(null, navPoint);
                    d.setLocationRelativeTo(MapPanel.this);
                    d.setLocation(at);
                    d.setVisible(true);
                }
            });
            return unrealGoal;
        }

        private MenuItem getAddNativeMenu(final IUnrealWaypoint navPoint, final Point at) {
            MenuItem nativeBot = new MenuItem("Native");
            nativeBot.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddNativeBotDialog d = new AddNativeBotDialog(null, navPoint);
                    d.setLocationRelativeTo(MapPanel.this);
                    d.setLocation(at);
                    d.setVisible(true);
                }
            });
            return nativeBot;
        }

        private Menu getRespawnHereMenu(IUnrealWaypoint navPoint) {
            ServerController controller = ServerController.getInstance();
            ObservableCollection<Player> players = controller.getGameData().getPlayers();
            if (players.isEmpty()) {
                return null;
            }
            Menu respawn = new Menu("Respawn (here)");
            for (Player p : players) {
                MenuItem player = new MenuItem(p.getName());
                player.addActionListener(new RespawnHereAction(p, navPoint));
                respawn.add(player);
            }
            return respawn;
        }

        private void addAgentMenu(IPlayer bot) {
            Menu m = new Menu(bot.getName());
            Menu inventory = this.getAddInventoryMenu(bot);
            MenuItem kick = new MenuItem("Kick");
            kick.addActionListener(new KickAction(bot));
            MenuItem change = new MenuItem("Change Team");
            change.addActionListener(new ChangeTeamAction(bot));
            MenuItem respawn = new MenuItem("Respawn (random)");
            respawn.addActionListener(new RespawnRandomAction(bot));
            m.add(inventory);
            m.add(kick);
            m.add(change);
            m.add(respawn);
            this.add(m);
        }

        private Menu getAddInventoryMenu(IPlayer bot) {
            Menu spawnItem = new Menu("Add Inventory");
            for (String id : UnrealActors.INVENTORY_TYPES) {
                MenuItem item = new MenuItem(id);
                item.addActionListener(new AddInventoryAction(bot, id));
                spawnItem.add(item);
            }
            return spawnItem;
        }
    }
}

