/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.gui.dialogs;

import cz.cuni.amis.pogamut.unreal.communication.worldview.map.IUnrealWaypoint;
import cz.cuni.amis.utils.collections.CollectionEventListener;
import cz.cuni.amis.utils.collections.ObservableSet;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import nl.tudelft.goal.ut2004.util.Team;
import nl.tudelft.goal.ut2004.visualizer.connection.EnvironmentService;
import nl.tudelft.goal.ut2004.visualizer.controller.ServerController;
import nl.tudelft.goal.ut2004.visualizer.data.EnvironmentData;
import nl.tudelft.goal.ut2004.visualizer.gui.action.AddUnrealGoalBotAction;
import nl.tudelft.goal.ut2004.visualizer.gui.widgets.WaypointBox;
import nl.tudelft.goal.ut2004.visualizer.util.CollectionEventAdaptor;
import nl.tudelft.goal.ut2004.visualizer.util.SelectableEnvironment;
import nl.tudelft.goal.ut2004.visualizer.util.WindowPersistenceHelper;

public class AddUnrealGoalBotDialog
extends JDialog {
    private JTextField nameField;
    private JSpinner levelSpinner;
    private JComboBox teamList;
    private WaypointBox location;
    private JButton addButton;
    private JButton closeButton;
    private JComboBox environmentList;
    private WindowPersistenceHelper persistenceHelper;

    public AddUnrealGoalBotDialog(Frame parent, IUnrealWaypoint navPoint) {
        super(parent, false);
        this.setTitle("Add UnrealGoal bot");
        this.setLayout(new FlowLayout());
        this.add(new JLabel("Name"));
        this.nameField = new JTextField();
        this.nameField.setColumns(15);
        this.add(this.nameField);
        this.add(new JLabel("Level"));
        SpinnerNumberModel levelModel = new SpinnerNumberModel(4, 1, 7, 1);
        this.levelSpinner = new JSpinner(levelModel);
        this.add(this.levelSpinner);
        this.add(new JLabel("Team"));
        this.teamList = new JComboBox<Team>(Team.values());
        this.teamList.setSelectedIndex(0);
        this.add(this.teamList);
        this.location = new WaypointBox();
        if (navPoint != null) {
            this.location.setSelected(navPoint);
        }
        this.add(this.location);
        ServerController controller = ServerController.getInstance();
        EnvironmentData data = controller.getEnvironmentData();
        ObservableSet<EnvironmentService> clients = data.getEnvironments();
        Collection<SelectableEnvironment> s = SelectableEnvironment.fromCollection(clients);
        this.environmentList = new JComboBox<Object>(s.toArray());
        clients.addCollectionListener((CollectionEventListener)new CollectionEventAdaptor<EnvironmentService>(){

            @Override
            public void postAddEvent(Collection<EnvironmentService> alreadyAdded, final Collection<EnvironmentService> whereWereAdded) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Collection<SelectableEnvironment> s = SelectableEnvironment.fromCollection(whereWereAdded);
                        AddUnrealGoalBotDialog.this.environmentList.setModel(new DefaultComboBoxModel<Object>(s.toArray()));
                    }
                });
            }

            @Override
            public void postRemoveEvent(Collection<EnvironmentService> alreadyRemoved, final Collection<EnvironmentService> whereWereRemoved) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Collection<SelectableEnvironment> s = SelectableEnvironment.fromCollection(whereWereRemoved);
                        AddUnrealGoalBotDialog.this.environmentList.setModel(new DefaultComboBoxModel<Object>(s.toArray()));
                    }
                });
            }
        });
        this.add(this.environmentList);
        this.addButton = new JButton("Add Bot");
        this.addButton.addActionListener(new AddUnrealGoalBotAction(this.nameField, this.location, this.levelSpinner, this.teamList, this.environmentList));
        this.add(this.addButton);
        this.setSize(400, 225);
        this.persistenceHelper = new WindowPersistenceHelper(this);
        this.persistenceHelper.load();
    }
}

