/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.data;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.FlagInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.TeamScore;
import cz.cuni.amis.pogamut.ut2004.server.IUT2004Server;
import java.util.Collection;
import java.util.Map;
import nl.tudelft.goal.ut2004.visualizer.data.AbstractData;

public class GameStatusData
extends AbstractData {
    private static final int NUMBER_OF_TEAMS = 2;
    private GameInfo gameInfo;
    private Collection<FlagInfo> flagInfoCollection;
    private Collection<TeamScore> teamScoreCollection;

    @Override
    public synchronized void serverChanged(IUT2004Server server) {
        if (server != null) {
            this.updateGameInfo(server.getWorldView());
            this.updateFlagInfo(server.getWorldView());
            this.updateTeamScore(server.getWorldView());
        } else {
            this.clearGameInfo();
            this.clearFlagInfo();
            this.clearTeamScore();
        }
        this.notifyListeners();
    }

    private void clearTeamScore() {
        this.teamScoreCollection = null;
    }

    private void updateTeamScore(IWorldView view) {
        Class<TeamScore> teamScoreClass = TeamScore.class;
        this.teamScoreCollection = view.getAll(teamScoreClass).values();
    }

    private void clearFlagInfo() {
        this.flagInfoCollection = null;
    }

    private void clearGameInfo() {
        this.gameInfo = null;
    }

    private void updateGameInfo(IWorldView view) {
        this.gameInfo = (GameInfo)view.getSingle(GameInfo.class);
    }

    private void updateFlagInfo(IWorldView view) {
        Map flags = view.getAll(FlagInfo.class);
        this.flagInfoCollection = flags.values();
    }

    public synchronized GameInfo getGameInfo() {
        return this.gameInfo;
    }

    public synchronized Collection<FlagInfo> getFlagInfoCollection() {
        return this.flagInfoCollection;
    }

    public synchronized Collection<TeamScore> getTeamScoreCollection() {
        return this.teamScoreCollection;
    }
}

