/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.jmx;

import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.PogamutProperty;
import cz.cuni.amis.pogamut.base.utils.exception.PogamutJMXNameException;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.token.IToken;
import javax.management.ObjectName;

public class PogamutJMX {
    public static final String AGENT_SUBTYPE = "agent";
    public static final String ACT_NAME = "act";
    public static final String LOGCATEGORIES_NAME = "logcat";
    public static final String LOGCATEGORY_SUBTYPE = "logcategory";
    public static final String FLAGS_SUBTYPE = "flags";
    public static final String INTROSPECTION_NAME = "introspection";
    public static String AGENT_LOGGER_SUBTYPE = "agentlogger";

    public static ObjectName getAgentObjectName(IToken agentId) {
        return PogamutJMX.getAgentObjectName(agentId.getToken());
    }

    public static ObjectName getAgentObjectName(String agentId) {
        return PogamutJMX.getObjectName(PogamutJMX.getPogamutJMXDomain(), "agent-" + Pogamut.getPlatform().getProperty(PogamutProperty.POGAMUT_JMX_SUBDOMAIN.getKey()), agentId);
    }

    public static String getPogamutJMXDomain() {
        return Pogamut.getPlatform().getProperty(PogamutProperty.POGAMUT_JMX_DOMAIN.getKey());
    }

    public static ObjectName getObjectName(ObjectName parent, String childName, String childTypeExtra) throws PogamutJMXNameException {
        NullCheck.check((Object)parent, (String)"parent");
        String parentDomain = parent.getDomain();
        String parentType = parent.getKeyProperty("type");
        String parentName = parent.getKeyProperty("name");
        if (childTypeExtra != null) {
            String[] childTypeParts = childTypeExtra.split(".");
            if (childTypeParts.length != 0) {
                int i;
                for (i = 0; i < childTypeParts.length; ++i) {
                    childTypeParts[i] = PogamutJMX.getSafeObjectNamePart(childTypeParts[i]);
                }
                childTypeExtra = childTypeParts[0];
                for (i = 1; i < childTypeParts.length; ++i) {
                    childTypeExtra = childTypeExtra + "." + childTypeParts[i];
                }
            } else {
                childTypeExtra = PogamutJMX.getSafeObjectNamePart(childTypeExtra);
            }
        }
        String childType = childTypeExtra == null ? parentType + "." + parentName : parentType + "." + parentName + "." + childTypeExtra;
        return PogamutJMX.getObjectName(parentDomain, childType, childName);
    }

    public static ObjectName getObjectName(ObjectName parent, String childName) throws PogamutJMXNameException {
        NullCheck.check((Object)parent, (String)"parent");
        NullCheck.check((Object)childName, (String)"childName");
        String parentDomain = parent.getKeyProperty("domain");
        String parentType = parent.getKeyProperty("type");
        String parentName = parent.getKeyProperty("name");
        String childType = parentType + "." + parentName;
        return PogamutJMX.getObjectName(parentDomain, childType, childName);
    }

    public static String getSafeObjectNamePart(String str) {
        return str.replace('[', '_').replace(']', '_').replace('(', '_').replace(')', '_').replace('.', '_').replace(',', '_').replace('/', '_').replace('*', '_').replace('?', '_').replace(':', '_');
    }

    public static ObjectName getObjectName(String jmxDomain, String type, String name) throws PogamutJMXNameException {
        if (name != null) {
            name = PogamutJMX.getSafeObjectNamePart(name);
        }
        String jmxName = name == null ? jmxDomain + ":type=" + type : jmxDomain + ":type=" + type + ",name=" + name;
        try {
            return ObjectName.getInstance(jmxName);
        }
        catch (Exception e) {
            throw new PogamutJMXNameException(jmxName, e);
        }
    }
}

