/*
 * Decompiled with CFR 0.152.
 */
package eis.eis2java.translation;

import eis.eis2java.exception.NoTranslatorException;
import eis.eis2java.exception.TranslationException;
import eis.eis2java.translation.Java2Parameter;
import eis.eis2java.translation.Parameter2Java;
import eis.iilang.Identifier;
import eis.iilang.Numeral;
import eis.iilang.Parameter;
import eis.iilang.ParameterList;
import eis.iilang.TruthValue;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.Iterator;

public class Translator {
    private static Translator singleton;
    private final HashMap<Class<?>, Java2Parameter<?>> java2ParameterTranslators = new HashMap();
    private final HashMap<Class<?>, Parameter2Java<?>> parameter2JavaTranslators = new HashMap();

    public static Translator getInstance() {
        if (singleton == null) {
            singleton = new Translator();
        }
        return singleton;
    }

    private Translator() {
        NumberTranslator numberTranslator = new NumberTranslator();
        this.registerJava2ParameterTranslator(numberTranslator);
        this.registerParameter2JavaTranslator(numberTranslator);
        BooleanTranslator booleanTranslator = new BooleanTranslator();
        this.registerJava2ParameterTranslator(booleanTranslator);
        this.registerParameter2JavaTranslator(booleanTranslator);
        CharTranslator charTranslator = new CharTranslator();
        this.registerJava2ParameterTranslator(charTranslator);
        this.registerParameter2JavaTranslator(charTranslator);
        StringTranslator stringTranslator = new StringTranslator();
        this.registerJava2ParameterTranslator(stringTranslator);
        this.registerParameter2JavaTranslator(stringTranslator);
        CollectionTranslator collectionTranslator = new CollectionTranslator();
        this.registerJava2ParameterTranslator(collectionTranslator);
        this.registerParameter2JavaTranslator(new IntegerTranslator());
        this.registerParameter2JavaTranslator(new LongTranslator());
        this.registerParameter2JavaTranslator(new ShortTranslator());
        this.registerParameter2JavaTranslator(new DoubleTranslator());
        this.registerParameter2JavaTranslator(new FloatTranslator());
    }

    public void registerJava2ParameterTranslator(Java2Parameter<?> translator) {
        this.java2ParameterTranslators.put(translator.translatesFrom(), translator);
    }

    public void registerParameter2JavaTranslator(Parameter2Java<?> translator) {
        this.parameter2JavaTranslators.put(translator.translatesTo(), translator);
    }

    public <T> Parameter[] translate2Parameter(T o) throws TranslationException {
        Java2Parameter<?> rawTranslator = null;
        Class<?> clazz = o.getClass();
        if (clazz.isPrimitive()) {
            clazz = this.getWrapper(clazz);
        }
        while (clazz != null && rawTranslator == null) {
            rawTranslator = this.java2ParameterTranslators.get(clazz);
            clazz = clazz.getSuperclass();
        }
        if (rawTranslator == null) {
            throw new NoTranslatorException(o.getClass());
        }
        Java2Parameter<?> translator = rawTranslator;
        return translator.translate(o);
    }

    public <T> T translate2Java(Parameter parameter, Class<T> parameterClass) throws TranslationException, NoTranslatorException {
        Parameter2Java<?> rawTranslator;
        Class<Object> clazz = parameterClass;
        if (clazz.isPrimitive()) {
            clazz = this.getWrapper(clazz);
        }
        if ((rawTranslator = this.parameter2JavaTranslators.get(clazz)) == null) {
            throw new NoTranslatorException(clazz);
        }
        Parameter2Java<?> translator = rawTranslator;
        return (T)translator.translate(parameter);
    }

    private Class<?> getWrapper(Class<?> clazz) {
        if (Integer.TYPE.equals(clazz)) {
            return Integer.class;
        }
        if (Boolean.TYPE.equals(clazz)) {
            return Boolean.class;
        }
        if (Long.TYPE.equals(clazz)) {
            return Long.class;
        }
        if (Float.TYPE.equals(clazz)) {
            return Float.class;
        }
        if (Character.TYPE.equals(clazz)) {
            return Character.class;
        }
        if (Double.TYPE.equals(clazz)) {
            return Double.class;
        }
        if (Byte.TYPE.equals(clazz)) {
            return Byte.class;
        }
        if (Short.TYPE.equals(clazz)) {
            return Short.class;
        }
        if (Void.TYPE.equals(clazz)) {
            return Void.class;
        }
        return null;
    }

    private static class BooleanTranslator
    implements Java2Parameter<Boolean>,
    Parameter2Java<Boolean> {
        private BooleanTranslator() {
        }

        @Override
        public Parameter[] translate(Boolean b) throws TranslationException {
            return new Parameter[]{new TruthValue(b)};
        }

        @Override
        public Class<Boolean> translatesFrom() {
            return Boolean.class;
        }

        @Override
        public Boolean translate(Parameter parameter) throws TranslationException {
            if (!(parameter instanceof TruthValue)) {
                throw new TranslationException("Expected a Truthvalue parameter but got " + parameter);
            }
            return ((TruthValue)parameter).getBooleanValue();
        }

        @Override
        public Class<Boolean> translatesTo() {
            return Boolean.class;
        }
    }

    private static class CharTranslator
    implements Java2Parameter<Character>,
    Parameter2Java<Character> {
        private CharTranslator() {
        }

        @Override
        public Character translate(Parameter parameter) throws TranslationException {
            if (!(parameter instanceof Identifier)) {
                throw new TranslationException("Expected an Identifier parameter but got " + parameter);
            }
            Identifier id = (Identifier)parameter;
            String value = id.getValue();
            if (value.length() > 1) {
                throw new TranslationException("A single character was expected instead a string of length " + value.length() + " was given. Contents: " + value);
            }
            return Character.valueOf(value.charAt(0));
        }

        @Override
        public Class<Character> translatesTo() {
            return Character.class;
        }

        @Override
        public Parameter[] translate(Character value) throws TranslationException {
            return new Parameter[]{new Identifier(String.valueOf(value))};
        }

        @Override
        public Class<Character> translatesFrom() {
            return Character.class;
        }
    }

    private static class CollectionTranslator<T>
    implements Java2Parameter<AbstractCollection<T>> {
        private CollectionTranslator() {
        }

        @Override
        public Parameter[] translate(AbstractCollection<T> value) throws TranslationException {
            Parameter[] parameters = new Parameter[value.size()];
            int i = 0;
            Iterator<T> it = value.iterator();
            Translator translator = Translator.getInstance();
            while (it.hasNext()) {
                Parameter[] translation = translator.translate2Parameter(it.next());
                parameters[i] = translation.length == 1 ? translation[0] : new ParameterList(translation);
                ++i;
            }
            return new Parameter[]{new ParameterList(parameters)};
        }

        @Override
        public Class<? extends AbstractCollection<T>> translatesFrom() {
            Class<AbstractCollection> cls = AbstractCollection.class;
            return cls;
        }
    }

    private static class DoubleTranslator
    implements Parameter2Java<Double> {
        private DoubleTranslator() {
        }

        @Override
        public Double translate(Parameter parameter) throws TranslationException {
            if (!(parameter instanceof Numeral)) {
                throw new TranslationException("Expected a numeral parameter but got " + parameter);
            }
            return ((Numeral)parameter).getValue().doubleValue();
        }

        @Override
        public Class<Double> translatesTo() {
            return Double.class;
        }
    }

    private static class FloatTranslator
    implements Parameter2Java<Float> {
        private FloatTranslator() {
        }

        @Override
        public Float translate(Parameter parameter) throws TranslationException {
            if (!(parameter instanceof Numeral)) {
                throw new TranslationException("Expected a numeral parameter but got " + parameter);
            }
            return Float.valueOf(((Numeral)parameter).getValue().floatValue());
        }

        @Override
        public Class<Float> translatesTo() {
            return Float.class;
        }
    }

    private static class IntegerTranslator
    implements Parameter2Java<Integer> {
        private IntegerTranslator() {
        }

        @Override
        public Integer translate(Parameter parameter) throws TranslationException {
            if (!(parameter instanceof Numeral)) {
                throw new TranslationException("Expected a numeral parameter but got " + parameter);
            }
            return ((Numeral)parameter).getValue().intValue();
        }

        @Override
        public Class<Integer> translatesTo() {
            return Integer.class;
        }
    }

    private static class LongTranslator
    implements Parameter2Java<Long> {
        private LongTranslator() {
        }

        @Override
        public Long translate(Parameter parameter) throws TranslationException {
            if (!(parameter instanceof Numeral)) {
                throw new TranslationException("Expected a numeral parameter but got " + parameter);
            }
            return ((Numeral)parameter).getValue().longValue();
        }

        @Override
        public Class<Long> translatesTo() {
            return Long.class;
        }
    }

    private static class NumberTranslator
    implements Java2Parameter<Number>,
    Parameter2Java<Number> {
        private NumberTranslator() {
        }

        @Override
        public Parameter[] translate(Number n) throws TranslationException {
            return new Parameter[]{new Numeral(n)};
        }

        @Override
        public Class<Number> translatesFrom() {
            return Number.class;
        }

        @Override
        public Number translate(Parameter parameter) throws TranslationException {
            if (!(parameter instanceof Numeral)) {
                throw new TranslationException("Expected a numeral parameter but got " + parameter);
            }
            return ((Numeral)parameter).getValue();
        }

        @Override
        public Class<Number> translatesTo() {
            return Number.class;
        }
    }

    private static class ShortTranslator
    implements Parameter2Java<Short> {
        private ShortTranslator() {
        }

        @Override
        public Short translate(Parameter parameter) throws TranslationException {
            if (!(parameter instanceof Numeral)) {
                throw new TranslationException("Expected a numeral parameter but got " + parameter);
            }
            return ((Numeral)parameter).getValue().shortValue();
        }

        @Override
        public Class<Short> translatesTo() {
            return Short.class;
        }
    }

    private static class StringTranslator
    implements Java2Parameter<String>,
    Parameter2Java<String> {
        private StringTranslator() {
        }

        @Override
        public String translate(Parameter parameter) throws TranslationException {
            if (!(parameter instanceof Identifier)) {
                throw new TranslationException("Expected an Identifier parameter but got " + parameter);
            }
            Identifier id = (Identifier)parameter;
            return id.getValue();
        }

        @Override
        public Class<String> translatesTo() {
            return String.class;
        }

        @Override
        public Parameter[] translate(String value) throws TranslationException {
            return new Parameter[]{new Identifier(value)};
        }

        @Override
        public Class<String> translatesFrom() {
            return String.class;
        }
    }
}

