/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.gui;

import cz.cuni.amis.pogamut.ut2004.server.IUT2004Server;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import nl.tudelft.goal.unreal.util.vecmathcheck.VecmathCheck;
import nl.tudelft.goal.ut2004.visualizer.controller.ServerController;
import nl.tudelft.goal.ut2004.visualizer.gui.action.PauseResumeAction;
import nl.tudelft.goal.ut2004.visualizer.gui.action.ShowDialogueAction;
import nl.tudelft.goal.ut2004.visualizer.gui.action.ShowServerDependentDialogueAction;
import nl.tudelft.goal.ut2004.visualizer.gui.action.ShowServerEnvironmentDependentDialogueAction;
import nl.tudelft.goal.ut2004.visualizer.gui.dialogs.AddNativeBotDialog;
import nl.tudelft.goal.ut2004.visualizer.gui.dialogs.AddUnrealGoalBotDialog;
import nl.tudelft.goal.ut2004.visualizer.gui.dialogs.ChangeGameSpeedDialog;
import nl.tudelft.goal.ut2004.visualizer.gui.dialogs.ChangeMapDialog;
import nl.tudelft.goal.ut2004.visualizer.gui.dialogs.ListEnvironmentsDialog;
import nl.tudelft.goal.ut2004.visualizer.gui.dialogs.ListPlayerDialog;
import nl.tudelft.goal.ut2004.visualizer.gui.dialogs.ServerConnectionDialog;
import nl.tudelft.goal.ut2004.visualizer.gui.dialogs.SettingsDialog;
import nl.tudelft.goal.ut2004.visualizer.gui.panels.MapPanel;
import nl.tudelft.goal.ut2004.visualizer.util.WindowPersistenceHelper;
import nl.tudelft.pogamut.base.server.ReconnectingServerDefinition;
import nl.tudelft.pogamut.base.server.ServerDefinition;

public class UnrealVisualizerGUI
extends JFrame {
    private static final int WINDOW_WIDTH = 800;
    private static final int WINDOW_HEIGHT = 600;
    private final MapPanel mapPanel;
    private WindowPersistenceHelper persistenceHelper;

    public UnrealVisualizerGUI() {
        ServerController.createNewController();
        ServerController controller = ServerController.getInstance();
        ServerDefinition<IUT2004Server> serverDefinition = controller.getServerDefinition();
        this.setTitle("Unreal Tournament 2004 Visualizer for GOAL");
        this.setSize(800, 600);
        this.setResizable(true);
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(3);
        this.persistenceHelper = new WindowPersistenceHelper(this);
        this.persistenceHelper.load();
        this.setupMenuBar();
        this.mapPanel = new MapPanel();
        JPanel mainPanel = new JPanel(new GridLayout(1, 1));
        mainPanel.add(this.mapPanel);
        this.add(mainPanel);
    }

    private void setupMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.setLayout(new FlowLayout(0, 0, 0));
        this.setJMenuBar(menuBar);
        JMenu applicationMenu = new JMenu("Visualizer");
        SettingsDialog settingsDialogue = new SettingsDialog(this);
        String name = "Settings";
        String description = "Change the settings of the visualizer.";
        ShowDialogueAction showSettings = new ShowDialogueAction(settingsDialogue, name, description);
        JMenuItem settings = new JMenuItem(showSettings);
        applicationMenu.add(settings);
        JMenuItem exitVis = new JMenuItem("Exit", 69);
        exitVis.setToolTipText("Exit the Visualizer");
        exitVis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UnrealVisualizerGUI.this.dispose();
                System.exit(0);
            }
        });
        applicationMenu.add(exitVis);
        menuBar.add(applicationMenu);
        JMenu server = new JMenu("Server");
        ServerController controller = ServerController.getInstance();
        ServerDefinition<IUT2004Server> serverDefinition = controller.getServerDefinition();
        ServerConnectionDialog connectionDialog = new ServerConnectionDialog((Frame)this, (ReconnectingServerDefinition)serverDefinition);
        String name2 = "Connection";
        String description2 = "Connect to an Unreal Tournament Server.";
        ShowDialogueAction action = new ShowDialogueAction(connectionDialog, name2, description2);
        JMenuItem connect = new JMenuItem(action);
        server.add(connect);
        JMenuItem pauseResume = new JMenuItem(new PauseResumeAction());
        server.add(pauseResume);
        ChangeGameSpeedDialog gameSpeedDialog = new ChangeGameSpeedDialog(this);
        String name3 = "Game Speed";
        String description3 = "Change the speed of the game.";
        ShowDialogueAction action2 = new ShowServerDependentDialogueAction(gameSpeedDialog, name3, description3);
        JMenuItem speed = new JMenuItem(action2);
        server.add(speed);
        ChangeMapDialog changeMapDialog = new ChangeMapDialog(this);
        name3 = "Change Map";
        description3 = "Change the current map.";
        action2 = new ShowServerDependentDialogueAction(changeMapDialog, name3, description3);
        JMenuItem change = new JMenuItem(action2);
        server.add(change);
        AddNativeBotDialog addNativeBotDialog = new AddNativeBotDialog((Frame)this, null);
        name3 = "Add Native Bot";
        description3 = "Adds a native unreal bot to the game.";
        action2 = new ShowServerDependentDialogueAction(addNativeBotDialog, name3, description3);
        JMenuItem add = new JMenuItem(action2);
        server.add(add);
        AddUnrealGoalBotDialog addUnrealGoalBotDialog = new AddUnrealGoalBotDialog((Frame)this, null);
        name3 = "Add UnrealGoal Bot";
        description3 = "Adds an UnrealGoal bot to the game.";
        action2 = new ShowServerEnvironmentDependentDialogueAction(addUnrealGoalBotDialog, name3, description3);
        add = new JMenuItem(action2);
        server.add(add);
        ListPlayerDialog listPlayerDialog = new ListPlayerDialog(this);
        name3 = "List Players";
        description3 = "Lists all player in the game.";
        action2 = new ShowServerDependentDialogueAction(listPlayerDialog, name3, description3);
        add = new JMenuItem(action2);
        server.add(add);
        menuBar.add(server);
        JMenu environments = new JMenu("Environments");
        String name4 = "List Environments";
        String description4 = "List Goal Environments connected to the visualizier.";
        ListEnvironmentsDialog listDialog = new ListEnvironmentsDialog(this);
        action2 = new ShowDialogueAction(listDialog, name4, description4);
        JMenuItem list = new JMenuItem(action2);
        environments.add(list);
        menuBar.add(environments);
    }

    @Override
    public void dispose() {
        super.dispose();
        ServerController.disposeController();
    }

    public static void main(String[] args) {
        if (!VecmathCheck.check()) {
            JOptionPane.showMessageDialog(null, VecmathCheck.getErrorMessage(), "Version Conflict", 0);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UnrealVisualizerGUI vizualiser = new UnrealVisualizerGUI();
                vizualiser.setVisible(true);
            }
        });
    }
}

