/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.timeline.map;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.worldview.map.Box;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.event.MouseInputAdapter;
import nl.tudelft.goal.ut2004.visualizer.map.MapGLPanel;
import nl.tudelft.goal.ut2004.visualizer.timeline.map.MapViewpoint;

public class MapController
extends MouseInputAdapter
implements MouseListener,
MouseMotionListener {
    private final MapGLPanel panel;
    private final MapViewpoint viewpoint;
    private Point last;
    private Box bounds;
    private Location center;
    private ModificationStatus operationMode = ModificationStatus.NONE;

    public MapController(MapGLPanel panel, MapViewpoint mapViewpoint, Box bounds) {
        this.panel = panel;
        this.viewpoint = mapViewpoint;
        this.center = new Location(bounds.getCenterX(), bounds.getCenterY(), bounds.getCenterZ());
        this.bounds = bounds;
    }

    public void registerListeners() {
        this.panel.addMouseListener(this);
        this.panel.addMouseMotionListener(this);
        this.panel.addMouseWheelListener(this);
    }

    public void unregisterListeners() {
        this.panel.removeMouseListener(this);
        this.panel.removeMouseMotionListener(this);
        this.panel.removeMouseWheelListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 2) {
            this.viewpoint.setFromViewedBox(this.bounds);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.updateMode(e);
        this.last = e.getLocationOnScreen();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.updateMode(e);
        this.last = e.getLocationOnScreen();
    }

    private ModificationStatus updateMode(MouseEvent e) {
        boolean rightDown;
        boolean leftDown = (e.getModifiersEx() & 0x400) == 1024;
        boolean bl = rightDown = (e.getModifiersEx() & 0x1000) == 4096;
        this.operationMode = leftDown && rightDown ? ModificationStatus.MOVE_CENTER : (leftDown && !rightDown ? ModificationStatus.MOVE_AHEAD : (!leftDown && rightDown ? ModificationStatus.ROTATE_EYE : ModificationStatus.NONE));
        System.out.println("ModificationMode: " + (Object)((Object)this.operationMode));
        return this.operationMode;
    }

    private void changeViewpoint(double deltaX, double deltaY) {
        double pixelsPerDegree = 5.0;
        double unitsPerPixel = 10.0;
        switch (this.operationMode) {
            case ROTATE_EYE: {
                this.rotateEye(deltaX / pixelsPerDegree, deltaY / pixelsPerDegree);
                break;
            }
            case MOVE_CENTER: {
                this.moveCenter(deltaX * unitsPerPixel, deltaY * unitsPerPixel);
                break;
            }
            case MOVE_AHEAD: {
                this.moveAhead(deltaY * unitsPerPixel, deltaX / pixelsPerDegree);
            }
        }
    }

    private void moveAhead(double distance, double angle) {
        Location forward = this.viewpoint.getEye2Center().getNormalized().scale(-distance);
        forward = forward.setZ(0.0);
        this.viewpoint.move(forward);
        this.viewpoint.rotateCenter(new Location(0.0, 0.0, 1.0), angle);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point current = e.getLocationOnScreen();
        int deltaX = current.x - this.last.x;
        int deltaY = current.y - this.last.y;
        this.changeViewpoint(deltaX, deltaY);
        this.last = current;
    }

    private void rotateEye(double leftRightAngle, double upDownAngle) {
        this.viewpoint.rotateCenter(this.viewpoint.getRightVector(), upDownAngle);
        this.viewpoint.rotateCenter(new Location(0.0, 0.0, 1.0), leftRightAngle);
    }

    private void moveCenter(double deltaX, double deltaY) {
        Location right = this.viewpoint.getRightVector().getNormalized().scale(-deltaX);
        this.viewpoint.move(right);
        Location up = new Location(0.0, 0.0, deltaY);
        System.out.println("MoveCenter up " + up);
        this.viewpoint.move(up);
    }

    private static enum ModificationStatus {
        NONE,
        ROTATE_EYE,
        MOVE_CENTER,
        MOVE_AHEAD;

    }
}

