/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.timeline.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.media.opengl.GL;
import nl.tudelft.goal.ut2004.visualizer.timeline.map.ISubGLRenderer;

public class CollectionRenderer<T>
implements ISubGLRenderer<Collection<T>> {
    private List<ISubGLRenderer<T>> renderers = Collections.synchronizedList(new ArrayList());

    public synchronized void addRenderer(ISubGLRenderer<? extends T> subrenderer) {
        this.renderers.add(subrenderer);
    }

    public synchronized boolean removeRenderer(ISubGLRenderer<? extends T> subrenderer) {
        return this.renderers.remove(subrenderer);
    }

    public synchronized void removeRenderersOf(Object o) {
        ArrayList<ISubGLRenderer<T>> toRemove = new ArrayList<ISubGLRenderer<T>>();
        for (ISubGLRenderer<T> renderer : this.renderers) {
            if (renderer.getObject() != o) continue;
            toRemove.add(renderer);
        }
        this.renderers.removeAll(toRemove);
    }

    public synchronized Set<T> getDrawnObjects() {
        HashSet<T> set = new HashSet<T>();
        for (ISubGLRenderer<T> renderer : this.renderers) {
            set.add(renderer.getObject());
        }
        return set;
    }

    @Override
    public synchronized void render(GL gl) {
        for (ISubGLRenderer<T> subrenderer : this.renderers) {
            subrenderer.render(gl);
        }
    }

    @Override
    public synchronized Collection<T> getObject() {
        ArrayList<T> objects = new ArrayList<T>();
        for (ISubGLRenderer<T> subrenderer : this.renderers) {
            objects.add(subrenderer.getObject());
        }
        return objects;
    }

    @Override
    public synchronized void prepare(GL gl) {
        for (ISubGLRenderer<T> renderer : this.renderers) {
            renderer.prepare(gl);
        }
    }

    public synchronized T getObjectsByGLName(int glName) {
        for (ISubGLRenderer<T> renderer : this.renderers) {
            if (renderer.getGLName() != glName) continue;
            return renderer.getObject();
        }
        return null;
    }

    public synchronized Collection<T> getObjectsByGLName(int[] list) {
        ArrayList<T> results = new ArrayList<T>();
        for (int glName : list) {
            T result = this.getObjectsByGLName(glName);
            if (result == null) continue;
            results.add(result);
        }
        return results;
    }

    @Override
    public void destroy() {
        for (ISubGLRenderer<T> renderer : this.renderers) {
            renderer.destroy();
        }
    }

    @Override
    public int getGLName() {
        return -1;
    }
}

