/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class Score
implements Comparable<Score> {
    private final int id;
    private final double score;

    public Score(int id, double score) {
        this.id = id;
        this.score = score;
    }

    @Override
    public int compareTo(Score o) {
        double diff = o.score - this.score;
        if (diff > 0.0) {
            return 1;
        }
        if (diff < 0.0) {
            return -1;
        }
        return 0;
    }

    public int getId() {
        return this.id;
    }

    public double getScore() {
        return this.score;
    }

    public static ArrayList<Score> getOrderedScoresFor(HashMap<Integer, Double> scoreMap) {
        ArrayList<Score> scores = new ArrayList<Score>(scoreMap.size());
        for (Integer id : scoreMap.keySet()) {
            double s = scoreMap.get(id);
            Score score = new Score(id, s);
            scores.add(score);
        }
        Collections.sort(scores);
        return scores;
    }
}

