/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.gui.dialogs;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import nl.tudelft.goal.ut2004.visualizer.timeline.map.FlagRenderer;
import nl.tudelft.goal.ut2004.visualizer.timeline.map.MapRenderer;
import nl.tudelft.goal.ut2004.visualizer.timeline.map.PlayerRenderer;
import nl.tudelft.goal.ut2004.visualizer.timeline.map.WaypointRenderer;
import nl.tudelft.goal.ut2004.visualizer.util.WindowPersistenceHelper;

public class SettingsDialog
extends JDialog {
    private WindowPersistenceHelper persistenceHelper;

    public SettingsDialog(Frame parent) {
        super(parent, false);
        this.setTitle("Visualizer Settings");
        this.setSize(200, 200);
        this.persistenceHelper = new WindowPersistenceHelper(this);
        this.persistenceHelper.load();
        this.setLayout(new FlowLayout());
        JButton selectHighColor = new JButton("Change Map High Color");
        selectHighColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color current = MapRenderer.getHighColor();
                Color selected = JColorChooser.showDialog(SettingsDialog.this, "Pick a color", current);
                MapRenderer.setHighColor((Color)selected);
            }
        });
        this.add(selectHighColor);
        JButton selectLowColor = new JButton("Change Map Low Color");
        selectLowColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color current = MapRenderer.getLowColor();
                Color selected = JColorChooser.showDialog(SettingsDialog.this, "Pick a color", current);
                if (selected == null) {
                    return;
                }
                MapRenderer.setLowColor((Color)selected);
            }
        });
        this.add(selectLowColor);
        JButton selectNavpointColor = new JButton("Change Navpoint Color");
        selectNavpointColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color current = WaypointRenderer.getColor();
                Color selected = JColorChooser.showDialog(SettingsDialog.this, "Pick a color", current);
                if (selected == null) {
                    return;
                }
                WaypointRenderer.setColor((Color)selected);
            }
        });
        this.add(selectNavpointColor);
        JButton selectRedTeamColor = new JButton("Change Red Team Color");
        selectRedTeamColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color current = FlagRenderer.getRedFlagColor();
                Color selected = JColorChooser.showDialog(SettingsDialog.this, "Pick a color", current);
                if (selected == null) {
                    return;
                }
                FlagRenderer.setRedFlagColor((Color)selected);
                PlayerRenderer.setRedTeamColor((Color)selected);
            }
        });
        this.add(selectRedTeamColor);
        JButton selectBlueTeamColor = new JButton("Change Blue Team Color");
        selectBlueTeamColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color current = FlagRenderer.getBlueFlagColor();
                Color selected = JColorChooser.showDialog(SettingsDialog.this, "Pick a color", current);
                if (selected == null) {
                    return;
                }
                FlagRenderer.setBlueFlagColor((Color)selected);
                PlayerRenderer.setBlueTeamColor((Color)selected);
            }
        });
        this.add(selectBlueTeamColor);
    }
}

