/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.gui.action;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Pause;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.server.IUT2004Server;
import cz.cuni.amis.utils.flag.FlagListener;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import nl.tudelft.goal.ut2004.visualizer.controller.ServerController;

public class PauseResumeAction
extends AbstractAction {
    public PauseResumeAction() {
        this.putValue("ShortDescription", "Pause or resume the game");
        ServerController controller = ServerController.getInstance();
        controller.getServerDefinition().getServerFlag().addListener((FlagListener)new FlagListener<IUT2004Server>(){

            public void flagChanged(IUT2004Server changedValue) {
                if (changedValue == null) {
                    PauseResumeAction.this.setEnabled(false);
                } else {
                    PauseResumeAction.this.setEnabled(true);
                    PauseResumeAction.this.updateStatus();
                }
            }
        });
        this.updateStatus();
    }

    private void updateStatus() {
        ServerController controller = ServerController.getInstance();
        IUT2004Server server = controller.getServer();
        if (server == null) {
            this.putValue("Name", "Pause");
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
        GameInfo info = (GameInfo)server.getWorldView().getSingle(GameInfo.class);
        if (info.isGamePaused()) {
            this.putValue("Name", "Resume");
        } else {
            this.putValue("Name", "Pause");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Pause pauseResume;
        ServerController controller = ServerController.getInstance();
        IUT2004Server server = controller.getServer();
        assert (server != null);
        GameInfo info = (GameInfo)server.getWorldView().getSingle(GameInfo.class);
        if (info.isGamePaused()) {
            pauseResume = new Pause(Boolean.valueOf(false), Boolean.valueOf(false));
            this.putValue("Name", "Pause");
        } else {
            pauseResume = new Pause(Boolean.valueOf(true), Boolean.valueOf(true));
            this.putValue("Name", "Resume");
        }
        server.getAct().act((CommandMessage)pauseResume);
    }
}

