/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.timeline.map;

import com.jogamp.opengl.util.gl2.GLUT;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureIO;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLException;
import javax.media.opengl.glu.GLU;

public class GLTools {
    private static GLU glu = new GLU();
    private static GLUT glut = new GLUT();
    private static Texture texture;

    public static Location getWorldCoordinates(GL gla, GLU glu, Location screen) {
        GL2 gl = gla.getGL2();
        FloatBuffer mvBuffer = FloatBuffer.allocate(16);
        gl.glGetFloatv(2982, mvBuffer);
        FloatBuffer prBuffer = FloatBuffer.allocate(16);
        gl.glGetFloatv(2983, prBuffer);
        IntBuffer vpBuffer = IntBuffer.allocate(16);
        gl.glGetIntegerv(2978, vpBuffer);
        FloatBuffer result = FloatBuffer.allocate(3);
        glu.gluUnProject((float)screen.x, (float)screen.y, (float)screen.z, mvBuffer, prBuffer, vpBuffer, result);
        return new Location((double)result.get(0), (double)result.get(1), (double)result.get(2));
    }

    public static Location getScreenCoordinates(GL gla, GLU glu, Location worldPosition) {
        GL2 gl = gla.getGL2();
        FloatBuffer mvBuffer = FloatBuffer.allocate(16);
        gl.glGetFloatv(2982, mvBuffer);
        FloatBuffer prBuffer = FloatBuffer.allocate(16);
        gl.glGetFloatv(2983, prBuffer);
        IntBuffer vpBuffer = IntBuffer.allocate(16);
        gl.glGetIntegerv(2978, vpBuffer);
        FloatBuffer result = FloatBuffer.allocate(3);
        glu.gluProject((float)worldPosition.x, (float)worldPosition.y, (float)worldPosition.z, mvBuffer, prBuffer, vpBuffer, result);
        return new Location((double)result.get(0), (double)result.get(1), (double)result.get(2));
    }

    public static void renderWindow(GL gla, int x, int y, int width, int height) {
        GL2 gl = gla.getGL2();
        GLTools.pushMatrixMode((GL)gl);
        GLTools.setOrthoViewport((GL)gl);
        try {
            double z = 0.0;
            if (texture == null) {
                texture = TextureIO.newTexture((File)new File("c:/temp/windowTexture.PNG"), (boolean)false);
            }
            texture.bind((GL)gl);
            texture.enable((GL)gl);
            gl.glBegin(7);
            gl.glColor3d(1.0, 1.0, 1.0);
            gl.glTexCoord2d(0.0, 0.0);
            gl.glVertex3d((double)x, (double)y, z);
            gl.glTexCoord2d(1.0, 0.0);
            gl.glVertex3d((double)(x + width), (double)y, z);
            gl.glTexCoord2d(1.0, 1.0);
            gl.glVertex3d((double)(x + width), (double)(y + height), z);
            gl.glTexCoord2d(0.0, 1.0);
            gl.glVertex3d((double)x, (double)(y + height), z);
            gl.glEnd();
            texture.disable((GL)gl);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (GLException ex) {
            ex.printStackTrace();
        }
        GLTools.popMatrixMode((GL)gl);
    }

    public static void setOrthoViewport(GL gla) {
        GL2 gl = gla.getGL2();
        Rectangle viewport = GLTools.getViewport((GL)gl);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(viewport.getMinX(), viewport.getMaxX(), viewport.getMinY(), viewport.getMaxY(), -1.0, 1.0);
        gl.glMatrixMode(5888);
    }

    public static Rectangle getViewport(GL gl) {
        int[] viewport = new int[4];
        gl.glGetIntegerv(2978, viewport, 0);
        return new Rectangle(viewport[0], viewport[1], viewport[2], viewport[3]);
    }

    public static void pushMatrixMode(GL gla) {
        GL2 gl = gla.getGL2();
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadIdentity();
    }

    public static void popMatrixMode(GL gla) {
        GL2 gl = gla.getGL2();
        gl.glMatrixMode(5889);
        gl.glPopMatrix();
        gl.glMatrixMode(5888);
        gl.glPopMatrix();
    }
}

