/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.panels.connection;

import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.FlagListener;
import java.awt.CardLayout;
import java.awt.Component;
import java.net.URI;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import nl.tudelft.goal.ut2004.visualizer.panels.connection.ConnectedPanel;
import nl.tudelft.goal.ut2004.visualizer.panels.connection.ConnectingPanel;
import nl.tudelft.goal.ut2004.visualizer.panels.connection.IConnect;
import nl.tudelft.goal.ut2004.visualizer.panels.connection.IDisconnect;
import nl.tudelft.goal.ut2004.visualizer.panels.connection.NotConnectedPanel;
import nl.tudelft.pogamut.base.server.ReconnectingServerDefinition;

public class ServerConnectionPanel
extends JPanel {
    private static final long serialVersionUID = -3524243884561574625L;
    private static final String NOT_CONNECTED_PANEL = "notConnected";
    private static final String CONNECTED_PANEL = "connected";
    private static final String CONNECTING_PANEL = "connecting";
    private final CardLayout cardLayout;
    private final ReconnectingServerDefinition serverDefinition;
    private final Listener listener;

    public ServerConnectionPanel(ReconnectingServerDefinition serverDefinition) {
        assert (serverDefinition != null);
        this.cardLayout = new CardLayout();
        this.serverDefinition = serverDefinition;
        this.listener = new Listener();
        this.initPanel();
        this.addServerListener();
    }

    private void initPanel() {
        JPanel notConnected = this.makeNotConnectedPanel();
        JPanel connecting = this.makeConnectingPanel();
        JPanel connected = this.makeConnectedPanel();
        this.setLayout(this.cardLayout);
        this.add((Component)notConnected, NOT_CONNECTED_PANEL);
        this.add((Component)connecting, CONNECTING_PANEL);
        this.add((Component)connected, CONNECTED_PANEL);
        this.showPanel(NOT_CONNECTED_PANEL);
    }

    private JPanel makeConnectedPanel() {
        return new ConnectedPanel((Flag<URI>)this.serverDefinition.getUriFlag(), new IDisconnect(){

            @Override
            public void disconnect() {
                ServerConnectionPanel.this.removeServerListener();
                ServerConnectionPanel.this.showPanel(ServerConnectionPanel.NOT_CONNECTED_PANEL);
                ServerConnectionPanel.this.serverDefinition.stopServer();
            }
        });
    }

    private JPanel makeConnectingPanel() {
        return new ConnectingPanel((Flag<URI>)this.serverDefinition.getUriFlag(), new IDisconnect(){

            @Override
            public void disconnect() {
                ServerConnectionPanel.this.removeServerListener();
                ServerConnectionPanel.this.showPanel(ServerConnectionPanel.NOT_CONNECTED_PANEL);
                ServerConnectionPanel.this.serverDefinition.stopServer();
            }
        });
    }

    private JPanel makeNotConnectedPanel() {
        return new NotConnectedPanel(new IConnect(){

            @Override
            public void connect(URI uri) {
                ServerConnectionPanel.this.showPanel(ServerConnectionPanel.CONNECTING_PANEL);
                ServerConnectionPanel.this.addServerListener();
                ServerConnectionPanel.this.serverDefinition.setUri(uri);
            }
        });
    }

    private void addServerListener() {
        this.serverDefinition.getServerFlag().addListener((FlagListener)this.listener);
    }

    private void removeServerListener() {
        this.serverDefinition.getServerFlag().removeListener((FlagListener)this.listener);
    }

    private void showPanel(String panel) {
        this.cardLayout.show(this, panel);
    }

    private class Listener
    implements FlagListener {
        private Listener() {
        }

        public void flagChanged(Object changedValue) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Object server = ServerConnectionPanel.this.serverDefinition.getServerFlag().getFlag();
                    if (server == null) {
                        ServerConnectionPanel.this.showPanel(ServerConnectionPanel.CONNECTING_PANEL);
                    } else {
                        ServerConnectionPanel.this.showPanel(ServerConnectionPanel.CONNECTED_PANEL);
                    }
                }
            });
        }
    }
}

