/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.filesystems.declmime;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.openide.filesystems.declmime.DefaultParser;
import org.netbeans.modules.openide.filesystems.declmime.MIMEComponent;
import org.netbeans.modules.openide.filesystems.declmime.Util;
import org.netbeans.modules.openide.filesystems.declmime.XMLMIMEComponent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MIMEResolver;
import org.openide.util.Parameters;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class MIMEResolverImpl {
    private static final Logger ERR = Logger.getLogger(MIMEResolverImpl.class.getName());
    private static final boolean CASE_INSENSITIVE = Utilities.getOperatingSystem() == 16384;
    private static final int READ_LIMIT = 4000;
    private static Set<String> readLimitReported = new HashSet<String>();
    private static final String MIME_RESOLVERS_PATH = "Services/MIMEResolver";
    private static final String USER_DEFINED_MIME_RESOLVER = "user-defined-mime-resolver";
    private static final int USER_DEFINED_MIME_RESOLVER_POSITION = 10;

    public static MIMEResolver forDescriptor(FileObject fo) {
        return new Impl(fo);
    }

    public static boolean isDeclarative(MIMEResolver resolver) {
        return resolver instanceof Impl;
    }

    public static String[] getMIMETypes(MIMEResolver resolver) {
        ((Impl)resolver).init();
        return ((Impl)resolver).implResolvableMIMETypes;
    }

    public static boolean isUserDefined(FileObject mimeResolverFO) {
        return mimeResolverFO.getAttribute(USER_DEFINED_MIME_RESOLVER) != null;
    }

    public static Map<String, Set<String>> getMIMEToExtensions(FileObject fo) {
        if (!fo.hasExt("xml")) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        Impl impl = new Impl(fo);
        impl.parseDesc();
        FileElement[] elements = impl.smell;
        if (elements != null) {
            for (FileElement fileElement : elements) {
                Set previous;
                String mimeType = fileElement.getMimeType();
                if (mimeType == null) continue;
                String[] extensions = fileElement.getExtensions();
                HashSet<String> extensionsSet = new HashSet<String>();
                if (extensions != null) {
                    for (String extension : extensions) {
                        if (extension.length() <= 0) continue;
                        extensionsSet.add(extension);
                    }
                }
                if ((previous = (Set)result.get(mimeType)) != null) {
                    extensionsSet.addAll(previous);
                }
                result.put(mimeType, extensionsSet);
            }
        }
        return result;
    }

    public static FileObject getUserDefinedResolver() {
        FileObject resolversFolder = FileUtil.getConfigFile(MIME_RESOLVERS_PATH);
        if (resolversFolder != null) {
            FileObject[] resolvers;
            for (FileObject resolverFO : resolvers = resolversFolder.getChildren()) {
                if (resolverFO.getAttribute(USER_DEFINED_MIME_RESOLVER) == null) continue;
                return resolverFO;
            }
        }
        return null;
    }

    public static void storeUserDefinedResolver(final Map<String, Set<String>> mimeToExtensions) {
        Parameters.notNull((CharSequence)"mimeToExtensions", mimeToExtensions);
        FileObject userDefinedResolverFO = MIMEResolverImpl.getUserDefinedResolver();
        if (userDefinedResolverFO != null) {
            try {
                userDefinedResolverFO.delete();
            }
            catch (IOException e) {
                ERR.log(Level.SEVERE, "Cannot delete resolver " + FileUtil.toFile(userDefinedResolverFO), e);
                return;
            }
        }
        if (mimeToExtensions.isEmpty()) {
            return;
        }
        FileUtil.runAtomicAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                Document document = XMLUtil.createDocument((String)"MIME-resolver", null, (String)"-//NetBeans//DTD MIME Resolver 1.1//EN", (String)"http://www.netbeans.org/dtds/mime-resolver-1_1.dtd");
                for (String mimeType : mimeToExtensions.keySet()) {
                    Set extensions = (Set)mimeToExtensions.get(mimeType);
                    if (extensions.isEmpty()) continue;
                    Element fileElement = document.createElement("file");
                    for (String extension : (Set)mimeToExtensions.get(mimeType)) {
                        Element extElement = document.createElement("ext");
                        extElement.setAttribute("name", extension);
                        fileElement.appendChild(extElement);
                    }
                    Element resolverElement = document.createElement("resolver");
                    resolverElement.setAttribute("mime", mimeType);
                    fileElement.appendChild(resolverElement);
                    document.getDocumentElement().appendChild(fileElement);
                }
                if (!document.getDocumentElement().hasChildNodes()) {
                    return;
                }
                OutputStream os = null;
                FileObject userDefinedResolverFO = null;
                FileObject resolversFolder = FileUtil.getConfigFile(MIMEResolverImpl.MIME_RESOLVERS_PATH);
                if (resolversFolder == null) {
                    resolversFolder = FileUtil.createFolder(FileUtil.getConfigRoot(), MIMEResolverImpl.MIME_RESOLVERS_PATH);
                }
                userDefinedResolverFO = resolversFolder.createData(MIMEResolverImpl.USER_DEFINED_MIME_RESOLVER, "xml");
                userDefinedResolverFO.setAttribute(MIMEResolverImpl.USER_DEFINED_MIME_RESOLVER, Boolean.TRUE);
                userDefinedResolverFO.setAttribute("position", 10);
                os = userDefinedResolverFO.getOutputStream();
                XMLUtil.write((Document)document, (OutputStream)os, (String)"UTF-8");
                if (os == null) return;
                try {
                    os.close();
                    return;
                }
                catch (IOException e) {
                    ERR.log(Level.SEVERE, "Cannot close OutputStream of file " + (userDefinedResolverFO == null ? "" : FileUtil.toFile(userDefinedResolverFO)), e);
                }
                return;
                catch (IOException e) {
                    try {
                        ERR.log(Level.SEVERE, "Cannot write resolver " + (userDefinedResolverFO == null ? "" : FileUtil.toFile(userDefinedResolverFO)), e);
                        if (os == null) return;
                    }
                    catch (Throwable throwable) {
                        if (os == null) throw throwable;
                        try {
                            os.close();
                            throw throwable;
                        }
                        catch (IOException e2) {
                            ERR.log(Level.SEVERE, "Cannot close OutputStream of file " + (userDefinedResolverFO == null ? "" : FileUtil.toFile(userDefinedResolverFO)), e2);
                        }
                        throw throwable;
                    }
                    try {
                        os.close();
                        return;
                    }
                    catch (IOException e3) {
                        ERR.log(Level.SEVERE, "Cannot close OutputStream of file " + (userDefinedResolverFO == null ? "" : FileUtil.toFile(userDefinedResolverFO)), e3);
                    }
                    return;
                }
            }
        });
    }

    public static Collection<? extends FileObject> getOrderedResolvers() {
        FileObject[] resolvers = FileUtil.getConfigFile(MIME_RESOLVERS_PATH).getChildren();
        TreeMap orderedResolvers = new TreeMap(Collections.reverseOrder());
        for (FileObject mimeResolverFO : resolvers) {
            Integer position = (Integer)mimeResolverFO.getAttribute("position");
            if (position == null) {
                position = Integer.MAX_VALUE;
            }
            while (orderedResolvers.containsKey(position)) {
                Integer n = position;
                Integer n2 = position = Integer.valueOf(position - 1);
            }
            orderedResolvers.put(position, mimeResolverFO);
        }
        return orderedResolvers.values();
    }

    private static class Type {
        private String[] exts;
        private static final String EMPTY_EXTENSION = "";
        private String[] mimes;
        private String[] fatts;
        private List<FilePattern> patterns;
        private FilePattern lastAddedPattern = null;
        private List<FileName> names;
        private String[] vals;
        private byte[] magic;
        private byte[] mask;
        private boolean exit = false;

        Type() {
        }

        public String toString() {
            int i = 0;
            StringBuffer buf = new StringBuffer();
            buf.append("fast-check(");
            if (this.exts != null) {
                buf.append("exts:");
                for (i = 0; i < this.exts.length; ++i) {
                    buf.append(this.exts[i]).append(", ");
                }
            }
            if (this.mimes != null) {
                buf.append("mimes:");
                for (i = 0; i < this.mimes.length; ++i) {
                    buf.append(this.mimes[i]).append(", ");
                }
            }
            if (this.fatts != null) {
                buf.append("file-attributes:");
                for (i = 0; i < this.fatts.length; ++i) {
                    buf.append(this.fatts[i]).append("='").append(this.vals[i]).append("', ");
                }
            }
            if (this.patterns != null) {
                buf.append("patterns:");
                for (FilePattern pattern : this.patterns) {
                    buf.append(pattern.toString()).append(", ");
                }
            }
            if (this.names != null) {
                buf.append("names:");
                for (FileName name : this.names) {
                    buf.append(name.toString()).append(", ");
                }
            }
            if (this.magic != null) {
                buf.append("magic:").append(XMLUtil.toHex((byte[])this.magic, (int)0, (int)this.magic.length));
            }
            if (this.mask != null) {
                buf.append("mask:").append(XMLUtil.toHex((byte[])this.mask, (int)0, (int)this.mask.length));
            }
            buf.append(')');
            return buf.toString();
        }

        private void addExt(String ext) {
            this.exts = Util.addString(this.exts, ext);
        }

        private void addMIME(String mime) {
            this.mimes = Util.addString(this.mimes, mime.toLowerCase());
        }

        private void addAttr(String name, String value) {
            this.fatts = Util.addString(this.fatts, name);
            this.vals = Util.addString(this.vals, value);
        }

        private void addPattern(String value, int range, boolean ignoreCase) {
            if (this.patterns == null) {
                this.patterns = new ArrayList<FilePattern>();
            }
            this.lastAddedPattern = new FilePattern(value, range, ignoreCase);
            this.patterns.add(this.lastAddedPattern);
        }

        private void addInnerPattern(String value, int range, boolean ignoreCase) {
            FilePattern inner = new FilePattern(value, range, ignoreCase);
            this.lastAddedPattern.setInner(inner);
            this.lastAddedPattern = inner;
        }

        private void addName(String name, boolean substring, boolean ignoreCase) {
            if (this.names == null) {
                this.names = new ArrayList<FileName>();
            }
            this.names.add(new FileName(name, substring, ignoreCase));
        }

        private boolean setMagic(byte[] magic, byte[] mask) {
            if (magic == null) {
                return true;
            }
            if (mask != null && magic.length != mask.length) {
                return false;
            }
            this.magic = magic;
            if (mask != null) {
                this.mask = mask;
                for (int i = 0; i < mask.length; ++i) {
                    int n = i;
                    this.magic[n] = (byte)(this.magic[n] & mask[i]);
                }
            }
            return true;
        }

        private void setExit() {
            this.exit = true;
        }

        private static String getMIMEType(String extension) {
            return FileUtil.getMIMEType(extension);
        }

        private static void handleIOException(FileObject fo, IOException ioe) throws IOException {
            if (!(!fo.canRead() || Utilities.isWindows() && ioe instanceof FileNotFoundException && fo.isValid() && fo.getName().toLowerCase().contains("ntuser"))) {
                throw ioe;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean accept(FileObject fo) throws IOException {
            if (this.exts != null) {
                String ext = fo.getExt();
                if (ext == null) {
                    ext = EMPTY_EXTENSION;
                }
                if (!Util.contains(this.exts, ext, CASE_INSENSITIVE)) {
                    return false;
                }
            }
            if (this.mimes != null) {
                boolean match = false;
                String s = Type.getMIMEType(fo.getExt());
                if (s == null) {
                    return false;
                }
                int l = s.indexOf(59);
                if (l >= 0) {
                    s = s.substring(0, l);
                }
                s = s.toLowerCase();
                for (int i = this.mimes.length - 1; i >= 0; --i) {
                    if (s.equals(this.mimes[i])) {
                        match = true;
                        break;
                    }
                    if (this.mimes[i].length() <= 0 || this.mimes[i].charAt(0) != '+' || !s.endsWith(this.mimes[i])) continue;
                    match = true;
                    break;
                }
                if (!match) {
                    return false;
                }
            }
            if (this.magic != null) {
                boolean bl;
                byte[] header = new byte[this.magic.length];
                InputStream in = null;
                try {
                    in = fo.getInputStream();
                    int read = in.read(header);
                    if (read < 0) {
                        bl = false;
                        return bl;
                    }
                }
                catch (IOException openex) {
                    Type.handleIOException(fo, openex);
                    bl = false;
                    return bl;
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException ioe) {}
                }
                for (int i = 0; i < this.magic.length; ++i) {
                    if (this.mask != null) {
                        int n = i;
                        header[n] = (byte)(header[n] & this.mask[i]);
                    }
                    if (this.magic[i] == header[i]) continue;
                    return false;
                }
            }
            if (this.fatts != null) {
                for (int i = this.fatts.length - 1; i >= 0; --i) {
                    Object attr = fo.getAttribute(this.fatts[i]);
                    if (attr == null || attr.toString().equals(this.vals[i]) || this.vals[i] == null) continue;
                    return false;
                }
            }
            if (this.patterns != null) {
                try {
                    boolean matched = false;
                    for (FilePattern pattern : this.patterns) {
                        if (!pattern.match(fo)) continue;
                        matched = true;
                        break;
                    }
                    if (!matched) {
                        return false;
                    }
                }
                catch (IOException ioe) {
                    Type.handleIOException(fo, ioe);
                    return false;
                }
            }
            if (this.names != null) {
                boolean matched = false;
                for (FileName name : this.names) {
                    if (!name.match(fo)) continue;
                    matched = true;
                    break;
                }
                if (!matched) {
                    return false;
                }
            }
            return true;
        }

        private class FileName {
            private static final boolean DEFAULT_IGNORE_CASE = true;
            private static final boolean DEFAULT_SUBSTRING = false;
            private final String name;
            private final boolean substring;
            private final boolean ignoreCase;

            public FileName(String name, boolean substring, boolean ignoreCase) {
                this.name = ignoreCase ? name.toLowerCase() : name;
                this.substring = substring;
                this.ignoreCase = ignoreCase;
            }

            public boolean match(FileObject fo) {
                String nameAndExt = fo.getNameExt();
                if (this.ignoreCase) {
                    nameAndExt = nameAndExt.toLowerCase();
                }
                if (this.substring) {
                    return nameAndExt.contains(this.name);
                }
                return nameAndExt.equals(this.name);
            }

            public String toString() {
                return "[" + this.name + ", " + this.substring + ", " + this.ignoreCase + "]";
            }
        }

        private class FilePattern {
            private static final boolean DEFAULT_IGNORE_CASE = false;
            private final String value;
            private final int range;
            private final boolean ignoreCase;
            private FilePattern inner;
            private final byte[] bytes;
            private final int valueLength;

            public FilePattern(String value, int range, boolean ignoreCase) {
                this.value = value;
                this.valueLength = value.length();
                this.bytes = ignoreCase ? value.toLowerCase().getBytes() : value.getBytes();
                this.range = range;
                this.ignoreCase = ignoreCase;
            }

            public void setInner(FilePattern inner) {
                this.inner = inner;
            }

            private boolean match(byte b, AtomicInteger pointer) {
                if (b == this.bytes[pointer.get()]) {
                    return pointer.incrementAndGet() >= this.valueLength;
                }
                pointer.set(0);
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean match(FileObject fo) throws IOException {
                InputStream is = null;
                boolean matched = false;
                try {
                    is = fo.getInputStream();
                    byte[] byteRange = new byte[this.range];
                    int read = is.read(byteRange);
                    AtomicInteger pointer = new AtomicInteger(0);
                    for (int i = 0; i < read; ++i) {
                        byte b = byteRange[i];
                        if (this.ignoreCase) {
                            b = (byte)Character.toLowerCase(b);
                        }
                        if (!this.match(b, pointer)) continue;
                        matched = true;
                        break;
                    }
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException ioe) {}
                }
                if (matched) {
                    if (this.inner == null) {
                        return true;
                    }
                    return this.inner.match(fo);
                }
                return false;
            }

            public String toString() {
                return "[" + this.value + ", " + this.range + ", " + this.ignoreCase + (this.inner != null ? ", " + this.inner : Type.EMPTY_EXTENSION) + "]";
            }
        }
    }

    private static class FileElement {
        private Type fileCheck = new Type();
        private String mime = null;
        private MIMEComponent rule = null;
        private static final String EXIT_MIME_TYPE = "mime-type-to-exit";

        FileElement() {
        }

        private String[] getExtensions() {
            return this.fileCheck.exts;
        }

        private String getMimeType() {
            return this.mime;
        }

        private boolean isExit() {
            return this.fileCheck.exit;
        }

        private void setMIME(String mime) {
            if ("null".equals(mime)) {
                return;
            }
            this.mime = mime;
        }

        private String resolve(FileObject file) {
            try {
                if (this.fileCheck.accept(file)) {
                    if (this.rule != null && !this.rule.acceptFileObject(file)) {
                        return null;
                    }
                    if (this.isExit() || this.mime == null) {
                        return EXIT_MIME_TYPE;
                    }
                    return this.mime;
                }
            }
            catch (IOException io) {
                Logger.getLogger(MIMEResolverImpl.class.getName()).log(Level.INFO, null, io);
            }
            return null;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("FileElement(");
            buf.append(this.fileCheck).append(' ');
            buf.append(this.rule).append(' ');
            buf.append("Result:").append(this.mime);
            return buf.toString();
        }
    }

    private static class DescParser
    extends DefaultParser {
        private FileElement[] template = null;
        private short file_state = 0;
        private MIMEComponent component = null;
        private String componentDelimiter = null;
        private int patternLevel = 0;
        Set<Integer> patternLevelSet;
        private static final short IN_ROOT = 1;
        private static final short IN_FILE = 2;
        private static final short IN_RESOLVER = 3;
        private static final short IN_COMPONENT = 4;
        private static final short IN_PATTERN = 5;
        private static final short IN_EXIT = 1;
        private static final String ROOT = "MIME-resolver";
        private static final String FILE = "file";
        private static final String MIME = "mime";
        private static final String EXT = "ext";
        private static final String RESOLVER = "resolver";
        private static final String FATTR = "fattr";
        private static final String NAME = "name";
        private static final String PATTERN = "pattern";
        private static final String VALUE = "value";
        private static final String RANGE = "range";
        private static final String IGNORE_CASE = "ignorecase";
        private static final String SUBSTRING = "substring";
        private static final String MAGIC = "magic";
        private static final String HEX = "hex";
        private static final String MASK = "mask";
        private static final String TEXT = "text";
        private static final String EXIT = "exit";
        private static final String XML_RULE_COMPONENT = "xml-rule";

        DescParser(FileObject fo) {
            super(fo);
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            switch (this.state) {
                case 0: {
                    if (!ROOT.equals(qName)) {
                        this.error();
                    }
                    this.state = 1;
                    break;
                }
                case 1: {
                    if (!FILE.equals(qName)) {
                        this.error();
                    }
                    if (this.template == null) {
                        this.template = new FileElement[]{new FileElement()};
                    } else {
                        FileElement[] n = new FileElement[this.template.length + 1];
                        System.arraycopy(this.template, 0, n, 1, this.template.length);
                        n[0] = new FileElement();
                        this.template = n;
                    }
                    this.state = (short)2;
                    break;
                }
                case 2: {
                    if (this.file_state == 1) {
                        this.error();
                    }
                    if (EXT.equals(qName)) {
                        String s = atts.getValue(NAME);
                        if (s == null) {
                            this.error();
                        }
                        this.template[0].fileCheck.addExt(s);
                        break;
                    }
                    if (MAGIC.equals(qName)) {
                        String s = atts.getValue(HEX);
                        if (s == null) {
                            this.error();
                        }
                        String mask = atts.getValue(MASK);
                        char[] chars = s.toCharArray();
                        byte[] mask_bytes = null;
                        try {
                            if (mask != null) {
                                char[] mask_chars = mask.toCharArray();
                                mask_bytes = XMLUtil.fromHex((char[])mask_chars, (int)0, (int)mask_chars.length);
                            }
                            byte[] magic = XMLUtil.fromHex((char[])chars, (int)0, (int)chars.length);
                            if (this.template[0].fileCheck.setMagic(magic, mask_bytes)) break;
                            this.error();
                        }
                        catch (IOException ioex) {
                            this.error();
                        }
                        break;
                    }
                    if (MIME.equals(qName)) {
                        String s = atts.getValue(NAME);
                        if (s == null) {
                            this.error();
                        }
                        this.template[0].fileCheck.addMIME(s);
                        break;
                    }
                    if (FATTR.equals(qName)) {
                        String s = atts.getValue(NAME);
                        if (s == null) {
                            this.error();
                        }
                        String val = atts.getValue(TEXT);
                        this.template[0].fileCheck.addAttr(s, val);
                        break;
                    }
                    if (PATTERN.equals(qName)) {
                        String s = atts.getValue(VALUE);
                        if (s == null) {
                            this.error();
                        }
                        int range = Integer.valueOf(atts.getValue(RANGE));
                        assert (range <= 4000 || !readLimitReported.add(this.fo.getPath())) : "MIME resolver " + this.fo.getPath() + " should not exceed " + 4000 + " bytes limit for files content check.";
                        boolean ignoreCase = false;
                        String ignoreCaseAttr = atts.getValue(IGNORE_CASE);
                        if (ignoreCaseAttr != null) {
                            ignoreCase = Boolean.valueOf(ignoreCaseAttr);
                        }
                        if (this.file_state == 5) {
                            if (this.patternLevelSet == null) {
                                this.patternLevelSet = new HashSet<Integer>();
                            }
                            if (!this.patternLevelSet.add(this.patternLevel)) {
                                this.error("Second pattern element on the same level not allowed");
                            }
                            this.template[0].fileCheck.addInnerPattern(s, range, ignoreCase);
                        } else {
                            this.template[0].fileCheck.addPattern(s, range, ignoreCase);
                            this.file_state = (short)5;
                        }
                        ++this.patternLevel;
                        break;
                    }
                    if (NAME.equals(qName)) {
                        String s = atts.getValue(NAME);
                        if (s == null) {
                            this.error();
                        }
                        String substringAttr = atts.getValue(SUBSTRING);
                        boolean substring = false;
                        if (substringAttr != null) {
                            substring = Boolean.valueOf(substringAttr);
                        }
                        boolean ignoreCase = true;
                        String ignoreCaseAttr = atts.getValue(IGNORE_CASE);
                        if (ignoreCaseAttr != null) {
                            ignoreCase = Boolean.valueOf(ignoreCaseAttr);
                        }
                        this.template[0].fileCheck.addName(s, substring, ignoreCase);
                        break;
                    }
                    if (RESOLVER.equals(qName)) {
                        String s;
                        if (this.template[0].fileCheck.exts == null && this.template[0].fileCheck.mimes == null && this.template[0].fileCheck.fatts == null && this.template[0].fileCheck.patterns == null && this.template[0].fileCheck.names == null && this.template[0].fileCheck.magic == null) {
                            this.error();
                        }
                        if ((s = atts.getValue(MIME)) == null) {
                            this.error();
                        }
                        this.template[0].setMIME(s);
                        this.state = (short)3;
                        break;
                    }
                    if (EXIT.equals(qName)) {
                        this.template[0].fileCheck.setExit();
                        this.file_state = 1;
                        break;
                    }
                    String reason = "Unexpected element:  " + qName;
                    this.error(reason);
                    break;
                }
                case 3: {
                    if (!XML_RULE_COMPONENT.equals(qName)) break;
                    this.enterComponent(XML_RULE_COMPONENT, new XMLMIMEComponent());
                    this.component.startElement(namespaceURI, localName, qName, atts);
                    break;
                }
                case 4: {
                    this.component.startElement(namespaceURI, localName, qName, atts);
                    break;
                }
            }
        }

        private void enterComponent(String name, MIMEComponent component) {
            this.component = component;
            this.componentDelimiter = name;
            component.setDocumentLocator(this.getLocator());
            this.template[0].rule = component;
            this.state = (short)4;
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            switch (this.state) {
                case 2: {
                    if (FILE.equals(qName)) {
                        this.state = 1;
                        this.file_state = 0;
                    }
                    if (!PATTERN.equals(qName) || --this.patternLevel != 0) break;
                    this.patternLevelSet = null;
                    this.file_state = 0;
                    break;
                }
                case 3: {
                    if (!RESOLVER.equals(qName)) break;
                    this.state = (short)2;
                    break;
                }
                case 4: {
                    this.component.endElement(namespaceURI, localName, qName);
                    if (!this.componentDelimiter.equals(qName)) break;
                    this.state = (short)3;
                    this.component.setDocumentLocator(null);
                }
            }
        }

        @Override
        public void characters(char[] data, int offset, int len) throws SAXException {
            if (this.state == 4) {
                this.component.characters(data, offset, len);
            }
        }
    }

    private static class Impl
    extends MIMEResolver {
        private final FileObject data;
        private final FileChangeListener listener = new FileChangeAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void fileChanged(FileEvent fe) {
                Impl impl = Impl.this;
                synchronized (impl) {
                    Impl.this.state = (short)0;
                    Impl.access$102(Impl.this, null);
                }
            }
        };
        private FileElement[] smell = null;
        private short state = 0;
        private String[] implResolvableMIMETypes = null;

        Impl(FileObject obj) {
            if (ERR.isLoggable(Level.FINE)) {
                ERR.fine("MIMEResolverImpl.Impl.<init>(" + obj + ")");
            }
            this.data = obj;
            this.data.addFileChangeListener(FileUtil.weakFileChangeListener(this.listener, this.data));
        }

        @Override
        public String findMIMEType(FileObject fo) {
            if (fo.hasExt("xml") && fo.getPath().startsWith(MIMEResolverImpl.MIME_RESOLVERS_PATH)) {
                return null;
            }
            this.init();
            if (this.state == -1) {
                return null;
            }
            FileElement[] smell2 = this.smell;
            for (int i = smell2.length - 1; i >= 0; --i) {
                String s;
                if (ERR.isLoggable(Level.FINE)) {
                    ERR.fine("findMIMEType - smell.resolve.");
                }
                if ((s = smell2[i].resolve(fo)) == null) continue;
                if (s.equals("mime-type-to-exit")) {
                    return null;
                }
                if (ERR.isLoggable(Level.FINE)) {
                    ERR.fine("MIMEResolverImpl.findMIMEType(" + fo + ")=" + s);
                }
                return s;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init() {
            Impl impl = this;
            synchronized (impl) {
                if (this.state == 0) {
                    this.state = this.parseDesc();
                }
            }
        }

        private short parseDesc() {
            this.smell = new FileElement[0];
            DescParser parser = new DescParser(this.data);
            parser.parse();
            FileElement[] fileElementArray = this.smell = parser.template != null ? parser.template : this.smell;
            if (ERR.isLoggable(Level.FINE)) {
                if (parser.state == -1) {
                    ERR.fine("MIMEResolverImpl.Impl parsing error!");
                } else {
                    StringBuffer buf = new StringBuffer();
                    buf.append("Parse: ");
                    for (int i = 0; i < this.smell.length; ++i) {
                        buf.append('\n').append(this.smell[i]);
                    }
                    ERR.fine(buf.toString());
                }
            }
            if (parser.state != -1) {
                for (int i = 0; i < this.smell.length; ++i) {
                    String mimeType = this.smell[i].getMimeType();
                    if (mimeType == null) continue;
                    this.implResolvableMIMETypes = Util.addString(this.implResolvableMIMETypes, mimeType);
                }
            }
            return parser.state;
        }

        public String toString() {
            return "MIMEResolverImpl.Impl[" + this.data.getPath() + "]";
        }

        static /* synthetic */ String[] access$102(Impl x0, String[] x1) {
            x0.implResolvableMIMETypes = x1;
            return x1;
        }
    }
}

