/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project.libraries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.project.libraries.LibraryAccessor;
import org.netbeans.modules.project.libraries.Util;
import org.netbeans.modules.project.libraries.ui.LibrariesModel;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryImplementation2;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public final class Library {
    public static final String PROP_NAME = "name";
    public static final String PROP_DESCRIPTION = "description";
    public static final String PROP_CONTENT = "content";
    private static final Logger LOG = Logger.getLogger(Library.class.getName());
    private LibraryImplementation impl;
    private List<PropertyChangeListener> listeners;
    private final LibraryManager manager;
    private final PropertyChangeListener listener;

    Library(LibraryImplementation impl, LibraryManager manager) {
        this.impl = impl;
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propName = evt.getPropertyName();
                Library.this.fireChange(propName, evt.getOldValue(), evt.getNewValue());
            }
        };
        this.impl.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)this.impl));
        this.manager = manager;
    }

    public LibraryManager getManager() {
        return this.manager;
    }

    public List<URL> getContent(String volumeType) {
        return this.impl.getContent(volumeType);
    }

    public List<URI> getURIContent(String volumeType) {
        if (this.impl instanceof LibraryImplementation2) {
            return ((LibraryImplementation2)this.impl).getURIContent(volumeType);
        }
        return LibrariesModel.convertURLsToURIs(this.impl.getContent(volumeType));
    }

    public String getName() {
        return this.impl.getName();
    }

    public String getDescription() {
        return this.getLocalizedString(this.impl.getLocalizingBundle(), this.impl.getDescription());
    }

    public String getDisplayName() {
        return Util.getLocalizedName(this.impl);
    }

    public String getType() {
        return this.impl.getType();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Library) {
            Library peer = (Library)obj;
            return peer.impl.equals(this.impl);
        }
        return false;
    }

    public int hashCode() {
        return this.impl.hashCode();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<PropertyChangeListener>();
        }
        this.listeners.add(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    LibraryImplementation getLibraryImplementation() {
        return this.impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange(String propertyName, Object oldValue, Object newValue) {
        ArrayList<PropertyChangeListener> ls;
        Library library = this;
        synchronized (library) {
            if (this.listeners == null) {
                return;
            }
            ls = new ArrayList<PropertyChangeListener>(this.listeners);
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        for (PropertyChangeListener l : ls) {
            l.propertyChange(event);
        }
    }

    private String getLocalizedString(String bundleName, String key) {
        ResourceBundle bundle;
        if (key == null) {
            return null;
        }
        if (bundleName == null) {
            return key;
        }
        try {
            bundle = NbBundle.getBundle((String)bundleName);
        }
        catch (MissingResourceException mre) {
            LOG.warning("No such bundle " + bundleName + " for " + this.getName());
            return key;
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException mre) {
            LOG.warning("No such key " + key + " in " + bundleName + " for " + this.getName());
            return key;
        }
    }

    public String toString() {
        return "Library[" + this.getName() + "]";
    }

    static {
        LibraryAccessor.setInstance(new LibraryAccessor(){

            @Override
            public Library createLibrary(LibraryImplementation impl) {
                return new Library(impl, LibraryManager.getDefault());
            }
        });
    }
}

