/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.embedder.exec;

import java.util.Stack;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.resource.Resource;
import org.netbeans.api.progress.aggregate.AggregateProgressFactory;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.openide.util.NbBundle;

public class ProgressTransferListener
implements TransferListener {
    private static ThreadLocal<Integer> lengthRef = new ThreadLocal();
    private static ThreadLocal<Integer> countRef = new ThreadLocal();
    private static ThreadLocal<ProgressContributor> contribRef = new ThreadLocal();
    private static ThreadLocal<ProgressContributor> pomcontribRef = new ThreadLocal();
    private static ThreadLocal<Integer> pomCountRef = new ThreadLocal();
    private static ThreadLocal<Stack<ProgressContributor>> contribStackRef = new ThreadLocal();
    private static ThreadLocal<AggregateProgressHandle> handleRef = new ThreadLocal();
    private static final int POM_MAX = 20;

    public static void setAggregateHandle(AggregateProgressHandle hndl) {
        handleRef.set(hndl);
        contribStackRef.set(new Stack());
        ProgressContributor pc = AggregateProgressFactory.createProgressContributor((String)"Pom files");
        hndl.addContributor(pc);
        pc.start(20);
        pomCountRef.set(new Integer(0));
        pomcontribRef.set(pc);
    }

    public static void clearAggregateHandle() {
        handleRef.remove();
        contribRef.remove();
        contribStackRef.remove();
        pomcontribRef.remove();
        pomCountRef.remove();
    }

    private String getResourceName(Resource res) {
        int lastSlash = res.getName().lastIndexOf("/");
        return lastSlash > -1 ? res.getName().substring(lastSlash + 1) : res.getName();
    }

    public void transferInitiated(TransferEvent transferEvent) {
        if (handleRef.get() == null || contribStackRef.get() == null) {
            return;
        }
        assert (handleRef.get() != null);
        assert (contribStackRef.get() != null);
        Resource res = transferEvent.getResource();
        String resName = this.getResourceName(res);
        if (!resName.endsWith(".pom")) {
            ProgressContributor pc;
            Stack<ProgressContributor> stack = contribStackRef.get();
            ProgressContributor progressContributor = pc = stack != null && !stack.empty() ? stack.pop() : null;
            if (pc == null) {
                String name = transferEvent.getRequestType() == 5 ? NbBundle.getMessage(ProgressTransferListener.class, (String)"TXT_Download", (Object)resName) : NbBundle.getMessage(ProgressTransferListener.class, (String)"TXT_Uploading", (Object)resName);
                pc = AggregateProgressFactory.createProgressContributor((String)name);
                handleRef.get().addContributor(pc);
            }
            contribRef.set(pc);
        } else {
            String name = transferEvent.getRequestType() == 5 ? NbBundle.getMessage(ProgressTransferListener.class, (String)"TXT_Download", (Object)resName) : NbBundle.getMessage(ProgressTransferListener.class, (String)"TXT_Uploading", (Object)resName);
            ProgressContributor pc = AggregateProgressFactory.createProgressContributor((String)name);
            contribStackRef.get().add(pc);
            handleRef.get().addContributor(pc);
            int count = pomCountRef.get();
            if (count < 19) {
                pomcontribRef.get().progress(NbBundle.getMessage(ProgressTransferListener.class, (String)"TXT_Started", (Object)resName), ++count);
                pomCountRef.set(new Integer(count));
            } else {
                pomcontribRef.get().progress(NbBundle.getMessage(ProgressTransferListener.class, (String)"TXT_Started", (Object)resName));
            }
        }
    }

    public void transferStarted(TransferEvent transferEvent) {
        if (contribRef.get() == null || handleRef.get() == null) {
            return;
        }
        Resource res = transferEvent.getResource();
        int total = (int)Math.min(Integer.MAX_VALUE, res.getContentLength());
        if (total < 0) {
            contribRef.get().start(0);
        } else {
            contribRef.get().start(total);
        }
        lengthRef.set(total);
        countRef.set(0);
        contribRef.get().progress(NbBundle.getMessage(ProgressTransferListener.class, (String)"TXT_Started", (Object)this.getResourceName(res)));
    }

    public void transferProgress(TransferEvent transferEvent, byte[] b, int i) {
        if (contribRef.get() == null) {
            return;
        }
        long cnt = countRef.get().intValue();
        if (i > 0) {
            cnt += (long)i;
        }
        cnt = Math.min(Integer.MAX_VALUE, cnt);
        if (lengthRef.get() < 0) {
            contribRef.get().progress(NbBundle.getMessage(ProgressTransferListener.class, (String)"TXT_Transferring", (Object)this.getResourceName(transferEvent.getResource())));
        } else {
            cnt = Math.min(cnt, (long)lengthRef.get().intValue());
            contribRef.get().progress(NbBundle.getMessage(ProgressTransferListener.class, (String)"TXT_Transferred", (Object)this.getResourceName(transferEvent.getResource()), (Object)cnt), (int)cnt);
        }
        countRef.set((int)cnt);
    }

    public void transferCompleted(TransferEvent transferEvent) {
        if (contribRef.get() == null) {
            return;
        }
        contribRef.get().finish();
        contribRef.remove();
    }

    public void transferError(TransferEvent transferEvent) {
        this.transferCompleted(transferEvent);
    }

    public void debug(String string) {
    }
}

