/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import org.netbeans.lib.lexer.EmbeddedJoinInfo;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.TokenListList;

public final class JoinTokenListBase {
    private static final int INDEX_GAP_LENGTH_INITIAL_SIZE = 0x3FFFFFFF;
    int tokenListCount;
    int joinTokenCount;
    int indexGapsIndex;
    int joinTokenIndexGapLength = 0x3FFFFFFF;
    int tokenListIndexGapLength = 0x3FFFFFFF;
    int extraModCount;

    public JoinTokenListBase(int tokenListCount) {
        this.tokenListCount = tokenListCount;
        this.indexGapsIndex = tokenListCount;
    }

    int joinTokenIndex(int rawJoinTokenIndex) {
        return rawJoinTokenIndex < this.joinTokenIndexGapLength ? rawJoinTokenIndex : rawJoinTokenIndex - this.joinTokenIndexGapLength;
    }

    int tokenListIndex(int rawTokenListIndex) {
        return rawTokenListIndex < this.tokenListIndexGapLength ? rawTokenListIndex : rawTokenListIndex - this.tokenListIndexGapLength;
    }

    public void moveIndexGap(TokenListList<?> tokenListList, int tokenListStartIndex, int index) {
        if (index < this.indexGapsIndex) {
            int i = index;
            do {
                EmbeddedJoinInfo joinInfo = ((EmbeddedTokenList)tokenListList.get((int)(tokenListStartIndex + i++))).joinInfo;
                joinInfo.rawTokenListIndex += this.tokenListIndexGapLength;
                joinInfo.rawJoinTokenIndex += this.joinTokenIndexGapLength;
            } while (i < this.indexGapsIndex);
            this.indexGapsIndex = index;
        } else if (index > this.indexGapsIndex) {
            int i = index;
            do {
                EmbeddedJoinInfo joinInfo = ((EmbeddedTokenList)tokenListList.get((int)(tokenListStartIndex + --i))).joinInfo;
                joinInfo.rawTokenListIndex -= this.tokenListIndexGapLength;
                joinInfo.rawJoinTokenIndex -= this.joinTokenIndexGapLength;
            } while (i > this.indexGapsIndex);
            this.indexGapsIndex = index;
        }
    }

    public void tokenListModNotify(int tokenListCountDiff) {
        this.indexGapsIndex += tokenListCountDiff;
        this.tokenListCount += tokenListCountDiff;
        this.tokenListIndexGapLength -= tokenListCountDiff;
    }

    public int joinTokenCount() {
        return this.joinTokenCount;
    }

    public void updateJoinTokenCount(int joinTokenCountDiff) {
        this.joinTokenCount += joinTokenCountDiff;
        this.joinTokenIndexGapLength -= joinTokenCountDiff;
    }

    public void incrementExtraModCount() {
        ++this.extraModCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(70);
        sb.append("tokenListCount=").append(this.tokenListCount);
        sb.append(", tokenCount=").append(this.joinTokenCount);
        sb.append(", indexGapsIndex=").append(this.indexGapsIndex);
        return sb.toString();
    }
}

