/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.io.IOException;
import java.net.URL;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import org.netbeans.modules.javahelp.Installer;
import org.netbeans.modules.javahelp.NbDocsStreamHandler;
import org.openide.cookies.InstanceCookie;
import org.openide.loaders.XMLDataObject;
import org.openide.util.Lookup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class HelpSetProcessor
implements XMLDataObject.Processor,
InstanceCookie.Of {
    public static final String HELPSET_MERGE_CONTEXT = "OpenIDE";
    public static final String HELPSET_MERGE_ATTR = "mergeIntoMaster";
    private XMLDataObject xml;
    private HelpSet hs;

    public void attachTo(XMLDataObject xml) {
        if (this.xml == xml) {
            return;
        }
        this.hs = null;
        this.xml = xml;
        Installer.log.fine("processing help set ref: " + xml.getPrimaryFile());
    }

    public Class instanceClass() throws IOException, ClassNotFoundException {
        return HelpSet.class;
    }

    public String instanceName() {
        return "javax.help.HelpSet";
    }

    public boolean instanceOf(Class type) {
        return type == HelpSet.class;
    }

    public synchronized Object instanceCreate() throws IOException, ClassNotFoundException {
        if (this.hs == null) {
            Installer.log.fine("creating help set from ref: " + this.xml.getPrimaryFile());
            try {
                Document doc = this.xml.getDocument();
                Element el = doc.getDocumentElement();
                if (!el.getNodeName().equals("helpsetref")) {
                    throw new IOException();
                }
                String url = el.getAttribute("url");
                if (url == null || url.equals("")) {
                    throw new IOException("no url attr on <helpsetref>! doc.class=" + doc.getClass().getName() + " doc.documentElement=" + el);
                }
                String mergeS = el.getAttribute("merge");
                boolean merge = mergeS == null || mergeS.equals("") || Boolean.valueOf(mergeS) != false;
                Class<NbDocsStreamHandler> ignore = NbDocsStreamHandler.class;
                this.hs = new HelpSet((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class), new URL(url));
                this.hs.setKeyData((Object)HELPSET_MERGE_CONTEXT, HELPSET_MERGE_ATTR, (Object)(merge ? Boolean.TRUE : Boolean.FALSE));
            }
            catch (SAXException saxe) {
                throw (IOException)new IOException(saxe.toString()).initCause(saxe);
            }
            catch (HelpSetException hse) {
                throw (IOException)new IOException(hse.toString()).initCause(hse);
            }
        }
        return this.hs;
    }
}

