/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source;

import com.sun.tools.javac.code.Symbol;
import java.awt.EventQueue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.RequestProcessor;

public class JavadocHelper {
    private static final Logger LOG = Logger.getLogger(JavadocHelper.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(JavadocHelper.class.getName(), 1);
    private static final Map<Element, TextStream> cachedJavadoc = new WeakHashMap<Element, TextStream>();
    private static final String PACKAGE_SUMMARY = "package-summary";
    private static final Set<String> knownGoodRoots = Collections.synchronizedSet(new HashSet());

    private JavadocHelper() {
    }

    private static boolean isRemote(URL url) {
        return url.getProtocol().startsWith("http");
    }

    public static InputStream openStream(URL url) throws IOException {
        FileObject f;
        if (url.getProtocol().equals("jar") && (f = URLMapper.findFileObject((URL)url)) != null) {
            return f.getInputStream();
        }
        if (url.getProtocol().startsWith("http")) {
            LOG.log(Level.FINE, "opening network stream: {0}", url);
        }
        return url.openStream();
    }

    public static TextStream getJavadoc(Element element, @NullAllowed Callable<Boolean> cancel) {
        return JavadocHelper.getJavadoc(element, true, cancel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TextStream getJavadoc(Element element, boolean allowRemoteJavadoc, @NullAllowed Callable<Boolean> cancel) {
        Map<Element, TextStream> map = cachedJavadoc;
        synchronized (map) {
            TextStream result = cachedJavadoc.get(element);
            if (result != null) {
                LOG.log(Level.FINE, "cache hit on {0}", result.getLocation());
                return result;
            }
        }
        TextStream result = JavadocHelper.doGetJavadoc(element, allowRemoteJavadoc, cancel);
        Map<Element, TextStream> map2 = cachedJavadoc;
        synchronized (map2) {
            cachedJavadoc.put(element, result);
        }
        return result;
    }

    public static TextStream getJavadoc(Element element) {
        return JavadocHelper.getJavadoc(element, null);
    }

    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"})
    private static TextStream doGetJavadoc(Element element, final boolean allowRemoteJavadoc, Callable<Boolean> cancel) {
        String pageName;
        String pkgName;
        if (element == null) {
            throw new IllegalArgumentException("Cannot pass null as an argument of the SourceUtils.getJavadoc");
        }
        Symbol.ClassSymbol clsSym = null;
        boolean buildFragment = false;
        if (element.getKind() == ElementKind.PACKAGE) {
            List<? extends Element> els = element.getEnclosedElements();
            for (Element element2 : els) {
                if (!element2.getKind().isClass() && !element2.getKind().isInterface()) continue;
                clsSym = (Symbol.ClassSymbol)element2;
                break;
            }
            if (clsSym == null) {
                return null;
            }
            pkgName = FileObjects.convertPackage2Folder(((PackageElement)element).getQualifiedName().toString());
            pageName = PACKAGE_SUMMARY;
        } else {
            Element e = element;
            StringBuilder sb = new StringBuilder();
            while (e.getKind() != ElementKind.PACKAGE) {
                if (e.getKind().isClass() || e.getKind().isInterface()) {
                    if (sb.length() > 0) {
                        sb.insert(0, '.');
                    }
                    sb.insert(0, e.getSimpleName());
                    if (clsSym == null) {
                        clsSym = (Symbol.ClassSymbol)e;
                    }
                }
                e = e.getEnclosingElement();
            }
            if (clsSym == null) {
                return null;
            }
            pkgName = FileObjects.convertPackage2Folder(((PackageElement)e).getQualifiedName().toString());
            pageName = sb.toString();
            boolean bl = buildFragment = element != clsSym;
        }
        if (clsSym.completer != null) {
            clsSym.complete();
        }
        if (clsSym.classfile != null) {
            try {
                CharSequence fragment;
                final URL classFile = clsSym.classfile.toUri().toURL();
                final String pkgNameF = pkgName;
                final String string = pageName;
                CharSequence charSequence = fragment = buildFragment ? JavadocHelper.getFragment(element) : null;
                if (cancel == null) {
                    return JavadocHelper.findJavadoc(classFile, pkgName, string, fragment, allowRemoteJavadoc);
                }
                Future future = RP.submit((Callable)new Callable<TextStream>(){

                    @Override
                    public TextStream call() throws Exception {
                        return JavadocHelper.findJavadoc(classFile, pkgNameF, string, fragment, allowRemoteJavadoc);
                    }
                });
                while (true) {
                    if (cancel != null && cancel.call().booleanValue()) {
                        future.cancel(false);
                        break;
                    }
                    try {
                        return (TextStream)future.get(100L, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException timeOut) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                LOG.log(Level.INFO, null, e);
            }
        }
        return null;
    }

    private static TextStream findJavadoc(URL classFile, String pkgName, String pageName, CharSequence fragment, boolean allowRemoteJavadoc) {
        URL sourceRoot = null;
        HashSet<URL> binaries = new HashSet<URL>();
        try {
            FileObject sourceFo;
            FileObject fo = URLMapper.findFileObject((URL)classFile);
            StringTokenizer tk = new StringTokenizer(pkgName, "/");
            for (int i = 0; fo != null && i <= tk.countTokens(); fo = fo.getParent(), ++i) {
            }
            if (fo != null) {
                URL url = fo.getURL();
                sourceRoot = JavaIndex.getSourceRootForClassFolder(url);
                if (sourceRoot == null) {
                    binaries.add(url);
                } else {
                    binaries.add(sourceRoot);
                }
            }
            if (sourceRoot != null && (sourceFo = URLMapper.findFileObject(sourceRoot)) != null) {
                ClassPath exec = ClassPath.getClassPath((FileObject)sourceFo, (String)"classpath/execute");
                ClassPath compile = ClassPath.getClassPath((FileObject)sourceFo, (String)"classpath/compile");
                ClassPath source = ClassPath.getClassPath((FileObject)sourceFo, (String)"classpath/source");
                if (exec == null) {
                    exec = compile;
                    compile = null;
                }
                if (exec != null && source != null) {
                    HashSet<URL> roots = new HashSet<URL>();
                    for (ClassPath.Entry e : exec.entries()) {
                        roots.add(e.getURL());
                    }
                    if (compile != null) {
                        for (ClassPath.Entry e : compile.entries()) {
                            roots.remove(e.getURL());
                        }
                    }
                    List<FileObject> sourceRoots = Arrays.asList(source.getRoots());
                    block12: for (URL e : roots) {
                        FileObject[] res;
                        for (FileObject r : res = SourceForBinaryQuery.findSourceRoots((URL)e).getRoots()) {
                            if (!sourceRoots.contains(r)) continue;
                            binaries.add(e);
                            continue block12;
                        }
                    }
                }
            }
            for (URL binary : binaries) {
                URL[] result;
                JavadocForBinaryQuery.Result javadocResult = JavadocForBinaryQuery.findJavadoc((URL)binary);
                for (URL root : result = javadocResult.getRoots()) {
                    InputStream is;
                    URL url;
                    block27: {
                        boolean useKnownGoodRoots;
                        if (!root.toExternalForm().endsWith("/")) {
                            LOG.log(Level.WARNING, "JavadocForBinaryQuery.Result: {0} returned non-folder URL: {1}, ignoring", new Object[]{javadocResult.getClass(), root.toExternalForm()});
                            continue;
                        }
                        if (!allowRemoteJavadoc && JavadocHelper.isRemote(root)) continue;
                        url = new URL(root, pkgName + "/" + pageName + ".html");
                        is = null;
                        String rootS = root.toString();
                        boolean bl = useKnownGoodRoots = result.length == 1 && JavadocHelper.isRemote(url);
                        if (useKnownGoodRoots && knownGoodRoots.contains(rootS)) {
                            LOG.log(Level.FINE, "assumed valid Javadoc stream at {0}", url);
                        } else {
                            try {
                                is = JavadocHelper.openStream(url);
                                if (!useKnownGoodRoots) break block27;
                                knownGoodRoots.add(rootS);
                                LOG.log(Level.FINE, "found valid Javadoc stream at {0}", url);
                            }
                            catch (IOException x) {
                                LOG.log(Level.FINE, "invalid Javadoc stream at {0}: {1}", new Object[]{url, x});
                                continue;
                            }
                        }
                    }
                    if (fragment != null && fragment.length() > 0) {
                        try {
                            String encodedfragment = URLEncoder.encode(((Object)fragment).toString(), "UTF-8");
                            encodedfragment = encodedfragment.replace("+", "%20");
                            return new TextStream(new URI(url.toExternalForm() + '#' + encodedfragment).toURL(), is);
                        }
                        catch (URISyntaxException x) {
                            LOG.log(Level.INFO, null, x);
                        }
                        catch (UnsupportedEncodingException x) {
                            LOG.log(Level.INFO, null, x);
                        }
                        catch (MalformedURLException x) {
                            LOG.log(Level.INFO, null, x);
                        }
                    }
                    return new TextStream(url, is);
                }
            }
        }
        catch (MalformedURLException x) {
            LOG.log(Level.INFO, null, x);
        }
        catch (FileStateInvalidException x) {
            LOG.log(Level.INFO, null, x);
        }
        return null;
    }

    private static CharSequence getFragment(Element e) {
        StringBuilder sb = new StringBuilder();
        if (!e.getKind().isClass() && !e.getKind().isInterface()) {
            if (e.getKind() == ElementKind.CONSTRUCTOR) {
                sb.append(e.getEnclosingElement().getSimpleName());
            } else {
                sb.append(e.getSimpleName());
            }
            if (e.getKind() == ElementKind.METHOD || e.getKind() == ElementKind.CONSTRUCTOR) {
                ExecutableElement ee = (ExecutableElement)e;
                sb.append('(');
                Iterator<? extends VariableElement> it = ee.getParameters().iterator();
                while (it.hasNext()) {
                    VariableElement param = it.next();
                    JavadocHelper.appendType(sb, param.asType(), ee.isVarArgs() && !it.hasNext());
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
                sb.append(')');
            }
        }
        return sb;
    }

    private static void appendType(StringBuilder sb, TypeMirror type, boolean varArg) {
        switch (type.getKind()) {
            case ARRAY: {
                JavadocHelper.appendType(sb, ((ArrayType)type).getComponentType(), false);
                sb.append(varArg ? "..." : "[]");
                break;
            }
            case DECLARED: {
                sb.append(((TypeElement)((DeclaredType)type).asElement()).getQualifiedName());
                break;
            }
            default: {
                sb.append(type);
            }
        }
    }

    public static final class TextStream {
        private final URL url;
        private final AtomicReference<InputStream> stream = new AtomicReference();
        private byte[] cache;

        public TextStream(URL url) {
            this.url = url;
        }

        TextStream(URL url, InputStream stream) {
            this(url);
            this.stream.set(stream);
        }

        public URL getLocation() {
            return this.url;
        }

        public void close() {
            InputStream is = this.stream.getAndSet(null);
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException x) {
                    LOG.log(Level.INFO, null, x);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized InputStream openStream() throws IOException {
            if (this.cache != null) {
                LOG.log(Level.FINE, "loaded cached content for {0}", this.url);
                return new ByteArrayInputStream(this.cache);
            }
            assert (!this.isRemote() || !EventQueue.isDispatchThread());
            InputStream uncached = this.stream.getAndSet(null);
            if (uncached == null) {
                uncached = JavadocHelper.openStream(this.url);
            }
            if (this.isRemote()) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(20480);
                    FileUtil.copy((InputStream)uncached, (OutputStream)baos);
                    this.cache = baos.toByteArray();
                }
                finally {
                    uncached.close();
                }
                LOG.log(Level.FINE, "cached content for {0} ({1}k)", new Object[]{this.url, this.cache.length / 1024});
                return new ByteArrayInputStream(this.cache);
            }
            return uncached;
        }

        public boolean isRemote() {
            return JavadocHelper.isRemote(this.url);
        }
    }
}

