/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.Dialog;
import java.io.IOException;
import java.util.concurrent.Callable;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.java.project.BrokenReferencesAlertPanel;
import org.netbeans.modules.java.project.BrokenReferencesCustomizer;
import org.netbeans.modules.java.project.BrokenReferencesModel;
import org.netbeans.modules.java.project.JavaProjectSettings;
import org.netbeans.spi.java.project.support.ui.Bundle;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class BrokenReferencesSupport {
    private static final RequestProcessor RP = new RequestProcessor(BrokenReferencesSupport.class);
    private static final boolean suppressBrokenRefAlert = Boolean.getBoolean("BrokenReferencesSupport.suppressBrokenRefAlert");
    private static BrokenReferencesModel.Context context;
    private static RequestProcessor.Task rpTask;
    private static int BROKEN_ALERT_TIMEOUT;

    private BrokenReferencesSupport() {
    }

    public static boolean isBroken(AntProjectHelper projectHelper, ReferenceHelper referenceHelper, String[] properties, String[] platformProperties) {
        Parameters.notNull((CharSequence)"projectHelper", (Object)projectHelper);
        Parameters.notNull((CharSequence)"referenceHelper", (Object)referenceHelper);
        Parameters.notNull((CharSequence)"properties", (Object)properties);
        Parameters.notNull((CharSequence)"platformProperties", (Object)platformProperties);
        return BrokenReferencesModel.isBroken(projectHelper, referenceHelper, projectHelper.getStandardPropertyEvaluator(), properties, platformProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showCustomizer(AntProjectHelper projectHelper, ReferenceHelper referenceHelper, String[] properties, String[] platformProperties) {
        BrokenReferencesModel model = new BrokenReferencesModel(projectHelper, referenceHelper, properties, platformProperties);
        BrokenReferencesCustomizer customizer = new BrokenReferencesCustomizer(model);
        JButton close = new JButton(Bundle.LBL_BrokenLinksCustomizer_Close());
        close.getAccessibleContext().setAccessibleDescription(Bundle.ACSD_BrokenLinksCustomizer_Close());
        String projectDisplayName = "???";
        try {
            Project project = ProjectManager.getDefault().findProject(projectHelper.getProjectDirectory());
            if (project != null) {
                projectDisplayName = ProjectUtils.getInformation((Project)project).getDisplayName();
            }
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        DialogDescriptor dd = new DialogDescriptor((Object)customizer, Bundle.LBL_BrokenLinksCustomizer_Title(projectDisplayName), true, new Object[]{close}, (Object)close, 0, null, null);
        Dialog dlg = null;
        try {
            dlg = DialogDisplayer.getDefault().createDialog(dd);
            dlg.setVisible(true);
        }
        finally {
            if (dlg != null) {
                dlg.dispose();
            }
        }
    }

    public static void showAlert() {
        BrokenReferencesSupport.showAlertImpl(null);
    }

    public static void showAlert(@NonNull AntProjectHelper projectHelper, @NonNull ReferenceHelper referenceHelper, @NonNull PropertyEvaluator evaluator, @NonNull String[] properties, @NonNull String[] platformProperties) {
        Parameters.notNull((CharSequence)"projectHelper", (Object)projectHelper);
        Parameters.notNull((CharSequence)"referenceHelper", (Object)referenceHelper);
        Parameters.notNull((CharSequence)"evaluator", (Object)evaluator);
        Parameters.notNull((CharSequence)"properties", (Object)properties);
        Parameters.notNull((CharSequence)"platformProperties", (Object)platformProperties);
        BrokenReferencesSupport.showAlertImpl(new BrokenReferencesModel.BrokenProject(projectHelper, referenceHelper, evaluator, properties, platformProperties));
    }

    private static synchronized void showAlertImpl(@NullAllowed BrokenReferencesModel.BrokenProject broken) {
        if (!JavaProjectSettings.isShowAgainBrokenRefAlert() || suppressBrokenRefAlert) {
            return;
        }
        if (context == null) {
            assert (rpTask == null);
            final Runnable task = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<BrokenReferencesSupport> clazz = BrokenReferencesSupport.class;
                    synchronized (BrokenReferencesSupport.class) {
                        rpTask = null;
                        final BrokenReferencesModel.Context ctx = context;
                        // ** MonitorExit[var2_1] (shouldn't be in output)
                        if (ctx == null) {
                            return;
                        }
                        try {
                            final JButton resolveOption = new JButton(Bundle.CTL_Broken_References_Resolve());
                            resolveOption.getAccessibleContext().setAccessibleDescription(Bundle.AD_Broken_References_Resolve());
                            JButton closeOption = new JButton(Bundle.CTL_Broken_References_Close());
                            closeOption.getAccessibleContext().setAccessibleDescription(Bundle.AD_Broken_References_Close());
                            DialogDescriptor dd = new DialogDescriptor((Object)new BrokenReferencesAlertPanel(), Bundle.MSG_Broken_References_Title(), true, new Object[]{resolveOption, closeOption}, (Object)closeOption, 0, null, null);
                            dd.setMessageType(2);
                            ctx.addChangeListener(new ChangeListener(){

                                @Override
                                public void stateChanged(ChangeEvent e) {
                                    resolveOption.setVisible(!ctx.isEmpty());
                                }
                            });
                            resolveOption.setVisible(!ctx.isEmpty());
                            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == resolveOption) {
                                BrokenReferencesModel model = new BrokenReferencesModel(ctx, true);
                                BrokenReferencesCustomizer customizer = new BrokenReferencesCustomizer(model);
                                JButton close = new JButton(Bundle.LBL_Broken_References_Resolve_Panel_Close());
                                close.getAccessibleContext().setAccessibleDescription(Bundle.AD_Broken_References_Resolve_Panel_Close());
                                dd = new DialogDescriptor((Object)customizer, Bundle.LBL_Broken_References_Resolve_Panel_Title(), true, new Object[]{closeOption}, (Object)closeOption, 0, null, null);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                            }
                        }
                        finally {
                            clazz = BrokenReferencesSupport.class;
                            synchronized (BrokenReferencesSupport.class) {
                                context = null;
                                // ** MonitorExit[var2_1] (shouldn't be in output)
                            }
                        }
                        return;
                    }
                }
            };
            context = new BrokenReferencesModel.Context();
            rpTask = RP.create(new Runnable(){

                @Override
                public void run() {
                    WindowManager.getDefault().invokeWhenUIReady(task);
                }
            });
        }
        assert (context != null);
        if (broken != null) {
            context.offer(broken);
        }
        if (rpTask != null) {
            rpTask.schedule(BROKEN_ALERT_TIMEOUT);
        }
    }

    static {
        BROKEN_ALERT_TIMEOUT = 1000;
    }

    public static interface LibraryDefiner {
        @CheckForNull
        public Callable<Library> missingLibrary(String var1);
    }
}

