/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.xml.parsers;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.xml.sax.InputSource;

public final class DocumentInputSource
extends InputSource {
    private final Document doc;

    public DocumentInputSource(Document doc) {
        this.doc = doc;
    }

    public Reader getCharacterStream() {
        String text = DocumentInputSource.documentToString(this.doc);
        return new StringReader(text);
    }

    public final void setCharacterStream(Reader reader) {
    }

    public String getSystemId() {
        String system = super.getSystemId();
        if (system == null) {
            Object obj = this.doc.getProperty("stream");
            if (obj instanceof DataObject) {
                try {
                    DataObject dobj = (DataObject)obj;
                    FileObject fo = dobj.getPrimaryFile();
                    URL url = fo.getURL();
                    system = url.toExternalForm();
                }
                catch (IOException io) {
                    ErrorManager emgr = (ErrorManager)Lookup.getDefault().lookup(ErrorManager.class);
                    emgr.notify((Throwable)io);
                }
            } else {
                ErrorManager emgr = (ErrorManager)Lookup.getDefault().lookup(ErrorManager.class);
                emgr.log("XML:DocumentInputSource:Unknown stream description:" + obj);
            }
        }
        return system;
    }

    private static String documentToString(final Document doc) {
        final String[] str = new String[1];
        Runnable run = new Runnable(){

            public void run() {
                try {
                    str[0] = doc.getText(0, doc.getLength());
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        };
        doc.render(run);
        return str[0];
    }

    public String toString() {
        return "DocumentInputSource SID:" + this.getSystemId();
    }
}

