/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.rubinius;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ArraysUtil;

public class RubyTuple
extends RubyObject {
    private IRubyObject[] ary;

    public RubyTuple(Ruby runtime2, RubyClass metaclass, int size2) {
        super(runtime2, metaclass);
        this.ary = new IRubyObject[size2];
        RuntimeHelpers.fillNil(this.ary, runtime2);
    }

    public static void createTupleClass(Ruby runtime2) {
        RubyClass tupleClass = runtime2.getOrCreateModule("Rubinius").defineClassUnder("Tuple", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        tupleClass.setReifiedClass(RubyTuple.class);
        tupleClass.defineAnnotatedMethods(RubyTuple.class);
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static IRubyObject rbNew(ThreadContext context, IRubyObject tupleCls, IRubyObject cnt) {
        int size2 = (int)cnt.convertToInteger().getLongValue();
        return new RubyTuple(context.runtime, (RubyClass)tupleCls, size2);
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(ThreadContext context, IRubyObject idx) {
        return this.ary[(int)((RubyFixnum)idx).getLongValue()];
    }

    @JRubyMethod(name={"[]="})
    public IRubyObject op_aset(ThreadContext context, IRubyObject idx, IRubyObject val) {
        int index2 = (int)((RubyFixnum)idx).getLongValue();
        if (index2 >= this.ary.length) {
            this.ary = ArraysUtil.copyOf(this.ary, this.ary.length * 3 / 2 + 1);
        }
        this.ary[index2] = val;
        return this.ary[index2];
    }
}

