/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.interpolation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.interpolation.FeedbackEnabledValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.SimpleRecursionInterceptor;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.interpolation.util.StringUtils;

public class RegexBasedInterpolator
implements Interpolator {
    private String startRegex;
    private String endRegex;
    private List valueSources = new ArrayList();
    private List postProcessors = new ArrayList();

    public RegexBasedInterpolator() {
    }

    public RegexBasedInterpolator(String startRegex, String endRegex) {
        this.startRegex = startRegex;
        this.endRegex = endRegex;
    }

    public RegexBasedInterpolator(List valueSources) {
        this.valueSources.addAll(valueSources);
    }

    public RegexBasedInterpolator(String startRegex, String endRegex, List valueSources) {
        this.startRegex = startRegex;
        this.endRegex = endRegex;
        this.valueSources.addAll(valueSources);
    }

    public void addValueSource(ValueSource valueSource) {
        this.valueSources.add(valueSource);
    }

    public void removeValuesSource(ValueSource valueSource) {
        this.valueSources.remove(valueSource);
    }

    public void addPostProcessor(InterpolationPostProcessor postProcessor) {
        this.postProcessors.add(postProcessor);
    }

    public void removePostProcessor(InterpolationPostProcessor postProcessor) {
        this.postProcessors.remove(postProcessor);
    }

    public String interpolate(String input, String thisPrefixPattern, RecursionInterceptor recursionInterceptor) throws InterpolationException {
        if (recursionInterceptor == null) {
            recursionInterceptor = new SimpleRecursionInterceptor();
        }
        if (thisPrefixPattern != null && thisPrefixPattern.length() == 0) {
            thisPrefixPattern = null;
        }
        int realExprGroup = 2;
        Pattern expressionPattern = null;
        if (this.startRegex != null || this.endRegex != null) {
            expressionPattern = Pattern.compile(this.startRegex + thisPrefixPattern + this.endRegex);
        } else if (thisPrefixPattern != null) {
            expressionPattern = Pattern.compile("\\$\\{(" + thisPrefixPattern + ")?(.+?)\\}");
        } else {
            expressionPattern = Pattern.compile("\\$\\{(.+?)\\}");
            realExprGroup = 1;
        }
        return this.interpolate(input, recursionInterceptor, expressionPattern, realExprGroup);
    }

    private String interpolate(String input, RecursionInterceptor recursionInterceptor, Pattern expressionPattern, int realExprGroup) throws InterpolationException {
        String result = input;
        Matcher matcher = expressionPattern.matcher(result);
        while (matcher.find()) {
            String wholeExpr = matcher.group(0);
            String realExpr = matcher.group(realExprGroup);
            if (realExpr.startsWith(".")) {
                realExpr = realExpr.substring(1);
            }
            if (recursionInterceptor.hasRecursiveExpression(realExpr)) {
                throw new InterpolationException("Detected the following recursive expression cycle: " + recursionInterceptor.getExpressionCycle(realExpr), wholeExpr);
            }
            recursionInterceptor.expressionResolutionStarted(realExpr);
            Object value = null;
            Iterator it = this.valueSources.iterator();
            while (it.hasNext() && value == null) {
                ValueSource vs = (ValueSource)it.next();
                value = vs.getValue(realExpr);
            }
            if (value != null) {
                value = this.interpolate(String.valueOf(value), recursionInterceptor, expressionPattern, realExprGroup);
                if (this.postProcessors != null && !this.postProcessors.isEmpty()) {
                    it = this.postProcessors.iterator();
                    while (it.hasNext()) {
                        InterpolationPostProcessor postProcessor = (InterpolationPostProcessor)it.next();
                        Object newVal = postProcessor.execute(realExpr, value);
                        if (newVal == null) continue;
                        value = newVal;
                        break;
                    }
                }
                result = StringUtils.replace(result, wholeExpr, String.valueOf(value));
                matcher.reset(result);
            }
            recursionInterceptor.expressionResolutionFinished(realExpr);
        }
        return result;
    }

    public List getFeedback() {
        ArrayList messages = new ArrayList();
        Iterator it = this.valueSources.iterator();
        while (it.hasNext()) {
            List feedback;
            ValueSource vs = (ValueSource)it.next();
            if (!(vs instanceof FeedbackEnabledValueSource) || (feedback = ((FeedbackEnabledValueSource)vs).getFeedback()) == null || feedback.isEmpty()) continue;
            messages.addAll(feedback);
        }
        return messages;
    }

    public void clearFeedback() {
        Iterator it = this.valueSources.iterator();
        while (it.hasNext()) {
            ValueSource vs = (ValueSource)it.next();
            if (!(vs instanceof FeedbackEnabledValueSource)) continue;
            ((FeedbackEnabledValueSource)vs).clearFeedback();
        }
    }

    public String interpolate(String input, String thisPrefixPattern) throws InterpolationException {
        return this.interpolate(input, thisPrefixPattern, null);
    }

    public String interpolate(String input) throws InterpolationException {
        return this.interpolate(input, null, null);
    }

    public String interpolate(String input, RecursionInterceptor recursionInterceptor) throws InterpolationException {
        return this.interpolate(input, null, recursionInterceptor);
    }
}

