/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sonar.bootstrap;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.sonar.ExtensionsFactory;
import org.codehaus.mojo.sonar.bootstrap.ExceptionHandling;
import org.codehaus.mojo.sonar.bootstrap.MavenProjectConverter;
import org.sonar.runner.api.EmbeddedRunner;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public class RunnerBootstrapper {
    private final Log log;
    private final MavenSession session;
    private final SecDispatcher securityDispatcher;
    private final EmbeddedRunner runner;
    private final MavenProjectConverter mavenProjectConverter;
    private final ExtensionsFactory extensionsFactory;
    private String serverVersion;

    public RunnerBootstrapper(Log log, MavenSession session, SecDispatcher securityDispatcher, EmbeddedRunner runner, MavenProjectConverter mavenProjectConverter, ExtensionsFactory extensionsFactory) {
        this.log = log;
        this.session = session;
        this.securityDispatcher = securityDispatcher;
        this.runner = runner;
        this.mavenProjectConverter = mavenProjectConverter;
        this.extensionsFactory = extensionsFactory;
    }

    public void execute() throws IOException, MojoExecutionException {
        try {
            this.applyMasks();
            this.runner.start();
            this.serverVersion = this.runner.serverVersion();
            this.log.info((CharSequence)("SonarQube version: " + this.serverVersion));
            if (this.isVersionPriorTo5Dot2()) {
                if (this.supportsNewDependencyProperty()) {
                    this.runner.addExtensions(this.extensionsFactory.createExtensionsWithDependencyProperty().toArray());
                } else {
                    this.runner.addExtensions(this.extensionsFactory.createExtensions().toArray());
                }
            }
            if (this.log.isDebugEnabled()) {
                this.runner.setGlobalProperty("sonar.verbose", "true");
            }
            this.runner.runAnalysis(this.collectProperties());
            this.runner.stop();
        }
        catch (Exception e) {
            throw ExceptionHandling.handle(e, this.log);
        }
    }

    private void applyMasks() {
        this.runner.mask("org.slf4j.LoggerFactory");
        this.runner.unmask("org.slf4j.Logger");
        this.runner.unmask("org.slf4j.ILoggerFactory");
        this.runner.unmask("org.slf4j.Marker");
        this.runner.mask("org.slf4j.");
        this.runner.mask("ch.qos.logback.");
        this.runner.mask("org.sonar.");
        this.runner.mask("com.google.common");
        this.runner.unmask("");
    }

    private void checkDumpToFile(Properties props) {
        String dumpToFile = props.getProperty("sonarRunner.dumpToFile");
        if (dumpToFile != null) {
            this.runner.setGlobalProperty("sonarRunner.dumpToFile", dumpToFile);
        }
    }

    private Properties collectProperties() throws MojoExecutionException {
        Properties props = this.mavenProjectConverter.configure(this.session.getProjects(), this.session.getTopLevelProject(), this.session.getUserProperties());
        props.putAll((Map<?, ?>)this.decryptProperties(props));
        return props;
    }

    public Properties decryptProperties(Properties properties) {
        Properties newProperties = new Properties();
        try {
            for (String key : properties.stringPropertyNames()) {
                if (!key.contains(".password")) continue;
                this.decrypt(properties, newProperties, key);
            }
        }
        catch (Exception e) {
            this.log.warn((CharSequence)"Unable to decrypt properties", (Throwable)e);
        }
        return newProperties;
    }

    private void decrypt(Properties properties, Properties newProperties, String key) {
        try {
            String decrypted = this.securityDispatcher.decrypt(properties.getProperty(key));
            newProperties.setProperty(key, decrypted);
        }
        catch (SecDispatcherException e) {
            this.log.debug((CharSequence)("Unable to decrypt property " + key), (Throwable)e);
        }
    }

    public boolean supportsNewDependencyProperty() {
        return !this.isVersionPriorTo5Dot0();
    }

    public boolean isVersionPriorTo5Dot2() {
        DefaultArtifactVersion artifactVersion = new DefaultArtifactVersion(this.serverVersion);
        if (artifactVersion.getMajorVersion() < 5) {
            return true;
        }
        return artifactVersion.getMajorVersion() == 5 && artifactVersion.getMinorVersion() < 2;
    }

    public boolean isVersionPriorTo5Dot0() {
        DefaultArtifactVersion artifactVersion = new DefaultArtifactVersion(this.serverVersion);
        return artifactVersion.getMajorVersion() < 5;
    }
}

