/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tools.project.extras;

import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.tools.project.extras.RequiredPOMPropertyMissingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredPOMPropertyChecker {
    public static void checkForRequiredPOMProperty(MavenProject project, String property) throws RequiredPOMPropertyMissingException {
        Properties projectProperties = project.getProperties();
        if (projectProperties == null || !projectProperties.containsKey(property)) {
            throw new RequiredPOMPropertyMissingException(project, property);
        }
    }

    public static void checkForRequiredPOMProperties(MavenProject project, Collection<String> properties) throws RequiredPOMPropertyMissingException {
        HashSet<String> propsToCheck = new HashSet<String>(properties);
        HashSet<String> missingProperties = new HashSet<String>();
        Properties projectProperties = project.getProperties();
        if (projectProperties == null) {
            missingProperties.addAll(propsToCheck);
        } else {
            for (String property : propsToCheck) {
                if (projectProperties.containsKey(property)) continue;
                missingProperties.add(property);
            }
        }
        if (!missingProperties.isEmpty()) {
            throw new RequiredPOMPropertyMissingException(project, missingProperties);
        }
    }
}

