/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tools.project.extras;

public final class ProjectReleaseInfoUtils {
    private static final String VERSION_WITH_RELEASE_PATTERN = ".+-[0-9]+";

    private ProjectReleaseInfoUtils() {
    }

    public static String getBaseVersion(String version) {
        String[] versionParts = ProjectReleaseInfoUtils.splitVersionBaseAndRelease(version, false);
        return versionParts[0];
    }

    public static String getReleaseNumber(String version) {
        String[] versionParts = ProjectReleaseInfoUtils.splitVersionBaseAndRelease(version, true);
        return versionParts[1];
    }

    public static String formatImpliedReleaseNumberVersionRanges(String version) {
        if (version == null || version.length() < 1) {
            return version;
        }
        String[] versionParts = ProjectReleaseInfoUtils.splitVersionBaseAndRelease(version, false);
        String result = null;
        if (versionParts[1] == null) {
            int lastCharIdx = version.length() - 1;
            char lastChar = version.charAt(lastCharIdx);
            if (Character.isDigit(lastChar)) {
                int lastDigit = Integer.parseInt(version.substring(lastCharIdx));
                result = "[" + version + "," + version.substring(0, lastCharIdx) + (lastDigit + 1) + ")";
            } else if (Character.isLetter(lastChar)) {
                result = "[" + version + "," + version.substring(0, lastCharIdx) + (char)(lastChar + '\u0001') + ")";
            }
        }
        if (result == null) {
            result = version;
        }
        return result;
    }

    public static String[] splitVersionBaseAndRelease(String version, boolean zeroIsDefaultReleaseNumber) {
        String[] result = new String[2];
        if (version.matches(VERSION_WITH_RELEASE_PATTERN)) {
            int lastIdx = version.lastIndexOf(45);
            result[0] = version.substring(0, lastIdx);
            result[1] = version.substring(lastIdx + 1);
        } else {
            result[0] = version;
            result[1] = zeroIsDefaultReleaseNumber ? "0" : null;
        }
        return result;
    }
}

