/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.CompetenceTest;
import cz.cuni.amis.pogamut.sposh.elements.DriveCollection;
import cz.cuni.amis.pogamut.sposh.elements.LapElementsFactory;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.Trigger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TriggerTest {
    private DriveCollection owner;
    private CompetenceTest.DummyListener listener;
    private Trigger<?> trigger;
    private String[] senseNames;

    @Before
    public void setUp() {
        this.owner = LapElementsFactory.createDriveCollection();
        this.listener = new CompetenceTest.DummyListener();
        this.owner.addElementListener((PoshElementListener)this.listener);
        this.trigger = this.owner.getGoal();
        assert (this.trigger.isEmpty());
        for (String senseName : this.senseNames = new String[]{"first", "second", "third", "fourth", "fifth"}) {
            this.trigger.add(LapElementsFactory.createSense((String)senseName));
        }
    }

    private static void assertTriggerNames(Trigger<?> trigger, String[] senseNames, int ... nameIndexes) {
        for (int senseIndex = 0; senseIndex < trigger.size(); ++senseIndex) {
            String expectedName = senseNames[nameIndexes[senseIndex]];
            String senseName = trigger.get(senseIndex).getName();
            Assert.assertEquals((Object)expectedName, (Object)senseName);
        }
    }

    @Test
    public void moveSenseForward() {
        Sense movedSense = this.trigger.get(1);
        int newSenseIndex = 3;
        this.trigger.moveSense(newSenseIndex, movedSense);
        TriggerTest.assertTriggerNames(this.trigger, this.senseNames, 0, 2, 3, 1, 4, 5);
        Assert.assertEquals((Object)movedSense, (Object)this.listener.lastMovedChild);
        Assert.assertEquals((long)newSenseIndex, (long)this.listener.lastMovedNewPosition.intValue());
    }

    @Test
    public void moveSenseBack() {
        Sense movedSense = this.trigger.get(3);
        int newSenseIndex = 1;
        this.trigger.moveSense(newSenseIndex, movedSense);
        TriggerTest.assertTriggerNames(this.trigger, this.senseNames, 0, 3, 1, 2, 4, 5);
        Assert.assertEquals((Object)movedSense, (Object)this.listener.lastMovedChild);
        Assert.assertEquals((long)newSenseIndex, (long)this.listener.lastMovedNewPosition.intValue());
    }

    @Test
    public void moveSenseNoIndexChange() {
        Sense movedSense = this.trigger.get(3);
        int newSenseIndex = 3;
        this.trigger.moveSense(newSenseIndex, movedSense);
        TriggerTest.assertTriggerNames(this.trigger, this.senseNames, 0, 1, 2, 3, 4, 5);
        Assert.assertNull((Object)this.listener.lastMovedChild);
        Assert.assertNull((Object)this.listener.lastMovedNewPosition);
    }
}

