/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.CompetenceTest;
import cz.cuni.amis.pogamut.sposh.elements.IPropertyMethod;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import org.junit.Assert;

class PropertyTest<ELEMENT extends PoshElement, T> {
    private final String name;
    private final ELEMENT instance;
    private final IPropertyMethod<ELEMENT, T> method;
    private final T[] values;

    PropertyTest(String propertyName, ELEMENT instance, IPropertyMethod<ELEMENT, T> method, T ... values) {
        this.name = propertyName;
        this.instance = instance;
        this.method = method;
        this.values = values;
    }

    public void runTest() throws Exception {
        T oldValue = this.method.get(this.instance);
        for (T value : this.values) {
            Assert.assertEquals(oldValue, this.method.get(this.instance));
            CompetenceTest.DummyListener instanceListener = new CompetenceTest.DummyListener();
            this.instance.addElementListener((PoshElementListener)instanceListener);
            this.method.set(this.instance, value);
            Assert.assertEquals(value, this.method.get(this.instance));
            Assert.assertNotNull((Object)instanceListener.lastPropertyChange);
            Assert.assertEquals(oldValue, (Object)instanceListener.lastPropertyChange.getOldValue());
            Assert.assertEquals(value, (Object)instanceListener.lastPropertyChange.getNewValue());
            Assert.assertEquals((Object)this.name, (Object)instanceListener.lastPropertyChange.getPropertyName());
            this.instance.removeElementListener((PoshElementListener)instanceListener);
            oldValue = value;
        }
        Assert.assertEquals(oldValue, this.method.get(this.instance));
    }
}

